/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.util.BlockUtil;

public class WorldGenBlob
extends WorldGenerator {
    private final IBlockState blobBlock;
    private final int blobSize;
    private final boolean allowInWater;
    private final Collection<Block> validGroundBlocks;
    private final boolean enabled = true;

    public WorldGenBlob(IBlockState block, int size, Collection<Block> validGroundBlocks, boolean allowInWater) {
        super(false);
        this.blobBlock = block;
        this.blobSize = size;
        this.validGroundBlocks = Collections.unmodifiableCollection(validGroundBlocks);
        this.allowInWater = allowInWater;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        ((Object)((Object)this)).getClass();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(pos);
        while (true) {
            mpos.func_189536_c(EnumFacing.DOWN);
            if (mpos.func_177956_o() <= 3) break;
            if (!world.func_175623_d((BlockPos)mpos)) {
                IBlockState blockstate = world.func_180495_p((BlockPos)mpos);
                if (!this.allowInWater && (blockstate.func_185904_a() == Material.field_151586_h || BlockUtil.checkAreaMaterials(BlockUtil.MatchType.ANY, world, (BlockPos)mpos, 1, Material.field_151586_h))) {
                    return false;
                }
                if (this.validGroundBlocks.contains(blockstate.func_177230_c())) break;
            }
            --y;
        }
        if (mpos.func_177956_o() <= 3) {
            return false;
        }
        int k2 = this.blobSize;
        for (int l = 0; this.blobSize >= 0 && l < 3; ++l) {
            int sizeX = this.blobSize + rand.nextInt(2);
            int sizeY = this.blobSize + rand.nextInt(2);
            int sizeZ = this.blobSize + rand.nextInt(2);
            float f = (float)(sizeX + sizeY + sizeZ) * 0.333f + 0.5f;
            for (int bx = x - sizeX; bx <= x + sizeX; ++bx) {
                for (int bz = z - sizeZ; bz <= z + sizeZ; ++bz) {
                    for (int by = y - sizeY; by <= y + sizeY; ++by) {
                        float f1 = bx - x;
                        float f2 = bz - z;
                        float f3 = by - y;
                        if (!(f1 * f1 + f2 * f2 + f3 * f3 <= f * f)) continue;
                        this.placeBoulderBlock(world, new BlockPos(bx, by, bz), this.blobBlock);
                    }
                }
            }
            x += -(this.blobSize + 1) + rand.nextInt(2 + k2 * 2);
            z += -(this.blobSize + 1) + rand.nextInt(2 + k2 * 2);
            y += 0 - rand.nextInt(2);
        }
        return true;
    }

    private void placeBoulderBlock(World world, BlockPos targetPos, IBlockState boulderBlock) {
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(targetPos);
        Block targetBlock = world.func_180495_p(targetPos).func_177230_c();
        if (targetBlock.func_176200_f((IBlockAccess)world, targetPos)) {
            world.func_180501_a(targetPos, boulderBlock, 2);
            if (world.func_180495_p((BlockPos)mpos.func_189536_c(EnumFacing.UP)).func_177230_c() == Blocks.field_150398_cm) {
                world.func_180501_a((BlockPos)mpos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }
}

