/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco.collection;

import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoFlowersRTG;
import rtg.api.world.deco.DecoJungleCacti;
import rtg.api.world.deco.DecoTree;
import rtg.api.world.deco.collection.DecoCollectionBase;
import rtg.api.world.deco.helper.DecoHelperThisOrThat;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGCocosNucifera;
import rtg.api.world.gen.feature.tree.rtg.TreeRTGRhizophoraMucronata;

public class DecoCollectionJungle
extends DecoCollectionBase {
    public DecoCollectionJungle(BiomeConfig config) {
        super(config);
        TreeRTGRhizophoraMucronata mucronataTree = new TreeRTGRhizophoraMucronata(4, 5, 13.0f, 0.32f, 0.2f);
        mucronataTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE));
        mucronataTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.JUNGLE));
        mucronataTree.setMinTrunkSize(3);
        mucronataTree.setMaxTrunkSize(4);
        mucronataTree.setMinCrownSize(10);
        mucronataTree.setMaxCrownSize(27);
        this.addTree(mucronataTree);
        DecoTree mangroves = new DecoTree(new TreeRTGRhizophoraMucronata(4, 5, 13.0f, 0.32f, 0.2f));
        mangroves.setLoops(3);
        mangroves.setTreeType(DecoTree.TreeType.RTG_TREE);
        mangroves.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        mangroves.setTreeConditionChance(3);
        mangroves.setMaxY(160);
        DecoTree megaJungle = new DecoTree((WorldGenerator)new WorldGenMegaJungle(false, 10, 27, BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE), BlockUtil.getStateLeaf(BlockPlanks.EnumType.JUNGLE)));
        megaJungle.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE));
        megaJungle.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.JUNGLE));
        megaJungle.setMinTrunkSize(3);
        megaJungle.setMaxTrunkSize(4);
        megaJungle.setMinCrownSize(10);
        megaJungle.setMaxCrownSize(27);
        megaJungle.setLoops(3);
        megaJungle.setTreeType(DecoTree.TreeType.WORLDGEN);
        megaJungle.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        megaJungle.setTreeConditionChance(3);
        megaJungle.setMaxY(160);
        DecoHelperThisOrThat decoHelperThisOrThat = new DecoHelperThisOrThat(3, DecoHelperThisOrThat.ChanceType.NOT_EQUALS_ZERO, megaJungle, mangroves);
        this.addDeco(decoHelperThisOrThat);
        TreeRTGCocosNucifera nuciferaTree = new TreeRTGCocosNucifera();
        nuciferaTree.setMinTrunkSize(7);
        nuciferaTree.setMaxTrunkSize(9);
        nuciferaTree.setMinCrownSize(6);
        nuciferaTree.setMaxCrownSize(8);
        this.addTree(nuciferaTree);
        DecoTree palmCustom = new DecoTree(nuciferaTree);
        palmCustom.setLoops(1);
        palmCustom.setTreeType(DecoTree.TreeType.RTG_TREE);
        palmCustom.setTreeCondition(DecoTree.TreeCondition.RANDOM_CHANCE);
        palmCustom.setTreeConditionChance(4);
        palmCustom.setMaxY(160);
        this.addDeco(palmCustom);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.setLoops(1);
        decoFallenTree.getDistribution().setNoiseDivisor(100.0f);
        decoFallenTree.getDistribution().setNoiseFactor(5.0f);
        decoFallenTree.getDistribution().setNoiseAddend(0.8f);
        decoFallenTree.setLogConditionChance(3);
        decoFallenTree.setLogBlock(BlockUtil.getStateLog(BlockPlanks.EnumType.JUNGLE));
        decoFallenTree.setLeavesBlock(BlockUtil.getStateLeaf(BlockPlanks.EnumType.JUNGLE));
        decoFallenTree.setMinSize(4);
        decoFallenTree.setMaxSize(9);
        this.addDeco(decoFallenTree, config.ALLOW_LOGS.get());
        DecoFlowersRTG decoFlowersRTG = new DecoFlowersRTG().addFlowers(BlockFlower.EnumFlowerType.ORANGE_TULIP).setChance(4).setMaxY(120).setStrengthFactor(2.0f);
        this.addDeco(decoFlowersRTG);
        DecoJungleCacti decoJungleCacti = new DecoJungleCacti();
        decoJungleCacti.setStrengthFactor(8.0f);
        decoJungleCacti.setMaxY(120);
        decoJungleCacti.setSandOnly(false);
        decoJungleCacti.setExtraHeight(7);
        this.addDeco(decoJungleCacti, config.ALLOW_CACTUS.get());
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150341_Y.func_176223_P());
        decoBoulder.setChance(16);
        decoBoulder.setMaxY(95);
        decoBoulder.setStrengthFactor(2.0f);
        this.addDeco(decoBoulder);
    }
}

