/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;

public class DecoMushrooms
extends DecoBase {
    private float strengthFactor;
    private int maxY;
    private float randomFloat;
    @Deprecated
    private RandomType randomType;
    private int chance;
    private int loops;

    public DecoMushrooms() {
        this.setMaxY(255);
        this.setStrengthFactor(0.0f);
        this.setRandomType(RandomType.USE_CHANCE_VALUE);
        this.setRandomFloat(1.0f);
        this.setChance(1);
        this.setLoops(1);
        this.addDecoTypes(DecoBase.DecoType.MUSHROOM);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        if (TerrainGen.decorate((World)rtgWorld.world(), (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            switch (this.randomType) {
                case ALWAYS_GENERATE: {
                    this.setChance(1);
                    break;
                }
            }
            int loopCount = this.strengthFactor > 0.0f ? (int)this.strengthFactor : this.loops;
            for (int i = 0; i < loopCount; ++i) {
                if (rand.nextInt(this.chance) != 0) continue;
                BlockPos pos = DecoMushrooms.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), rand.nextInt(this.maxY), rand.nextInt(16));
                if (rand.nextBoolean()) {
                    new WorldGenBush(Blocks.field_150338_P).func_180709_b(rtgWorld.world(), rand, pos);
                    continue;
                }
                new WorldGenBush(Blocks.field_150337_Q).func_180709_b(rtgWorld.world(), rand, pos);
            }
        }
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoMushrooms setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoMushrooms setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public float getRandomFloat() {
        return this.randomFloat;
    }

    public DecoMushrooms setRandomFloat(float randomFloat) {
        this.randomFloat = randomFloat;
        return this;
    }

    public RandomType getRandomType() {
        return this.randomType;
    }

    public DecoMushrooms setRandomType(RandomType randomType) {
        this.randomType = randomType;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public DecoMushrooms setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getLoops() {
        return this.loops;
    }

    public DecoMushrooms setLoops(int loops) {
        this.loops = loops;
        return this;
    }

    @Deprecated
    public static enum RandomType {
        ALWAYS_GENERATE,
        USE_CHANCE_VALUE;

    }
}

