/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoShrub;
import rtg.api.world.deco.DecoTree;

public abstract class DecoBase {
    @Deprecated
    private ArrayList<DecoType> decoTypes = new ArrayList();
    private boolean checkRiver = false;
    private float minRiver = -2.0f;
    private float maxRiver;

    public DecoBase() {
        this.setMaxRiver(2.0f);
    }

    public static void tweakTreeLeaves(DecoTree deco, boolean checkDecay, boolean decayable) {
        if (deco.getLeavesBlock().func_177230_c() instanceof BlockLeaves) {
            IBlockState leaves = deco.getLeavesBlock().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(checkDecay)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(decayable));
            deco.setLeavesBlock(leaves);
        }
    }

    public static void tweakShrubLeaves(DecoShrub deco, boolean checkDecay, boolean decayable) {
        if (deco.getLeavesBlock().func_177230_c() instanceof BlockLeaves) {
            IBlockState leaves = deco.getLeavesBlock().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(checkDecay)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(decayable));
            deco.setLeavesBlock(leaves);
        }
    }

    static BlockPos getOffsetPos(ChunkPos pos) {
        return new BlockPos(pos.field_77276_a * 16 + 8, 0, pos.field_77275_b * 16 + 8);
    }

    public static int getRangedRandom(Random rand, int min, int max) {
        return min + rand.nextInt(max - min + 1);
    }

    @Deprecated
    public boolean properlyDefined() {
        return true;
    }

    public boolean preGenerate(float river) {
        return !this.checkRiver || !(river > this.maxRiver) && !(river < this.minRiver);
    }

    public abstract void generate(IRealisticBiome var1, RTGWorld var2, Random var3, ChunkPos var4, float var5, boolean var6);

    @Deprecated
    public void addDecoTypes(DecoType ... decos) {
        this.decoTypes.addAll(Arrays.asList(decos));
    }

    @Deprecated
    public ArrayList<DecoType> getDecoTypes() {
        return this.decoTypes;
    }

    @Deprecated
    public DecoBase setDecoTypes(ArrayList<DecoType> decoTypes) {
        this.decoTypes = decoTypes;
        return this;
    }

    public boolean isCheckRiver() {
        return this.checkRiver;
    }

    public DecoBase setCheckRiver(boolean checkRiver) {
        this.checkRiver = checkRiver;
        return this;
    }

    public float getMinRiver() {
        return this.minRiver;
    }

    public DecoBase setMinRiver(float minRiver) {
        this.minRiver = minRiver;
        return this;
    }

    public float getMaxRiver() {
        return this.maxRiver;
    }

    public DecoBase setMaxRiver(float maxRiver) {
        this.maxRiver = maxRiver;
        return this;
    }

    @Deprecated
    public static enum DecoType {
        BASE_BIOME_DECORATION,
        BIG_SHROOM,
        BOULDER,
        COBWEB,
        CACTUS,
        DEAD_BUSH,
        DESERT_WELL,
        FALLEN_LEAVES,
        FALLEN_TREE,
        FERN,
        FERN_DOUBLE,
        FLOWER,
        GRASS,
        GRASS_DOUBLE,
        LAYER,
        LEAVES,
        LILYPAD,
        MUSHROOM,
        PUMPKIN,
        REED,
        ROCK_SPIRE,
        SEAWEED,
        SHRUB,
        SPONGE,
        TEST,
        TREE,
        VINE,
        WHEAT,
        WORLDGEN;

    }
}

