/*
 * Decompiled with CFR 0.152.
 */
package rtg;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import rtg.api.RTGAPI;
import rtg.api.util.BlockUtil;
import rtg.api.util.Logger;

@Mod.EventBusSubscriber(modid="rtg")
public final class RTGConfig {
    public static final String LANG_ROOT = "rtgconfig.";
    private static Configuration config;

    private RTGConfig() {
    }

    public static void init(FMLPreInitializationEvent event) {
        if (config == null) {
            config = new Configuration(RTGAPI.getConfigPath().resolve(event.getSuggestedConfigurationFile().getName()).toFile());
        }
        config.load();
        Arrays.stream(Setting.values()).forEach(RTGConfig::generateProperty);
        RTGConfig.sync();
    }

    private static void sync() {
        config.getCategoryNames().stream().map(c -> config.getCategory(c)).forEach(cat -> cat.setLanguageKey(LANG_ROOT + cat.getQualifiedName()));
        if (config.hasChanged()) {
            Logger.debug("[RTGConfig#sync] Config changed; Saving...", new Object[0]);
            config.save();
        }
        Arrays.stream(Setting.values()).forEach(setting -> {
            switch (setting) {
                case worldTypeNotification: 
                case enableDebugging: 
                case additionalBiomeInfo: 
                case lushRiverbanksInDesert: 
                case rtgTreesFromSaplings: 
                case treesCanGenerateOnSand: 
                case shrubsBelowSurface: 
                case barkCoveredLogs: {
                    setting.setCurVal(RTGConfig.getProperty(setting).getBoolean());
                    break;
                }
                case patchBiome: 
                case shadowStoneBlock: 
                case shadowDesertBlock: {
                    setting.setCurVal(RTGConfig.getProperty(setting).getString());
                    break;
                }
                case surfaceBlendRadius: 
                case rtgTreeChance: {
                    setting.setCurVal(RTGConfig.getProperty(setting).getInt());
                    break;
                }
                case treeDensityMultiplier: {
                    setting.setCurVal(RTGConfig.getProperty(setting).getDouble());
                }
            }
        });
        RTGAPI.setShadowBlocks(RTGConfig.shadowStoneBlock(), RTGConfig.shadowDesertBlock());
    }

    private static Property generateProperty(Setting setting) {
        switch (setting.getType()) {
            case BOOLEAN: {
                return config.get(setting.getCategory(), setting.name(), ((Boolean)setting.getCurVal()).booleanValue(), setting.getComment()).setLanguageKey(setting.getLangKey()).setRequiresMcRestart(setting.reqRestart());
            }
            case STRING: {
                if (setting.isArray()) {
                    return config.get(setting.getCategory(), setting.name(), (String[])setting.getCurVal(), setting.getComment()).setLanguageKey(setting.getLangKey()).setRequiresMcRestart(setting.reqRestart());
                }
                return config.get(setting.getCategory(), setting.name(), (String)setting.getCurVal(), setting.getComment()).setLanguageKey(setting.getLangKey()).setRequiresMcRestart(setting.reqRestart());
            }
            case INTEGER: {
                return config.get(setting.getCategory(), setting.name(), ((Integer)setting.getCurVal()).intValue(), setting.getComment()).setMinValue(((Integer)setting.getMinVal()).intValue()).setMaxValue(((Integer)setting.getMaxVal()).intValue()).setLanguageKey(setting.getLangKey()).setRequiresMcRestart(setting.reqRestart());
            }
            case DOUBLE: {
                return config.get(setting.getCategory(), setting.name(), ((Double)setting.getCurVal()).doubleValue(), setting.getComment()).setMinValue(((Double)setting.getMinVal()).doubleValue()).setMaxValue(((Double)setting.getMaxVal()).doubleValue()).setLanguageKey(setting.getLangKey()).setRequiresMcRestart(setting.reqRestart());
            }
        }
        return config.get(setting.getCategory(), setting.name(), setting.getDefVal().toString(), setting.getComment()).setLanguageKey(setting.getLangKey()).setRequiresMcRestart(setting.reqRestart());
    }

    private static Property getProperty(Setting setting) {
        Property ret = null;
        if (config.hasCategory(setting.getCategory())) {
            ret = config.getCategory(setting.getCategory()).get(setting.name());
        }
        return ret != null ? ret : RTGConfig.generateProperty(setting);
    }

    public static boolean worldTypeNotification() {
        return (Boolean)Setting.worldTypeNotification.getCurVal();
    }

    public static boolean enableDebugging() {
        return (Boolean)Setting.enableDebugging.getCurVal();
    }

    public static boolean additionalBiomeInfo() {
        return (Boolean)Setting.additionalBiomeInfo.getCurVal();
    }

    public static Biome patchBiome() {
        String cfgBiome = (String)Setting.patchBiome.getCurVal();
        Biome biome = RTGConfig.getBiomeFromCfgString(cfgBiome);
        if (biome == null) {
            Logger.error("Erroneous patch biome set in config: {} (non-existant). Using default.", cfgBiome);
            return Biomes.field_76772_c;
        }
        return biome;
    }

    public static Set<String> getBlacklistMods() {
        return Arrays.stream((String[])Setting.blacklistMods.getCurVal()).collect(Collectors.toSet());
    }

    public static boolean lushRiverbanksInDesert() {
        return (Boolean)Setting.lushRiverbanksInDesert.getCurVal();
    }

    public static int surfaceBlendRadius() {
        return (Integer)Setting.surfaceBlendRadius.getCurVal();
    }

    @Nullable
    public static IBlockState shadowStoneBlock() {
        return BlockUtil.getBlockStateFromCfgString((String)Setting.shadowStoneBlock.getCurVal());
    }

    @Nullable
    public static IBlockState shadowDesertBlock() {
        return BlockUtil.getBlockStateFromCfgString((String)Setting.shadowDesertBlock.getCurVal());
    }

    public static boolean rtgTreesFromSaplings() {
        return (Boolean)Setting.rtgTreesFromSaplings.getCurVal();
    }

    public static int rtgTreeChance() {
        return (Integer)Setting.rtgTreeChance.getCurVal();
    }

    public static double treeDensityMultiplier() {
        return (Double)Setting.treeDensityMultiplier.getCurVal();
    }

    public static boolean treesCanGenerateOnSand() {
        return (Boolean)Setting.treesCanGenerateOnSand.getCurVal();
    }

    public static boolean shrubsBelowSurface() {
        return (Boolean)Setting.shrubsBelowSurface.getCurVal();
    }

    public static boolean barkCoveredLogs() {
        return (Boolean)Setting.barkCoveredLogs.getCurVal();
    }

    public static void toggleWorldTypeNotification() {
        RTGConfig.getProperty(Setting.worldTypeNotification).setValue(false);
        RTGConfig.sync();
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("rtg".equals(event.getModID())) {
            RTGConfig.sync();
        }
    }

    @Nullable
    public static Biome getBiomeFromCfgString(String cfgString) {
        ResourceLocation rl = new ResourceLocation(cfgString);
        return ForgeRegistries.BIOMES.containsKey(rl) ? (Biome)ForgeRegistries.BIOMES.getValue(rl) : null;
    }

    public static Biome getBiomeFromCfgString(String cfgString, Biome fallback) {
        Biome biome = RTGConfig.getBiomeFromCfgString(cfgString);
        return biome != null ? biome : fallback;
    }

    public static final class RTGGuiConfigFactory
    implements IModGuiFactory {
        public static final String LOCATION = "rtg.RTGConfig$RTGGuiConfigFactory";

        public void initialize(Minecraft mc) {
        }

        public boolean hasConfigGui() {
            return true;
        }

        public GuiScreen createConfigGui(GuiScreen parentScreen) {
            return new RTGGuiConfig(parentScreen);
        }

        @Nullable
        public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
            return null;
        }
    }

    public static final class RTGGuiConfig
    extends GuiConfig {
        RTGGuiConfig(GuiScreen parent) {
            super(parent, RTGGuiConfig.getElements(), "rtg", false, false, I18n.func_135052_a((String)"rtgconfig.title", (Object[])new Object[0]));
        }

        private static List<IConfigElement> getElements() {
            return config.getCategoryNames().stream().filter(cat -> !config.getCategory(cat).isChild()).map(cat -> new ConfigElement(config.getCategory(cat))).collect(Collectors.toList());
        }
    }

    public static enum Setting {
        worldTypeNotification(Property.Type.BOOLEAN, Category.client, "When enabled, this will display an informational message about RTG when entering the Customize World screen.\nThis will display once and automatically disable itself.", true),
        enableDebugging(Property.Type.BOOLEAN, Category.debug, "Enable extra debug logging.\n!This setting has a severe performance penalty. Only enable if you know what you are doing!", false),
        additionalBiomeInfo(Property.Type.BOOLEAN, Category.debug, "Enable the logging of additional biome information on startup.", false),
        patchBiome(Property.Type.STRING, Category.debug, "If RTG encounters an unsupported biome it will generate this biome instead.\nThis uses the standard ResourceLocation format: mod_id:biome_registry_name", (Object)"minecraft:plains"),
        blacklistMods(Property.Type.STRING, Category.debug, "A blacklist of mods whose biomes will never be supported, so ignore them.\nThis will only suppress log warnings during initialization.", "appliedenergistics2", "galacticraftcore", "galacticraftplanets", "extraplanets", "moreplanets", "twilightforest"),
        lushRiverbanksInDesert(Property.Type.BOOLEAN, Category.surface, "Set this to FALSE to prevent RTG from generating lush river bank decorations in hot biomes,\nlike Desert and Mesa. Lush decorations consist of tallgrass, trees, shrubs, and other flora.", true, true),
        surfaceBlendRadius(Property.Type.INTEGER, Category.surface, "The maximum distance surfaces will blend into eacother if enabled for two adjacent biomes.\nBy default, surface blending is only enabled for beaches. You can control that in biome settings", 32, 8, 32),
        shadowStoneBlock(Property.Type.STRING, Category.surface, "The block to use for stone terrain shadowing, typically seen on the cliffs of stone mountains.\nLeave blank to disable", (Object)"minecraft:stained_hardened_clay[color=cyan]", true),
        shadowDesertBlock(Property.Type.STRING, Category.surface, "The block to use for desert terrain shadowing, typically seen on the cliffs of desert mountains.\nLeave blank to disable", (Object)"minecraft:stained_hardened_clay[color=gray]", true),
        rtgTreesFromSaplings(Property.Type.BOOLEAN, Category.trees, "Set this to TRUE to allow RTG's custom trees to grow from vanilla saplings.\nRTG's custom trees can be grown only from the saplings that their leaves would\ndrop, and only in the biomes where they naturally generate.", true),
        rtgTreeChance(Property.Type.INTEGER, Category.trees, "1/x chance that a vanilla sapling will grow one of RTG's custom trees.\n1 = Always generate if possible, 2 = 50% chance, 4 = 25% chance, etc.", 2, 1, 20),
        treeDensityMultiplier(Property.Type.DOUBLE, Category.trees, "This setting allows you to alter the amount of RTG trees that generate globally in all biomes.\nThis setting is compounded with the density setting found in the biome configs and only affects trees generated by RTG.Trees generated by a biome's native decorator will adhere to their own density rules.\nvalues below 1.0 will decrease the amount of trees, values above 1.0 will increase the amount of treesThe combination of this value and the biome-specific value will never exceed 5.0", 1.0, 0.0, 5.0),
        treesCanGenerateOnSand(Property.Type.BOOLEAN, Category.trees, "Set this to FALSE to prevent trees from generating on sand.\nThis setting only affects trees generated by RTG. Trees generated by a biome's decorator\nwill adhere to their own generation rules. (RTG's Palm Trees ignore this setting.)", true),
        shrubsBelowSurface(Property.Type.BOOLEAN, Category.trees, "Set this to FALSE to prevent shrub trunks from generating below the surface.", true),
        barkCoveredLogs(Property.Type.BOOLEAN, Category.trees, "Set this to FALSE to prevent the trunks of RTG trees from using the 'all-bark' texture model.\nFor more information, visit http://minecraft.gamepedia.com/Wood#Block_data", true);

        private final Property.Type type;
        private final boolean isArray;
        private final Category category;
        private final String comment;
        private final boolean reqRestart;
        private final Object defVal;
        private final Object minVal;
        private final Object maxVal;
        private Object curVal;

        private Setting(Property.Type type, Category category, String comment, String ... defVal) {
            this(type, category, comment, (Object)defVal, null, null, false, true);
        }

        private Setting(Property.Type type, Category category, String comment, Object defVal) {
            this(type, category, comment, defVal, false);
        }

        private Setting(Property.Type type, Category category, String comment, Object defVal, boolean reqRestart) {
            this(type, category, comment, defVal, null, null, reqRestart, false);
        }

        private Setting(Property.Type type, Category category, @Nullable String comment, @Nullable Object defVal, Object minVal, Object maxVal) {
            this(type, category, comment, defVal, minVal, maxVal, false, false);
        }

        private Setting(Property.Type type, Category category, @Nullable String comment, @Nullable Object defVal, Object minVal, Object maxVal, boolean reqRestart, boolean isArray) {
            this.type = type;
            this.isArray = isArray;
            this.category = category;
            this.comment = comment;
            this.reqRestart = reqRestart;
            this.defVal = defVal;
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.curVal = defVal;
        }

        Property.Type getType() {
            return this.type;
        }

        boolean isArray() {
            return this.isArray;
        }

        String getCategory() {
            return this.category.toString();
        }

        String getComment() {
            return this.comment;
        }

        boolean reqRestart() {
            return this.reqRestart;
        }

        Object getDefVal() {
            return this.defVal;
        }

        @Nullable
        Object getMinVal() {
            return this.minVal;
        }

        @Nullable
        Object getMaxVal() {
            return this.maxVal;
        }

        Object getCurVal() {
            return this.curVal;
        }

        void setCurVal(Object val) {
            this.curVal = val;
        }

        private String getLangKey() {
            return RTGConfig.LANG_ROOT + this.getCategory() + "." + this.name();
        }
    }

    public static enum Category {
        client(null),
        common(null),
        debug(common),
        surface(common),
        trees(common);

        private final Category parent;

        private Category(Category parentIn) {
            this.parent = parentIn;
        }

        public String toString() {
            if (this.parent != null) {
                return this.parent.toString() + "." + this.name();
            }
            return this.name();
        }
    }
}

