/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import javax.activation.UnsupportedDataTypeException;
import javax.annotation.Nullable;
import net.silentchaos512.lib.config.ConfigBase;
import net.silentchaos512.lib.config.ConfigOption;
import net.silentchaos512.lib.util.I18nHelper;
import net.silentchaos512.lib.util.LogHelper;

public abstract class ConfigBaseNew
extends ConfigBase {
    public ConfigBaseNew(String modId) {
        super(modId);
    }

    public abstract I18nHelper i18n();

    public abstract LogHelper log();

    @Override
    public void load() {
        this.readAnnotatedFields();
    }

    private void readAnnotatedFields() {
        this.readAnnotatedFields(this.getClass());
    }

    private void readAnnotatedFields(Class<?> clazz) {
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            this.readAnnotatedFields(clazz2);
        }
        for (AnnotatedElement annotatedElement : clazz.getDeclaredFields()) {
            ConfigOption config = null;
            ConfigOption.Comment comment = null;
            ConfigOption.BooleanDefault booleanDefault = null;
            ConfigOption.RangeDouble rangeDouble = null;
            ConfigOption.RangeFloat rangeFloat = null;
            ConfigOption.RangeInt rangeInt = null;
            ConfigOption.RangeLong rangeLong = null;
            for (Annotation annotation : ((Field)annotatedElement).getDeclaredAnnotations()) {
                if (annotation instanceof ConfigOption) {
                    config = (ConfigOption)annotation;
                    continue;
                }
                if (annotation instanceof ConfigOption.Comment) {
                    comment = (ConfigOption.Comment)annotation;
                    continue;
                }
                if (annotation instanceof ConfigOption.RangeDouble) {
                    rangeDouble = (ConfigOption.RangeDouble)annotation;
                    continue;
                }
                if (annotation instanceof ConfigOption.RangeFloat) {
                    rangeFloat = (ConfigOption.RangeFloat)annotation;
                    continue;
                }
                if (annotation instanceof ConfigOption.RangeInt) {
                    rangeInt = (ConfigOption.RangeInt)annotation;
                    continue;
                }
                if (annotation instanceof ConfigOption.RangeLong) {
                    rangeLong = (ConfigOption.RangeLong)annotation;
                    continue;
                }
                if (!(annotation instanceof ConfigOption.BooleanDefault)) continue;
                booleanDefault = (ConfigOption.BooleanDefault)annotation;
            }
            if (config == null) continue;
            String commentTranslated = comment != null ? comment.value() : "";
            try {
                if (((Field)annotatedElement).getType() == Integer.TYPE) {
                    ((Field)annotatedElement).set(this, this.readInt((Field)annotatedElement, config, rangeInt, commentTranslated));
                    continue;
                }
                if (((Field)annotatedElement).getType() == Float.TYPE) {
                    ((Field)annotatedElement).set(this, Float.valueOf(this.readFloat((Field)annotatedElement, config, rangeFloat, commentTranslated)));
                    continue;
                }
                if (((Field)annotatedElement).getType() == Double.TYPE) {
                    ((Field)annotatedElement).set(this, this.readDouble((Field)annotatedElement, config, rangeDouble, commentTranslated));
                    continue;
                }
                if (((Field)annotatedElement).getType() == Long.TYPE) {
                    ((Field)annotatedElement).set(this, this.readLong((Field)annotatedElement, config, rangeLong, commentTranslated));
                    continue;
                }
                if (((Field)annotatedElement).getType() == Boolean.TYPE) {
                    ((Field)annotatedElement).set(this, this.readBoolean((Field)annotatedElement, config, booleanDefault, commentTranslated));
                    continue;
                }
                throw new UnsupportedDataTypeException("Don't know how to load config for type " + ((Field)annotatedElement).getType() + "!");
            }
            catch (IllegalAccessException ex) {
                this.log().error("Field \"{}\" is not accessible?", ((Field)annotatedElement).getName());
                this.log().catching(ex);
            }
            catch (UnsupportedDataTypeException ex) {
                this.log().error("Unknown field type", new Object[0]);
                this.log().catching(ex);
            }
        }
    }

    private double readDouble(Field field, ConfigOption config, @Nullable ConfigOption.RangeDouble range, String comment) throws IllegalAccessException {
        double defaultValue;
        double d = defaultValue = range != null ? range.value() : field.getDouble(this);
        if (range != null) {
            return this.loadDouble(config.name(), config.category(), defaultValue, range.min(), range.max(), comment);
        }
        return this.loadDouble(config.name(), config.category(), defaultValue, comment);
    }

    private float readFloat(Field field, ConfigOption config, @Nullable ConfigOption.RangeFloat range, String comment) throws IllegalAccessException {
        float defaultValue;
        float f = defaultValue = range != null ? range.value() : field.getFloat(this);
        if (range != null) {
            return this.loadFloat(config.name(), config.category(), defaultValue, range.min(), range.max(), comment);
        }
        return this.loadFloat(config.name(), config.category(), defaultValue, comment);
    }

    private int readInt(Field field, ConfigOption config, @Nullable ConfigOption.RangeInt range, String comment) throws IllegalAccessException {
        int defaultValue;
        int n = defaultValue = range != null ? range.value() : field.getInt(this);
        if (range != null) {
            return this.loadInt(config.name(), config.category(), defaultValue, range.min(), range.max(), comment);
        }
        return this.loadInt(config.name(), config.category(), defaultValue, comment);
    }

    private long readLong(Field field, ConfigOption config, @Nullable ConfigOption.RangeLong range, String comment) throws IllegalAccessException {
        long defaultValue;
        long l = defaultValue = range != null ? range.value() : field.getLong(this);
        if (range != null) {
            return this.loadLong(config.name(), config.category(), defaultValue, range.min(), range.max(), comment);
        }
        return this.loadLong(config.name(), config.category(), defaultValue, comment);
    }

    private Object readBoolean(Field field, ConfigOption config, @Nullable ConfigOption.BooleanDefault booleanDefault, String comment) throws IllegalAccessException {
        boolean defaultValue = booleanDefault != null ? booleanDefault.value() : field.getBoolean(this);
        return this.loadBoolean(config.name(), config.category(), defaultValue, comment);
    }
}

