/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelHelperSL {
    public static OBJModel loadModel(ResourceLocation resource) {
        try {
            return (OBJModel)OBJLoader.INSTANCE.loadModel(resource);
        }
        catch (Exception e) {
            throw new ReportedException(new CrashReport("Error making the model for " + resource, (Throwable)e));
        }
    }

    public static IModel retexture(OBJModel model, String toReplace, String replaceWith) {
        return model.retexture(ImmutableMap.of((Object)toReplace, (Object)replaceWith)).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
    }

    public static IBakedModel bake(IModel model) {
        return model.bake((IModelState)TRSRTransformation.identity(), Attributes.DEFAULT_BAKED_FORMAT, ModelLoader.defaultTextureGetter());
    }

    public static void renderModel(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        List quads = model.func_188616_a(null, null, 0L);
        quads.forEach(quad -> LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)color));
        tessellator.func_78381_a();
    }
}

