/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBaseDirectional;

public class TileEntityVaultItem
extends TileEntityVaultBaseDirectional {
    protected InventoryInternal inventory = new InventoryInternal((TileEntity)this, "internal", 3, "inv.vault.itembox");
    private InvWrapper inventoryWrapper = new InvWrapper((IInventory)this.inventory);
    private String[] displayData = new String[3];

    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        this.inventory.writeToNBT(nbtTag, "items");
    }

    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "Items");
    }

    protected void buildNBT_SyncOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SyncOnly(nbtTag);
        ItemStack[] contents = this.inventory.getContents();
        for (int slot = 0; slot < 3; slot = (int)((byte)(slot + 1))) {
            if (contents[slot] == null) continue;
            nbtTag.func_74778_a("displayData" + slot, contents[slot].func_190916_E() + "x ^%" + contents[slot].func_77977_a() + "%");
            this.displayData[slot] = contents[slot].toString();
        }
    }

    protected void processNBT_SyncOnly(NBTTagCompound nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        for (int slot = 0; slot < 3; slot = (int)((byte)(slot + 1))) {
            String[] parts;
            this.displayData[slot] = null;
            if (!nbtTag.func_74764_b("displayData" + slot) || (parts = nbtTag.func_74779_i("displayData" + slot).split("\\^")).length != 2 || parts[1].length() <= 2 || !(parts[1].startsWith("%") & parts[1].endsWith("%"))) continue;
            parts[1] = Localization.get((String)(parts[1].substring(1, parts[1].length() - 1) + ".name"));
            this.displayData[slot] = parts[0] + parts[1];
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            TileEntity oTile;
            if (facing != null && (oTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()))) != null && oTile.hasCapability(capability, facing)) {
                return (T)oTile.getCapability(capability, facing);
            }
            return (T)this.inventoryWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public void dropContent() {
        for (ItemStack stack : this.inventory.getContents()) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)stack);
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.inventory.func_191420_l();
    }

    @Override
    protected void tryTransfer(TileEntity tile) {
        IItemHandler handler;
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing.func_176734_d()) && (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing.func_176734_d())) != null) {
            for (int slotId = 0; slotId < this.inventory.func_70302_i_(); slotId = (int)((byte)(slotId + 1))) {
                if (this.inventory.func_70301_a(slotId).func_190926_b()) continue;
                for (int index = 0; index < handler.getSlots(); ++index) {
                    ItemStack source = this.inventory.func_70301_a(slotId).func_77946_l();
                    if (source.func_190926_b() || !handler.insertItem(index, source.func_77979_a(1), false).func_190926_b()) continue;
                    this.inventory.func_70298_a(slotId, 1);
                    this.inventory.func_70296_d();
                    return;
                }
            }
        }
    }

    @Override
    public List<String> getExtraHudInfo(List<String> info, boolean isWaila) {
        if (isWaila) {
            info.add(Localization.get((String)"hud.msg.stored") + " " + Localization.get((String)"hud.msg.item"));
            if (Strings.isNullOrEmpty((String)this.displayData[0]) && Strings.isNullOrEmpty((String)this.displayData[1]) && Strings.isNullOrEmpty((String)this.displayData[2])) {
                info.add(Localization.get((String)"hud.msg.none"));
            } else {
                for (int slot = 0; slot < 3; slot = (int)((byte)(slot + 1))) {
                    if (Strings.isNullOrEmpty((String)this.displayData[slot])) continue;
                    info.add(this.displayData[slot]);
                }
            }
        }
        return info;
    }
}

