/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityFacingBase;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.item.ItemBlockVault;
import shetiphian.multistorage.common.misc.FluidConcrete;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;
import shetiphian.multistorage.common.tileentity.TileEntityVaultItem;

public class TileEntityVaultCorer
extends TileEntityFacingBase
implements ITickable {
    private InventoryInternal invFuel = new InventoryInternal((TileEntity)this, "invFuel", 1, "inv.corer.fuel");
    private InventoryInternal invItems = new InventoryInternal((TileEntity)this, "invItems", 4, 1, "inv.corer.items");
    private int progress;
    private int charge;
    private int burnTime;
    private int burnValue;
    private EnumStage stage = EnumStage.IDLE;
    private final IModelState drillModelState = new DrillModelState();
    private final IModelState modelState = new ModelState();

    protected EnumFacing getDefaultFacing() {
        return EnumFacing.DOWN;
    }

    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        this.invFuel.writeToNBT(nbtTag);
        this.invItems.writeToNBT(nbtTag);
        nbtTag.func_74768_a("charge", this.charge);
        nbtTag.func_74768_a("burnTime", this.burnTime);
        nbtTag.func_74768_a("burnValue", this.burnValue);
    }

    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        this.invFuel.readFromNBT(nbtTag);
        this.invItems.readFromNBT(nbtTag);
        this.charge = nbtTag.func_74762_e("charge");
        this.burnTime = nbtTag.func_74762_e("burnTime");
        this.burnValue = nbtTag.func_74762_e("burnValue");
    }

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("stage", this.stage.toString());
        nbtTag.func_74768_a("progress", this.progress);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.stage = EnumStage.byName(nbtTag.func_74779_i("stage"));
        this.progress = nbtTag.func_74762_e("progress");
    }

    public IModelState getModelState() {
        return this.modelState;
    }

    public IModelState getDrillModelState() {
        return this.drillModelState;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack fuel = this.invFuel.func_70301_a(0);
        ItemStack[] items = this.invItems.getContents();
        if (this.progress < 0 && this.stage != EnumStage.FINISHED) {
            this.setStage(EnumStage.FINISHED);
        }
        BlockPos wallPos = this.func_174877_v().func_177972_a(this.getFacing());
        IBlockState state = this.func_145831_w().func_180495_p(wallPos);
        if (!(state.func_177230_c() instanceof BlockVault)) {
            return;
        }
        TileEntityVaultBase tile = BlockVault.getTile((IBlockAccess)this.func_145831_w(), wallPos);
        if (tile == null) {
            return;
        }
        if (FluidConcrete.getTypeFromStack(items[0]) == BlockVault.EnumType.WALL_WINDOW) {
            EnumFacing skip = this.getFacing().func_176734_d();
            for (EnumFacing side : EnumFacing.values()) {
                if (side == skip || !(BlockVault.getTile((IBlockAccess)this.func_145831_w(), wallPos.func_177972_a(side)) instanceof TileEntityVaultDoor)) continue;
                return;
            }
        }
        switch (this.stage) {
            case IDLE: {
                if (fuel.func_190926_b() || items[0].func_190926_b() || items[1].func_190926_b() || !items[2].func_190926_b() || !items[3].func_190926_b()) break;
                this.setStage(this.charge < 800 ? EnumStage.CHARGING : EnumStage.WORKING);
                break;
            }
            case CHARGING: {
                if (this.charge + this.progress >= 800) {
                    this.setStage(EnumStage.WORKING);
                    break;
                }
                if (this.burnTime > 0) {
                    --this.burnTime;
                    ++this.charge;
                    break;
                }
                int value = Math.max(TileEntityFurnace.func_145952_a((ItemStack)fuel) / 4, 1);
                if (!fuel.func_190926_b() && value > 0) {
                    this.burnValue = value;
                    this.burnTime = value;
                    fuel.func_190918_g(1);
                    if (fuel.func_190926_b()) {
                        this.invFuel.func_70299_a(0, fuel.func_77973_b().getContainerItem(fuel));
                    }
                    this.func_70296_d();
                    break;
                }
                this.setStage(EnumStage.IDLE);
                break;
            }
            case WORKING: {
                if (items[0].func_190926_b() || items[1].func_190926_b() || !items[2].func_190926_b() || !items[3].func_190926_b()) {
                    this.setStage(EnumStage.IDLE);
                } else if (this.progress + this.charge < 800) {
                    this.setStage(EnumStage.CHARGING);
                } else if (this.progress < 800) {
                    this.charge = MathHelper.func_76125_a((int)(this.charge - 1), (int)0, (int)800);
                    ++this.progress;
                } else {
                    List<BlockPos> doorList = tile.getDoorList();
                    BlockVault.EnumType newType = FluidConcrete.getTypeFromStack(items[0]);
                    if (newType != null) {
                        if (tile instanceof TileEntityVaultItem) {
                            ((TileEntityVaultItem)tile).dropContent();
                        }
                        BlockVault.EnumType oldType = BlockVault.getEnumType(state);
                        this.invItems.func_70299_a(2, new ItemStack(Values.blockVault, 1, oldType.getValue() + 20));
                        this.invItems.func_70299_a(0, ItemStack.field_190927_a);
                        Function.setBlock((World)this.func_145831_w(), (BlockPos)wallPos, (IBlockState)state.func_177226_a(BlockVault.VARIANT, (Comparable)((Object)newType)), (boolean)true);
                        this.func_145831_w().func_184133_a(null, wallPos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        EnumDyeColor color = EnumDyeColor.WHITE;
                        if (items[1].func_77973_b() instanceof ItemBlockVault) {
                            this.invItems.func_70299_a(3, new ItemStack(Items.field_151133_ar));
                            this.invItems.func_70299_a(1, ItemStack.field_190927_a);
                        } else {
                            IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler((ItemStack)items[1]);
                            if (handlerItem != null) {
                                FluidStack fluidStack = handlerItem.drain(1000, true);
                                if (fluidStack != null) {
                                    color = EnumDyeColor.func_176764_b((int)RGB16Helper.getSimpleColor((short)RGB16Helper.getIndexFor((int)fluidStack.getFluid().getColor(fluidStack))));
                                }
                                this.invItems.func_70299_a(3, handlerItem.getContainer());
                            } else {
                                this.invItems.func_70299_a(3, items[1]);
                            }
                            this.invItems.func_70299_a(1, ItemStack.field_190927_a);
                        }
                        tile = BlockVault.getTile((IBlockAccess)this.func_145831_w(), wallPos);
                        if (tile != null) {
                            tile.setDoorList(doorList);
                            tile.recolor(EnumFacing.UP, color);
                        }
                    }
                    this.progress = -200;
                    this.stage = EnumStage.FINISHED;
                }
                Function.syncTile((TileEntity)this);
                break;
            }
            case FINISHED: {
                if (this.progress < 0) {
                    ++this.progress;
                } else {
                    this.progress = 0;
                    this.stage = EnumStage.IDLE;
                }
                Function.syncTile((TileEntity)this);
            }
        }
    }

    public EnumStage getStage() {
        return this.stage;
    }

    private void setStage(EnumStage stage) {
        this.stage = stage;
        Function.syncTile((TileEntity)this);
    }

    public InventoryInternal getInvFuel() {
        return this.invFuel;
    }

    public InventoryInternal getInvItems() {
        return this.invItems;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int value) {
        this.progress = value;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int value) {
        this.charge = value;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int value) {
        this.burnTime = value;
    }

    public int getBurnValue() {
        return this.burnValue;
    }

    public void setBurnValue(int value) {
        this.burnValue = value;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int graphicSize) {
        return this.progress == 0 ? 0 : MathHelper.func_76125_a((int)this.progress, (int)0, (int)800) * graphicSize / 800;
    }

    @SideOnly(value=Side.CLIENT)
    public int getChargeScaled(int graphicSize) {
        return this.charge == 0 ? 0 : this.charge * graphicSize / 800;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelProgressScaled(int graphicSize) {
        return this.burnTime == 0 ? 0 : MathHelper.func_76125_a((int)(this.burnTime * graphicSize / this.burnValue), (int)1, (int)graphicSize);
    }

    public void dropContent() {
        for (ItemStack stack : this.invFuel.getContents()) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)stack);
        }
        for (ItemStack stack : this.invItems.getContents()) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)stack);
        }
    }

    public static boolean isItemCore(ItemStack stack) {
        return FluidConcrete.getTypeFromStack(stack) != null;
    }

    public static boolean isItemConcrete(ItemStack stack) {
        IFluidHandlerItem handler;
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockVault) {
            return stack.func_77952_i() == 100;
        }
        if (stack.func_190916_E() > 1) {
            stack = stack.func_77946_l().func_77979_a(1);
        }
        if ((handler = FluidUtil.getFluidHandler((ItemStack)stack)) != null) {
            FluidStack fluidStack = handler.drain(1000, false);
            return fluidStack != null && fluidStack.amount == 1000;
        }
        return false;
    }

    private class DrillModelState
    extends ModelState {
        private DrillModelState() {
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            UnmodifiableIterator parts;
            if (part.isPresent() && (parts = Models.getParts((IModelPart)part.get())).hasNext()) {
                String name = (String)parts.next();
                if (!parts.hasNext() && !this.getModelGroup().contains(name)) {
                    return Optional.of(TRSRTransformation.identity());
                }
            }
            return Optional.of(this.getTransform());
        }

        private List<String> getModelGroup() {
            if (this.modelGroup.isEmpty()) {
                this.modelGroup.add("drill");
            }
            return this.modelGroup;
        }

        private TRSRTransformation getTransform() {
            if (this.transform == null) {
                Matrix4f matrix = this.getMatrix(TileEntityVaultCorer.this.getFacing().func_176734_d());
                matrix.setScale(0.5f);
                Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
                matrix.setTranslation(vector3f);
                this.transform = new TRSRTransformation(matrix);
            }
            return this.transform;
        }
    }

    private class ModelState
    implements IModelState {
        TRSRTransformation transform;
        List<String> modelGroup = new ArrayList<String>();

        private ModelState() {
        }

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            UnmodifiableIterator parts;
            if (part.isPresent() && (parts = Models.getParts((IModelPart)part.get())).hasNext()) {
                String name = (String)parts.next();
                if (!parts.hasNext() && !this.getModelGroup().contains(name)) {
                    return Optional.of(TRSRTransformation.identity());
                }
            }
            return Optional.of(this.getTransform());
        }

        private List<String> getModelGroup() {
            if (this.modelGroup.isEmpty()) {
                this.modelGroup.add("riboncable");
                this.modelGroup.add("fuelport");
                this.modelGroup.add("exhaust");
                this.modelGroup.add("curcuits");
                this.modelGroup.add("heatsink");
                this.modelGroup.add("bolts");
                this.modelGroup.add("chassy");
            }
            return this.modelGroup;
        }

        private TRSRTransformation getTransform() {
            if (this.transform == null) {
                Matrix4f matrix = this.getMatrix(TileEntityVaultCorer.this.getFacing());
                matrix.setScale(0.5f);
                Vector3f vector3f = new Vector3f(0.5001f, 0.5001f, 0.5001f);
                matrix.setTranslation(vector3f);
                this.transform = new TRSRTransformation(matrix);
            }
            return this.transform;
        }

        Matrix4f getMatrix(EnumFacing facing) {
            switch (facing) {
                case DOWN: {
                    return ModelRotation.X0_Y0.getMatrix();
                }
                case UP: {
                    return ModelRotation.X180_Y0.getMatrix();
                }
                case SOUTH: {
                    return ModelRotation.X270_Y180.getMatrix();
                }
                case NORTH: {
                    return ModelRotation.X270_Y0.getMatrix();
                }
                case WEST: {
                    return ModelRotation.X270_Y270.getMatrix();
                }
                case EAST: {
                    return ModelRotation.X270_Y90.getMatrix();
                }
            }
            return ModelRotation.X0_Y0.getMatrix();
        }
    }

    public static enum EnumStage {
        IDLE,
        CHARGING,
        WORKING,
        FINISHED;


        private static EnumStage byName(String name) {
            for (EnumStage value : EnumStage.values()) {
                if (!value.toString().equalsIgnoreCase(name)) continue;
                return value;
            }
            return IDLE;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

