/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;

public abstract class TileEntityStorageBase
extends TileEntityBase
implements IContainerCallback {
    protected InventoryInternal inventory = new InventoryInternal((TileEntity)this, "internal", this.getChestSize(), this.getInvName());
    InvWrapper inventoryWrapper = new InvWrapper((IInventory)this.inventory);
    private int numUsingPlayers;
    private EnumFacing facing;

    protected abstract String getInvName();

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("facing", this.getFacing().func_176610_l());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
    }

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.writeToNBT(nbtTag, "items");
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "Items");
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing != null ? this.facing : EnumFacing.NORTH;
    }

    public void dropItems() {
        for (ItemStack stack : this.inventory.getContents()) {
            if (stack.func_190926_b()) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)stack);
        }
        Function.updateLighting((TileEntity)this);
        this.func_145831_w().func_175666_e(this.field_174879_c, this.func_145838_q());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IInventory getChest() {
        return this.inventory;
    }

    protected abstract int getChestSize();

    public boolean canInteractWith(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void onContainerOpen(EntityPlayer player) {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        if (!player.func_175149_v()) {
            ++this.numUsingPlayers;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
        }
    }

    public void onContainerClosed(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numUsingPlayers;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
        }
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

