/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.multistorage.common.inventory.InventoryQueue;
import shetiphian.multistorage.common.misc.InventoryHelper;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;

public class TileEntityQueue
extends TileEntityStorageBase
implements ISidedWrapper {
    private ISidedWrapper.SidedWrapper sidedWrapper;
    private List<ITextComponent> listQueueDisplay = new ArrayList<ITextComponent>();
    public boolean insertHead = true;
    public boolean triggered;
    private NBTTagCompound dataTag;

    public TileEntityQueue() {
        this.inventory = new InventoryQueue(this, 1);
        this.setup();
    }

    protected void setup() {
        InventoryQueue inv = this.getInventoryQueue();
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperHIO(), inv.getWrapperHI(), inv.getWrapperHO(), inv.getWrapperHO(), inv.getWrapperHO(), inv.getWrapperTIO(), inv.getWrapperTI(), inv.getWrapperTO(), inv.getWrapperTO(), inv.getWrapperTO()});
        this.sidedWrapper.setFaceIndex(EnumFacing.DOWN, 5);
        this.sidedWrapper.setFaceIndex(EnumFacing.UP, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 1);
        this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 7);
        this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 1);
        this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 7);
    }

    public InventoryQueue getInventoryQueue() {
        return (InventoryQueue)this.inventory;
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        this.sidedWrapper.writeToNBT(nbtTag);
        nbtTag.func_74757_a("insertHead", this.insertHead);
        nbtTag.func_74757_a("triggered", this.triggered);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.sidedWrapper.readFromNBT(nbtTag);
        this.insertHead = nbtTag.func_74767_n("insertHead");
        this.triggered = nbtTag.func_74767_n("triggered");
    }

    protected void buildNBT_SyncOnly(NBTTagCompound nbtTag) {
        InventoryQueue queue = this.getInventoryQueue();
        nbtTag.func_74768_a("fill_override", queue.getFillLevel());
        queue.writeSlotsToNBT(nbtTag, "item_slots");
    }

    protected void processNBT_SyncOnly(NBTTagCompound nbtTag) {
        InventoryQueue queue = this.getInventoryQueue();
        queue.readSlotsFromNBT(nbtTag, "item_slots");
        queue.refresh();
        queue.setFillOverride(nbtTag.func_74762_e("fill_override"));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.sidedWrapper.getWrapper(EnumFacing.SOUTH, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.sidedWrapper.getWrapper(EnumFacing.SOUTH, facing);
        }
        return super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    @Override
    public int getChestSize() {
        return 4;
    }

    @Override
    protected String getInvName() {
        return "inv.queue";
    }

    public List<ITextComponent> getListQueueDisplay() {
        if (this.listQueueDisplay == null) {
            this.listQueueDisplay = new ArrayList<ITextComponent>();
        }
        return this.listQueueDisplay;
    }

    public NBTTagCompound getDataTag() {
        if (this.dataTag == null) {
            this.dataTag = new NBTTagCompound();
            this.dataTag.func_74773_a("indexes", this.getSidedWrapper().getIndexes());
        }
        return this.dataTag;
    }

    public boolean isFull() {
        return this.getInventoryQueue().isFull();
    }

    public float getFillPercentage() {
        return this.getInventoryQueue().getFillPercentage();
    }

    public void updateTick() {
        if (!this.triggered || this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        byte[] indexSide = this.sidedWrapper.getIndexes();
        for (EnumFacing facing : EnumFacing.values()) {
            byte value = indexSide[facing.func_176745_a()];
            if (value % 5 <= 2) continue;
            this.drop(this.func_145831_w(), this.func_174877_v(), facing, value < 5, value % 5 == 3);
        }
    }

    private void drop(World world, BlockPos pos, EnumFacing facing, boolean head, boolean single) {
        ItemStack stack = this.inventory.func_70301_a(head ? 1 : 3).func_77946_l();
        if (!stack.func_190926_b()) {
            ItemStack result;
            this.inventory.func_70299_a(head ? 1 : 3, ItemStack.field_190927_a);
            ItemStack dropStack = stack.func_77979_a(single ? 1 : stack.func_190916_E());
            BlockPos blockpos = pos.func_177972_a(facing);
            IItemHandler handler = InventoryHelper.getItemHandler(world.func_175625_s(blockpos), facing.func_176734_d());
            ItemStack itemStack = result = single ? stack : ItemStack.field_190927_a;
            if (handler == null) {
                double pX = (double)pos.func_177958_n() + (facing.func_176740_k() != EnumFacing.Axis.X ? 0.5 : 0.7 * (double)facing.func_82601_c());
                double pY = (double)pos.func_177956_o() + (facing.func_176740_k() != EnumFacing.Axis.Y ? 0.5 : 0.7 * (double)facing.func_96559_d());
                double pZ = (double)pos.func_177952_p() + (facing.func_176740_k() != EnumFacing.Axis.Z ? 0.5 : 0.7 * (double)facing.func_82599_e());
                EntityItem entityitem = new EntityItem(world, pX, pY, pZ, dropStack);
                if (facing == EnumFacing.DOWN) {
                    entityitem.field_70159_w = 0.0;
                    entityitem.field_70181_x = -0.2;
                    entityitem.field_70179_y = 0.0;
                } else {
                    double d3 = world.field_73012_v.nextDouble() * 0.1 + 0.2;
                    entityitem.field_70159_w = (double)facing.func_82601_c() * (facing.func_176740_k() == EnumFacing.Axis.Z ? d3 : d3 / 2.0);
                    entityitem.field_70181_x = 0.2;
                    entityitem.field_70179_y = (double)facing.func_82599_e() * (facing.func_176740_k() == EnumFacing.Axis.X ? d3 : d3 / 2.0);
                    entityitem.field_70159_w += world.field_73012_v.nextGaussian() * 0.0075 * 6.0;
                    entityitem.field_70181_x += world.field_73012_v.nextGaussian() * 0.0075 * 6.0;
                    entityitem.field_70179_y += world.field_73012_v.nextGaussian() * 0.0075 * 6.0;
                }
                world.func_72838_d((Entity)entityitem);
                world.func_175718_b(1000, pos, 0);
                world.func_175718_b(2000, pos, facing.func_82601_c() + 1 + (facing.func_82599_e() + 1) * 3);
                result = single ? stack : ItemStack.field_190927_a;
            } else {
                ItemStack remainder = InventoryHelper.insertStackAllSlots(handler, dropStack);
                if (!remainder.func_190926_b()) {
                    if (stack.func_190926_b()) {
                        result = remainder;
                    } else {
                        result = stack;
                        result.func_190917_f(remainder.func_190916_E());
                    }
                }
            }
            this.inventory.func_70299_a(head ? 0 : 2, result.func_190926_b() ? ItemStack.field_190927_a : result);
            Function.syncTile((TileEntity)this);
        } else {
            world.func_175718_b(1001, pos, 0);
        }
    }
}

