/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.misc;

import com.google.common.base.Charsets;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.UsernameCache;

public class UUIDHelper {
    public static UUID getCachedUUID(String name) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(name)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    public static String getCachedName(UUID uuid) {
        return UsernameCache.containsUUID((UUID)uuid) ? UsernameCache.getLastKnownUsername((UUID)uuid) : "";
    }

    public static boolean containsKey(UUID uuid) {
        return uuid != null && UsernameCache.containsUUID((UUID)uuid);
    }

    public static UUID getOfflineUUID(String name) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
    }

    public static UUID stringToUUID(String uuid) {
        try {
            return UUID.fromString(uuid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String fullUUID(String uuid) {
        uuid = UUIDHelper.cleanUUID(uuid);
        uuid = uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, 32);
        return uuid;
    }

    public static String cleanUUID(String uuid) {
        return uuid.replaceAll("[^a-zA-Z0-9]", "");
    }
}

