/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Logger;
import shetiphian.core.common.NBTFile;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.ChestData;

public class ChestHelper {
    public static final ChestHelper INSTANCE = new ChestHelper();
    private static final Table<String, String, ChestData> DATABASE = HashBasedTable.create();
    private static final Table<String, String, ChestData> CLIENT_CACHE = HashBasedTable.create();
    static boolean needsSaving = false;
    private static boolean isLoaded = false;
    private static String saveDir = null;
    private static DateTimeFormatter dateTime = DateTimeFormatter.ofPattern("yy-MM-dd-HH-mm");

    private static ChestData getChestData(String owner, String code, boolean isClient) {
        ChestData chestData = isClient ? (ChestData)((Object)CLIENT_CACHE.get((Object)owner.toLowerCase(), (Object)code.toUpperCase())) : (ChestData)((Object)DATABASE.get((Object)owner.toLowerCase(), (Object)code.toUpperCase()));
        if (chestData == null) {
            chestData = new ChestData(owner, code);
            ChestHelper.putChestData(owner, code, chestData, isClient);
        }
        return chestData;
    }

    private static void putChestData(String owner, String code, ChestData data, boolean isClient) {
        if (isClient) {
            CLIENT_CACHE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)data);
        } else {
            DATABASE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)data);
        }
    }

    public static IInventory getChest(World world, String owner, String code) {
        return ChestHelper.getChestData(owner, code, world.field_72995_K);
    }

    public static short getCapacity(World world, String owner, String code) {
        return (short)ChestHelper.getChestData(owner, code, world.field_72995_K).func_70302_i_();
    }

    public static void setCapacity(World world, String owner, String code, byte capacity) {
        ChestHelper.getChestData(owner, code, world.field_72995_K).setCapacity(capacity);
    }

    public void saveChestData(WorldEvent.Save event) {
        if (event.getWorld() == null || event.getWorld().field_72995_K || !needsSaving) {
            return;
        }
        if (!isLoaded) {
            Values.logMultiStorage.error("Attempted to save EnderLink Chest Data when nothing is loaded");
            return;
        }
        this.saveChestData();
    }

    private void saveChestData() {
        if (Strings.isNullOrEmpty((String)saveDir)) {
            saveDir = "sp_recovery" + File.separator + "enderchests" + File.separator + dateTime.format(LocalDateTime.now());
            Values.logMultiStorage.error("World Save Directory Unknown, Saving to Recovery Folder: " + saveDir);
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            NBTTagCompound fileNBT = new NBTTagCompound();
            for (Map.Entry pocket : networkMap.entrySet()) {
                if (!((ChestData)((Object)pocket.getValue())).saveCheck()) continue;
                NBTTagCompound nbtPocket = ((ChestData)((Object)pocket.getValue())).saveToNBT(new NBTTagCompound());
                fileNBT.func_74782_a((String)pocket.getKey(), (NBTBase)nbtPocket);
            }
            NBTFile.write((NBTTagCompound)fileNBT, (File)this.getSaveFile(owner), (Logger)Values.logMultiStorage);
        }
        needsSaving = false;
    }

    public void loadChestData() {
        Values.logMultiStorage.info("Loading EnderLink Chest Data");
        File root = DimensionManager.getCurrentSaveRootDirectory();
        if (root == null) {
            Values.logMultiStorage.error("Failed to Load Chest Data, World Save Directory Unknown");
            return;
        }
        saveDir = root + File.separator + "enderchests";
        List<File> fileList = this.getSaveFiles();
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            NBTTagCompound fileNBT = NBTFile.read((File)file, (Logger)Values.logMultiStorage);
            for (String code : fileNBT.func_150296_c()) {
                ChestHelper.putChestData(owner, code, new ChestData(owner, code).loadFromNBT(fileNBT.func_74775_l(code)), false);
            }
        }
        isLoaded = true;
    }

    public void unloadChestData() {
        if (isLoaded) {
            if (needsSaving) {
                this.saveChestData();
            }
            Values.logMultiStorage.info("Unloading EnderLink Chest Data");
        }
        CLIENT_CACHE.clear();
        DATABASE.clear();
        isLoaded = false;
        saveDir = null;
    }

    private List<File> getSaveFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(String owner) {
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                Values.logMultiStorage.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }
}

