/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.multistorage.common.block.BlockStorageType;

public class ModelQueue
implements IModel {
    public static final ModelQueue INSTANCE = new ModelQueue((ImmutableMap<EnumPart, ModelResourceLocation>)ImmutableMap.of());
    private final ImmutableMap<EnumPart, ModelResourceLocation> models;

    private ModelQueue(ImmutableMap<EnumPart, ModelResourceLocation> models) {
        this.models = models;
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new BakedModelQueue(ModelQueue.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
    }

    private static ImmutableMap<EnumPart, IBakedModel> buildModels(ImmutableMap<EnumPart, ModelResourceLocation> models, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumPart key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)((ResourceLocation)models.get((Object)key)), (String)("Couldn't load MultiStorage:ModelQueue dependency: " + models.get((Object)key)));
            builder.put((Object)key, (Object)model.bake((IModelState)new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    public ModelQueue process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)EnumPart.BASE, (Object)this.getLocation((String)customData.get((Object)key)));
            }
            if ("over_io".equals(key)) {
                builder.put((Object)EnumPart.OVER_IO, (Object)this.getLocation((String)customData.get((Object)key)));
            }
            if (!"over_port".equals(key)) continue;
            builder.put((Object)EnumPart.OVER_PORT, (Object)this.getLocation((String)customData.get((Object)key)));
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new ModelQueue((ImmutableMap<EnumPart, ModelResourceLocation>)models);
    }

    private ModelResourceLocation getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new ModelResourceLocation(e.getAsString());
        }
        FMLLog.severe((String)"Expect ModelResourceLocation, got: ", (Object[])new Object[]{json});
        return new ModelResourceLocation("builtin/missing", "missing");
    }

    static enum EnumPart {
        BASE,
        OVER_IO,
        OVER_PORT;

    }

    private static class BakedModelQueue
    implements IBakedModel {
        private final ImmutableMap<EnumPart, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;
        private final IBakedModel base;
        private final IBakedModel missing;
        private final List<BakedQuad> EMPTY_LIST = new ArrayList<BakedQuad>();

        BakedModelQueue(ImmutableMap<EnumPart, IBakedModel> models, IBakedModel missing, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = (IBakedModel)models.getOrDefault((Object)EnumPart.BASE, (Object)missing);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            byte[] indexes;
            byte value;
            IExtendedBlockState eState;
            NBTTagCompound nbtTag;
            IBakedModel model = null;
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null || layer == BlockRenderLayer.SOLID) {
                model = (IBakedModel)this.models.getOrDefault((Object)EnumPart.BASE, (Object)this.missing);
            } else if (layer == BlockRenderLayer.TRANSLUCENT && side != null && (this.models.containsKey((Object)EnumPart.OVER_IO) || this.models.containsKey((Object)EnumPart.OVER_PORT)) && state instanceof IExtendedBlockState && (nbtTag = (NBTTagCompound)(eState = (IExtendedBlockState)state).getValue((IUnlistedProperty)BlockStorageType.DATA)) != null && nbtTag.func_74764_b("indexes") && (value = (indexes = nbtTag.func_74770_j("indexes"))[side.func_176745_a()]) >= 0) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                model = (IBakedModel)this.models.get((Object)EnumPart.OVER_IO);
                if (model != null) {
                    quads.addAll(model.func_188616_a(state, side, rand));
                }
                if (value % 5 > 2 && (model = (IBakedModel)this.models.get((Object)EnumPart.OVER_PORT)) != null) {
                    quads.addAll(model.func_188616_a(state, side, rand));
                }
                return quads;
            }
            return model != null ? model.func_188616_a(state, side, rand) : this.EMPTY_LIST;
        }

        public boolean func_177555_b() {
            return this.base.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.base.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.base.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

