/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.misc;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.client.gui.ButtonEnderPocket;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.network.NetworkHandler;
import shetiphian.multistorage.common.network.PacketEnderPocket;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;

public class EventHandlerClient {
    private Minecraft mc = Minecraft.func_71410_x();
    private int pocketId = 6980;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void guiOverlayText(RenderGameOverlayEvent.Text event) {
        if (this.mc.field_71439_g.func_175140_cp() || this.mc.field_71474_y.field_178879_v) {
            return;
        }
        if (this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.mc.field_71476_x == null || this.mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK || this.mc.field_71476_x.func_178782_a() == null) {
            return;
        }
        BlockPos pos = this.mc.field_71476_x.func_178782_a();
        IBlockState state = this.mc.field_71441_e.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockStorageType)) {
            return;
        }
        BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
        if (type != BlockStorageType.EnumType.CHAMELEON && type != BlockStorageType.EnumType.DENSE_CHAMELEON) {
            return;
        }
        TileEntity tileEntity = this.mc.field_71441_e.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityChameleon)) {
            return;
        }
        TileEntityChameleon tileEntityChameleon = (TileEntityChameleon)tileEntity;
        String findme = String.valueOf(Block.field_149771_c.func_177774_c((Object)state.func_177230_c()));
        ArrayList<String> list = new ArrayList<String>();
        boolean found = false;
        for (String line : event.getRight()) {
            if (line.equals(findme)) {
                found = true;
                break;
            }
            list.add(line);
        }
        if (found) {
            BlockPos blockpos = tileEntityChameleon.getClonedPos();
            IBlockState iblockstate = tileEntityChameleon.getClonedState();
            if (this.mc.field_71441_e.func_175624_G() != WorldType.field_180272_g) {
                iblockstate = iblockstate.func_185899_b((IBlockAccess)this.mc.field_71441_e, blockpos);
            }
            list.add(String.valueOf(Block.field_149771_c.func_177774_c((Object)iblockstate.func_177230_c())));
            for (Map.Entry entry : iblockstate.func_177228_b().entrySet()) {
                String s = ((Comparable)entry.getValue()).toString();
                if (entry.getValue() == Boolean.TRUE) {
                    s = TextFormatting.GREEN + s;
                } else if (entry.getValue() == Boolean.FALSE) {
                    s = TextFormatting.RED + s;
                }
                list.add(((IProperty)entry.getKey()).func_177701_a() + ": " + s);
            }
            event.getRight().clear();
            event.getRight().addAll(list);
        }
    }

    @SubscribeEvent
    public void guiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        Point drawPos = this.getDrawPos(event.getGui(), true);
        if (drawPos != null && event.getGui() instanceof GuiContainer) {
            int size = 10;
            int buttonX = ((GuiContainer)event.getGui()).getGuiLeft() + drawPos.x;
            int buttonY = ((GuiContainer)event.getGui()).getGuiTop() + drawPos.y;
            event.getButtonList().add(new ButtonEnderPocket(this.pocketId, buttonX, buttonY, size));
        }
    }

    @SubscribeEvent
    public void guiPreDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        ButtonEnderPocket.disabled = this.getDrawPos(event.getGui(), false) == null;
    }

    @SubscribeEvent
    public void guiPostAction(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (this.getDrawPos(event.getGui(), false) != null && event.getButton().field_146127_k == this.pocketId) {
            NetworkHandler.sendToServer(new PacketEnderPocket());
        }
    }

    @SubscribeEvent
    public void guiPotionShift(GuiScreenEvent.PotionShiftEvent event) {
        if (Configuration.SETTINGS.ENDERPOCKET.enableEnderPocket && this.getDrawPos(event.getGui(), false) != null) {
            event.setCanceled(true);
        }
    }

    private Point getDrawPos(GuiScreen guiScreen, boolean ignoreTab) {
        if (Configuration.SETTINGS.ENDERPOCKET.enableEnderPocket) {
            int selectedTabIndex;
            if (guiScreen instanceof GuiInventory) {
                return Values.offsetEnderPocket[0];
            }
            if (guiScreen instanceof GuiContainerCreative && ((selectedTabIndex = ((GuiContainerCreative)guiScreen).func_147056_g()) == 11 || ignoreTab)) {
                return Values.offsetEnderPocket[1];
            }
        }
        return null;
    }
}

