/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage;

import com.google.common.base.Strings;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;

@Config(modid="multistorage", name="multistorage")
public class Configuration {
    @Config.RequiresMcRestart
    @Config.Comment(value={"Controls what blocks are added by MultiStorage", "Disabling a block after it was added will remove it from the world"})
    public static Menu_Blocks BLOCKS = new Menu_Blocks();
    @Config.RequiresMcRestart
    @Config.Comment(value={"Controls what items are added by MultiStorage", "Disabling an item after it was added will remove it from the world"})
    public static Menu_Items ITEMS = new Menu_Items();
    @Config.Comment(value={""})
    public static Menu_GUI GUI_STYLE = new Menu_GUI();
    @Config.Comment(value={" "})
    public static Menu_Settings SETTINGS = new Menu_Settings();

    @Mod.EventBusSubscriber
    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("multistorage")) {
                ConfigManager.sync((String)"multistorage", (Config.Type)Config.Type.INSTANCE);
                EventHandler.pre_process();
                EventHandler.process();
            }
        }

        static void pre_process() {
            if (Configuration.SETTINGS.VAULT.wallItems_Fluid.length == 1 && Configuration.SETTINGS.VAULT.wallItems_Fluid[0].equals("ore:blockGlass") && Configuration.SETTINGS.VAULT.wallItems_Window.length == 1 && Configuration.SETTINGS.VAULT.wallItems_Window[0].equals("ore:blockGlass")) {
                Configuration.SETTINGS.VAULT.wallItems_Fluid[0] = "minecraft:cauldron";
                ConfigManager.sync((String)"multistorage", (Config.Type)Config.Type.INSTANCE);
            }
            Values.wallBaseItems.clear();
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_Base, BlockVault.EnumType.WALL_NORMAL);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_Item, BlockVault.EnumType.WALL_ITEM);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_Redstone, BlockVault.EnumType.WALL_REDSTONE);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_Fluid, BlockVault.EnumType.WALL_FLUID);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_EU, BlockVault.EnumType.WALL_POWER_EU);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_RF, BlockVault.EnumType.WALL_POWER_RF);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_Caps, BlockVault.EnumType.WALL_POWER_CAPS);
            EventHandler.process(Configuration.SETTINGS.VAULT.wallItems_Window, BlockVault.EnumType.WALL_WINDOW);
        }

        static void process() {
            if (Values.wallBaseItems.isEmpty()) {
                EventHandler.pre_process();
            }
            Values.offsetEnderPocket = new Point[]{new Point(Configuration.SETTINGS.ENDERPOCKET.posXi, Configuration.SETTINGS.ENDERPOCKET.posYi), new Point(Configuration.SETTINGS.ENDERPOCKET.posXc, Configuration.SETTINGS.ENDERPOCKET.posYc)};
            Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMin = (byte)(Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMin / 3 * 3);
            Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMax = (byte)(Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMax / 3 * 3);
            if (Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMax < Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMin) {
                int temp = Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMin;
                Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMin = Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMax;
                Configuration.SETTINGS.ENDERLINK.UPGRADE_SETTINGS.chestSizeMax = temp;
            }
            Values.colorValues[0] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.white;
            Values.colorValues[1] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.orange;
            Values.colorValues[2] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.magenta;
            Values.colorValues[3] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.light_blue;
            Values.colorValues[4] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.yellow;
            Values.colorValues[5] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.lime;
            Values.colorValues[6] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.pink;
            Values.colorValues[7] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.gray;
            Values.colorValues[8] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.light_gray;
            Values.colorValues[9] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.cyan;
            Values.colorValues[10] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.purple;
            Values.colorValues[11] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.blue;
            Values.colorValues[12] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.brown;
            Values.colorValues[13] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.green;
            Values.colorValues[14] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.red;
            Values.colorValues[15] = Configuration.SETTINGS.ENDERLINK.COLOR_VALUES.black;
            EventHandler.process(Configuration.SETTINGS.ENDERLINK.UPGRADE_ITEMS.personalItems, Values.itemPersonal, new ItemStack(Items.field_151045_i));
            EventHandler.process(Configuration.SETTINGS.ENDERLINK.UPGRADE_ITEMS.teamItems, Values.itemTeam, new ItemStack(Items.field_151166_bC));
            EventHandler.process(Configuration.SETTINGS.ENDERLINK.UPGRADE_ITEMS.sCapacityItems, Values.itemCapacitySmall, new ItemStack(Items.field_151079_bi));
            EventHandler.process(Configuration.SETTINGS.ENDERLINK.UPGRADE_ITEMS.lCapacityItems, Values.itemCapacityLarge, new ItemStack(Items.field_151061_bv));
        }

        private static void process(String[] names, BlockVault.EnumType type) {
            ArrayList<Object> typeList = new ArrayList<Object>();
            for (String name : names) {
                Object object = EventHandler.getItem(name);
                if (object instanceof String) {
                    NonNullList ores = OreDictionary.getOres((String)((String)object));
                    if (ores.isEmpty()) continue;
                    typeList.add(object);
                    continue;
                }
                if (!(object instanceof ItemStack)) continue;
                typeList.add(object);
            }
            if (typeList.isEmpty() && type.getDefaultItem() != null) {
                typeList.add(type.getDefaultItem());
            }
            if (!typeList.isEmpty()) {
                Values.wallBaseItems.put(type, typeList);
            }
        }

        private static Object getItem(String name) {
            if (!Strings.isNullOrEmpty((String)name)) {
                ResourceLocation location;
                Item item;
                String nameId;
                String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
                String string = nameId = name.contains(":") ? name.split(":")[1] : name;
                if (modId.equalsIgnoreCase("ore") || modId.equalsIgnoreCase("oredictionary")) {
                    return nameId;
                }
                int meta = Short.MAX_VALUE;
                if (nameId.contains("@")) {
                    try {
                        meta = Integer.valueOf(nameId.split("@")[1]);
                        nameId = nameId.substring(0, nameId.lastIndexOf(64));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(location = new ResourceLocation(modId, nameId))) != null) {
                    return new ItemStack(item, 1, meta);
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
                if (block != null && block != Blocks.field_150350_a) {
                    return new ItemStack(block, 1, meta);
                }
            }
            return null;
        }

        private static void process(String[] names, ArrayList<ItemStack> list, ItemStack basic) {
            list.clear();
            for (String name : names) {
                String nameId;
                if (Strings.isNullOrEmpty((String)name)) continue;
                int meta = Short.MAX_VALUE;
                if (name.contains("@")) {
                    try {
                        meta = Integer.valueOf(name.split("@")[1]);
                        name = name.substring(0, name.lastIndexOf(64));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
                String string = nameId = name.contains(":") ? name.split(":")[1] : name;
                if (modId.equalsIgnoreCase("ore") || modId.equalsIgnoreCase("oredictionary")) {
                    NonNullList ores = OreDictionary.getOres((String)nameId);
                    for (ItemStack ore : ores) {
                        EventHandler.addToList(ore, list);
                    }
                    continue;
                }
                EventHandler.addToList(Function.findItemStack((String)modId, (String)nameId, (int)meta), list);
            }
            if (list.isEmpty()) {
                list.add(basic);
            }
        }

        private static void addToList(ItemStack stack, List<ItemStack> list) {
            if (list != null && !stack.func_190926_b() && !list.contains(stack)) {
                list.add(stack);
            }
        }
    }

    public static class Menu_Settings {
        @Config.Comment(value={" "})
        public SubMenu_Pocket ENDERPOCKET = new SubMenu_Pocket();
        @Config.Comment(value={" "})
        public SubMenu_Vault VAULT = new SubMenu_Vault();
        @Config.Comment(value={" "})
        public SubMenu_EnderLink ENDERLINK = new SubMenu_EnderLink();

        public static class SubMenu_Color {
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int white = 0xFFFFFF;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int orange = 14517579;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int magenta = 12411333;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int light_blue = 8296912;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int yellow = 12892206;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int lime = 4832573;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int pink = 14195370;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int gray = 0x464646;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int light_gray = 0xA9AFAF;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int cyan = 3373205;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int purple = 8996546;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int blue = 3292826;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int brown = 5650466;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int green = 3821086;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int red = 0xA53A35;
            @Config.RangeInt(min=0, max=0xFFFFFF)
            public int black = 0x262626;
        }

        public static class SubMenu_EnderLink {
            @Config.Comment(value={"With this disabled chests are essentially locked to the crafted color as dyes will no longer work"})
            public boolean enableInWorldRecoloring = true;
            @Config.Comment(value={"Items used to upgrade the EnderLinkChests"})
            public SubMenu_Upgrade UPGRADE_ITEMS = new SubMenu_Upgrade();
            @Config.Comment(value={" "})
            public SubMenu_Settings UPGRADE_SETTINGS = new SubMenu_Settings();
            @Config.Comment(value={" "})
            public SubMenu_Access ACCESS_SETTINGS = new SubMenu_Access();
            @Config.Comment(value={"Color Values for Bands,", "Format: Decimal Values (0 to 16,777,215)", "You can use this website to get the decimal value of any color:", "http://www.colorhexa.com", "Or by using the Color Mixer from this website:", "http://www.mathsisfun.com/hexadecimal-decimal-colors.html"})
            public SubMenu_Color COLOR_VALUES = new SubMenu_Color();

            public static class SubMenu_Access {
                @Config.Comment(value={"Enables the usage of public chests, if disabled chests must be upgraded before use"})
                public boolean allowPublicChests = true;
                @Config.Comment(value={"Enables the creation of personal chests, if disabled chests can not set personal.", "Does not effect chests that are already set as personal"})
                public boolean allowPersonalChests = true;
                @Config.Comment(value={"Enables the creation of team chests, if disabled chests can not be set team.", "Does not effect chests that are already set as team"})
                public boolean allowTeamChests = true;
                @Config.Comment(value={"Enables the usage of public bags, if disabled bags must be linked to an upgraded chest before use"})
                public boolean allowPublicBags = true;
                @Config.Comment(value={"Enables the linking of bags to personal chests.", "Does not effect bags that are already linked to personal chests"})
                public boolean allowPersonalBags = true;
                @Config.Comment(value={"Enables the linking of bags to team chests.", "Does not effect bags that are already linked to team chests"})
                public boolean allowTeamBags = true;
                @Config.Comment(value={"Public chests can be used with automation."})
                public boolean enableAutomationPublic = true;
                @Config.Comment(value={"Personal chests can be used with automation."})
                public boolean enableAutomationPersonal = true;
                @Config.Comment(value={"Team chests can be used with automation."})
                public boolean enableAutomationTeam = true;
                @Config.Comment(value={"While true a Personal chest can only be edited (upgrade, move, etc) by the owner"})
                public boolean lockPersonalEdit = true;
                @Config.Comment(value={"While true a Team chest can only be edited (upgrade, move, etc) by a team member"})
                public boolean lockTeamEdit = true;
                @Config.Comment(value={"While true only the owner can link a bag to their chests"})
                public boolean lockPersonalLink = true;
                @Config.Comment(value={"While true only a team member can link a bag to team chests"})
                public boolean lockTeamLink = true;
                @Config.Comment(value={"While true only the owner can use the chest"})
                public boolean lockPersonalUse = false;
                @Config.Comment(value={"While true only a team member can use the chest"})
                public boolean lockTeamUse = false;
            }

            public static class SubMenu_Settings {
                @Config.Comment(value={"Minimum capacity an EnderChest holds"})
                @Config.Name(value="CapacityMin")
                @Config.RangeInt(min=9, max=27)
                public int chestSizeMin = 9;
                @Config.Comment(value={"Maximum capacity an EnderChest holds"})
                @Config.Name(value="CapacityMax")
                @Config.RangeInt(min=9, max=54)
                public int chestSizeMax = 27;
            }

            public static class SubMenu_Upgrade {
                @Config.Comment(value={"Items Listed are used to make the chests personal"})
                @Config.Name(value="Personal")
                public String[] personalItems = new String[]{"ore:gemDiamond"};
                @Config.Comment(value={"Items Listed are used to make the chests team chests"})
                @Config.Name(value="Team")
                public String[] teamItems = new String[]{"ore:gemEmerald"};
                @Config.Comment(value={"Items Listed upgrade storage capacity by 3"})
                @Config.Name(value="SmallCapacity")
                public String[] sCapacityItems = new String[]{"ore:enderpearl"};
                @Config.Comment(value={"Items Listed upgrade storage capacity by 9"})
                @Config.Name(value="LargeCapacity")
                public String[] lCapacityItems = new String[]{"minecraft:ender_eye"};
            }
        }

        public static class SubMenu_Vault {
            @Config.Comment(value={"Sets who has permission to place a Vault Door.\n0 = No One, 1 = OP's Only, 2 = OP's and Creative Players, 3 = Everyone\nNOTE: Does not disable/remove existing Vaults"})
            @Config.RangeInt(min=0, max=3)
            public int permissionVault = 3;
            @Config.Comment(value={"Sets if Vault Blocks can be picked up.\n0 = Never, 1 = With SilkTouch, 2 = Always"})
            @Config.RangeInt(min=0, max=2)
            public int pickupVaultBlocks = 1;
            @Config.Comment(value={"By default only completed vaults are Wither Proof. When this is enabled vault blocks always are.\nWarning: While you can suffocate kill a Wither in a 5x5x5 vault its advised not to, as it is inside the top blocks and attacking it can push through them"})
            public boolean alwaysWitherProof = false;
            @Config.Comment(value={"Adds Vault Block crafting recipes\n0 = Only doors and concrete are craftable, everything else must be poured in world"})
            public boolean enableVaultWallRecipes = false;
            @Config.Comment(value={"While enabled Vaults can not be set to kill mode, any Vaults in kill mode will be changed to kick mode"})
            public boolean friendlyVaults = false;
            @Config.Comment(value={"These items are used to make normal vault walls"})
            public String[] wallItems_Base = new String[]{"minecraft:iron_bars"};
            @Config.Comment(value={"These items are used to make item pass vault walls"})
            public String[] wallItems_Item = new String[]{"minecraft:hopper", "xnet:connector@3"};
            @Config.Comment(value={"These items are used to make redstone pass vault walls"})
            public String[] wallItems_Redstone = new String[]{"ore:blockRedstone", "xnet:connector@1"};
            @Config.Comment(value={"These items are used to make fluid pass vault walls"})
            public String[] wallItems_Fluid = new String[]{"minecraft:cauldron", "xnet:connector@0"};
            @Config.Comment(value={"These items are used to make EU power pass vault walls"})
            public String[] wallItems_EU = new String[]{"ic2:cable@1"};
            @Config.Comment(value={"These items are used to make RF power pass vault walls"})
            public String[] wallItems_RF = new String[]{"buildcraft|transport:item.buildcraftPipe.pipepowerdiamond", "immersiveengineering:connector@5", "thermaldynamics:duct_0@2"};
            @Config.Comment(value={"These items are used to make Forge or Tesla power vault walls"})
            public String[] wallItems_Caps = new String[]{"enderio:itemPowerConduit@2", "integratedtunnels:part_interface_energy_item", "teslacoils:blockRelayCoil", "xnet:connector@2"};
            @Config.Comment(value={"These items are used to make windowed vault walls"})
            public String[] wallItems_Window = new String[]{"ore:blockGlass"};
            @Config.Comment(value={" "})
            public SubMenu_Logs LOGS = new SubMenu_Logs();

            public static class SubMenu_Logs {
                @Config.Comment(value={"Sets the size, in Kilobytes, a log file can be before it gets split.\n'-1' disables log files completely, '0' disables splitting\nNote: The default is 63 because notepad has trouble opening files that are 64k or larger"})
                @Config.RangeInt(min=-1, max=32767)
                public int logFileSize = 63;
                @Config.Comment(value={"Log when a player enters a vault"})
                public boolean logEntry = true;
                @Config.Comment(value={"Log when a player leaves a vault"})
                public boolean logExit = true;
                @Config.Comment(value={"Log when a player added to the access list"})
                public boolean logAdded = true;
                @Config.Comment(value={"Log when a player removed from the access list"})
                public boolean logRemoved = true;
                @Config.Comment(value={"Log when a player is promoted to a vault admin"})
                public boolean logPromoted = true;
                @Config.Comment(value={"Log when a player is demoted from a vault admin"})
                public boolean logDemoted = true;
            }
        }

        public static class SubMenu_Pocket {
            @Config.Comment(value={"Adds a button to the player inventory enabling access their Ender Chest"})
            public boolean enableEnderPocket = false;
            @Config.Comment(value={" "})
            @Config.Name(value="InventoryPositionLeft")
            public int posXi = 80;
            @Config.Comment(value={" "})
            @Config.Name(value="InventoryPositionTop")
            public int posYi = 48;
            @Config.Comment(value={" "})
            @Config.Name(value="CreativePositionLeft")
            public int posXc = 38;
            @Config.Comment(value={" "})
            @Config.Name(value="CreativePositionTop")
            public int posYc = 6;
        }
    }

    public static class Menu_GUI {
        public STYLE chameleon = STYLE.DEFAULT;
        public STYLE cloud_hopper = STYLE.DEFAULT;
        public STYLE cloud_junkbox = STYLE.DEFAULT;
        public STYLE cloud_queue = STYLE.DEFAULT;
        public STYLE cloud_storage = STYLE.DEFAULT;
        public STYLE corer = STYLE.DEFAULT;
        public STYLE enderlink = STYLE.DEFAULT;
        public STYLE junkbox = STYLE.DEFAULT;
        public STYLE queue = STYLE.DEFAULT;
        public STYLE storage = STYLE.DEFAULT;
        public STYLE vault = STYLE.DEFAULT;

        public static enum STYLE {
            DEFAULT,
            VANILLA;

        }
    }

    public static class Menu_Items {
        @Config.Comment(value={"Adds: A bag that accesses a players EnderChest", "NOTE: enableEnderBag/enableEnderLinkBag/addEnderLinkChests all use Id:ender_bag configs only adjust what sub items are available"})
        public boolean enableEnderBag = true;
        @Config.Comment(value={"Adds: EnderLinked Bags", "NOTE: enableEnderBag/enableEnderLinkBag/addEnderLinkChests all use Id:ender_bag configs only adjust what sub items are available"})
        public boolean enableEnderLinkBag = true;
    }

    public static class Menu_Blocks {
        @Config.Comment(value={"Adds: All Vault Blocks", "IDs: vault"})
        public boolean addVaultBlocks = true;
        @Config.Comment(value={"Adds: Stackable Chests, and Hidden Chests", "IDs: cloud_storage, stone_storage"})
        public boolean addStorageBlocks = true;
        @Config.Comment(value={"Adds: EnderLinked Chests", "IDs: ender_chest, ender_bag"})
        public boolean addEnderLinkChests = true;
    }
}

