/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.rsgauges.ModRsGauges;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.OverlayEventHandler;

public class Networking {
    private static SimpleNetworkWrapper netw;

    private static void preInitCommon() {
        netw = NetworkRegistry.INSTANCE.newSimpleChannel("rsgauges_a");
        netw.registerMessage(OverlayTextMessage.NetEventHandler.class, OverlayTextMessage.class, 44, Side.SERVER);
        netw.registerMessage(OverlayTextMessage.NetEventHandler.class, OverlayTextMessage.class, 44, Side.CLIENT);
    }

    public static void preInitServer() {
        if (!ModConfig.zmisc.without_switch_status_overlay) {
            Networking.preInitCommon();
        }
    }

    public static void preInitClient() {
        if (!ModConfig.zmisc.without_switch_status_overlay) {
            Networking.preInitCommon();
        }
    }

    public static class OverlayTextMessage
    implements IMessage {
        public static final int DISPLAY_TIME_MS = 3000;
        public static final byte MESSAGE_ID = 44;
        private TextComponentTranslation data_;

        private TextComponentTranslation data() {
            return this.data_;
        }

        public OverlayTextMessage() {
            this.data_ = new TextComponentTranslation("[unset]", new Object[0]);
        }

        public OverlayTextMessage(TextComponentTranslation tct) {
            this.data_ = tct.func_150259_f();
        }

        public static void sendToClient(EntityPlayerMP player, TextComponentTranslation message) {
            netw.sendTo((IMessage)new OverlayTextMessage(message), player);
        }

        public void fromBytes(ByteBuf buf) {
            try {
                this.data_ = (TextComponentTranslation)ITextComponent.Serializer.func_150699_a((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            catch (Throwable e) {
                this.data_ = new TextComponentTranslation("[incorrect translation]", new Object[0]);
            }
        }

        public void toBytes(ByteBuf buf) {
            try {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ITextComponent.Serializer.func_150696_a((ITextComponent)this.data()));
            }
            catch (Throwable e) {
                ModRsGauges.logger.error("OverlayTextMessage.toBytes() failed: " + e.toString());
            }
        }

        public static class NetEventHandler
        implements IMessageHandler<OverlayTextMessage, IMessage> {
            public IMessage onMessage(OverlayTextMessage message, MessageContext ctx) {
                if (ctx.side == Side.SERVER) {
                    NetEventHandler.server(message.data());
                } else {
                    NetEventHandler.client(message.data());
                }
                return null;
            }

            @SideOnly(value=Side.SERVER)
            private static void server(TextComponentTranslation message) {
            }

            @SideOnly(value=Side.CLIENT)
            private static void client(TextComponentTranslation message) {
                Minecraft minecraft = Minecraft.func_71410_x();
                minecraft.func_152344_a(() -> OverlayEventHandler.show(message, 3000));
            }
        }
    }
}

