/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.rsgauges.blocks.BlockSwitch;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.detail.ModResources;

public class BlockDoorSensorSwitch
extends BlockSwitch {
    public BlockDoorSensorSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config, powerOnSound, powerOffSound, material);
    }

    @Override
    public TileEntityDoorSensorSwitch getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityDoorSensorSwitch)) {
            return null;
        }
        return (TileEntityDoorSensorSwitch)te;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityDoorSensorSwitch();
    }

    public static class TileEntityDoorSensorSwitch
    extends BlockSwitch.TileEntitySwitch
    implements ITickable {
        private int update_timer_ = 0;

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = 4;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (state == null || !(state.func_177230_c() instanceof BlockDoorSensorSwitch)) {
                return;
            }
            BlockDoorSensorSwitch block = (BlockDoorSensorSwitch)state.func_177230_c();
            Vec3d door_vec = new Vec3d(((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176730_m());
            AxisAlignedBB volume = new AxisAlignedBB(this.func_174877_v().func_177977_b()).func_186662_g(0.4).func_191194_a(door_vec.func_186678_a(-0.5));
            boolean active = false;
            List hits = this.field_145850_b.func_72872_a(EntityPlayer.class, volume);
            if (hits.size() > 0) {
                Vec3d door_pos = new Vec3d((Vec3i)this.func_174877_v().func_177972_a((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_177977_b()).func_72441_c(0.5, 0.5, 0.5);
                for (Entity e : hits) {
                    Vec3d rel_position;
                    double cos_a2;
                    Vec3d look_vec;
                    double cos_a1;
                    if (Math.abs(e.func_70040_Z().field_72448_b) > 0.7 || (cos_a1 = (look_vec = new Vec3d(e.func_70040_Z().field_72450_a, 0.0, e.func_70040_Z().field_72449_c)).func_72430_b(door_vec)) < 0.5 || (cos_a2 = look_vec.func_72430_b(rel_position = new Vec3d(e.field_70165_t - door_pos.field_72450_a, 0.0, e.field_70161_v - door_pos.field_72449_c).func_72432_b())) > -0.8) continue;
                    active = true;
                    break;
                }
            }
            if (active) {
                if (!((Boolean)state.func_177229_b((IProperty)BlockSwitch.POWERED)).booleanValue()) {
                    block.onSwitchActivated(this.field_145850_b, this.field_174879_c, state, null, null);
                    this.on_timer_reset(12);
                } else {
                    this.on_timer_reset(12);
                    this.reschedule_block_tick();
                }
            }
        }
    }
}

