/*
 * Decompiled with CFR 0.152.
 */
package eutros.dynamistics.jei.plugins;

import eutros.dynamistics.helper.ItemHelper;
import eutros.dynamistics.jei.SingletonRecipe;
import eutros.dynamistics.jei.categories.ae2.PatternCategory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PatternPlugin
implements IRecipeRegistryPlugin {
    public static final IRecipeRegistryPlugin INSTANCE = new PatternPlugin();

    private PatternPlugin() {
    }

    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        ItemStack stack;
        if (focus.getValue() instanceof ItemStack && (stack = (ItemStack)focus.getValue()).func_77973_b() == ItemHelper.AE2.PATTERN && stack.func_77942_o()) {
            NBTTagCompound cmp = Objects.requireNonNull(stack.func_77978_p());
            return Collections.singletonList(PatternCategory.getUid(cmp.func_74767_n("crafting"), cmp.func_74767_n("substitute")));
        }
        return Collections.emptyList();
    }

    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        if (recipeCategory instanceof PatternCategory && ((ItemStack)focus.getValue()).func_77973_b() == ItemHelper.AE2.PATTERN) {
            return Collections.singletonList(new SingletonRecipe((ItemStack)focus.getValue(), focus.getMode() == IFocus.Mode.INPUT).cast());
        }
        return Collections.emptyList();
    }

    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        if (recipeCategory instanceof PatternCategory) {
            return Collections.singletonList(new SingletonRecipe(ItemHelper.AE2.EXAMPLE_PATTERN, true).cast());
        }
        return Collections.emptyList();
    }
}

