/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.compat.morpheus;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.api.INewDayHandler;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;
import net.silentchaos512.scalinghealth.world.ScalingHealthSavedData;

public class SHMorpheusCompat {
    public static void init() {
        INewDayHandler parent = null;
        if (Morpheus.register.isDimRegistered(0)) {
            parent = (INewDayHandler)MorpheusRegistry.registry.get(0);
        }
        NewDayHandler newHandler = new NewDayHandler(parent);
        ScalingHealth.logHelper.info("Replacing Morpheus new day handler for dimension {}!", new Object[]{0});
        ScalingHealth.logHelper.info("Parent handler: {}", new Object[]{parent});
        Morpheus.register.registerHandler((INewDayHandler)newHandler, 0);
    }

    public static class NewDayHandler
    implements INewDayHandler {
        INewDayHandler parent;

        public NewDayHandler(INewDayHandler parent) {
            this.parent = parent;
        }

        public void startNewDay() {
            MinecraftServer server;
            if (this.parent != null) {
                this.parent.startNewDay();
            }
            if ((server = FMLCommonHandler.instance().getMinecraftServerInstance()) == null) {
                return;
            }
            WorldServer world = server.field_71305_c[0];
            if (world == null) {
                return;
            }
            for (EntityPlayer player : world.func_175661_b(EntityPlayer.class, e -> true)) {
                SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
                if (data == null) continue;
                data.incrementDifficulty(Config.Difficulty.forSleeping, false);
            }
            ScalingHealthSavedData data = ScalingHealthSavedData.get((World)world);
            if (data != null) {
                data.difficulty += (double)Config.Difficulty.forSleeping;
            }
        }
    }
}

