/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.command;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.lib.command.CommandBaseSL;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.api.ScalingHealthAPI;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.event.DifficultyHandler;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageMarkBlight;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;

public class CommandRecalculate
extends CommandBaseSL {
    public String func_71517_b() {
        return "sh_recalculate";
    }

    public String func_71518_a(ICommandSender sender) {
        return TextFormatting.RED + "Usage: /" + this.func_71517_b();
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        int processed = CommandRecalculate.recalculateAllEntities(sender.func_130014_f_());
        ScalingHealth.LOGGER.info("Recalculated difficulty for {} entities, see details above", (Object)processed);
        TextComponentTranslation message = new TextComponentTranslation("command.scalinghealth.recalculate.result", new Object[]{processed});
        sender.func_145747_a((ITextComponent)message);
    }

    private static int recalculateAllEntities(World world) {
        int processed = 0;
        for (EntityLivingBase entity : world.func_175644_a(EntityLivingBase.class, e -> !(e instanceof EntityPlayer))) {
            boolean oldBlightFlag = BlightHandler.isBlight(entity);
            double oldDifficulty = ScalingHealthAPI.getEntityDifficulty(entity);
            double oldMaxHealth = ModifierHandler.getHealthModifier(entity);
            double oldAttackDamage = ModifierHandler.getDamageModifier(entity);
            BlightHandler.markBlight(entity, false);
            entity.func_70674_bp();
            if (!DifficultyHandler.INSTANCE.recalculate(entity)) continue;
            ++processed;
            boolean newBlightFlag = BlightHandler.isBlight(entity);
            double newDifficulty = ScalingHealthAPI.getEntityDifficulty(entity);
            double newMaxHealth = ModifierHandler.getHealthModifier(entity);
            double newAttackDamage = ModifierHandler.getDamageModifier(entity);
            if (oldBlightFlag != newBlightFlag) {
                MessageMarkBlight message = new MessageMarkBlight(entity, newBlightFlag);
                NetworkHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 128.0));
            }
            ScalingHealth.LOGGER.info("Recalculate {}: blight {} -> {}; difficulty {} -> {}; max health {} -> {}; attack damage {} -> {}", (Object)entity.func_70005_c_(), (Object)oldBlightFlag, (Object)newBlightFlag, (Object)oldDifficulty, (Object)newDifficulty, (Object)oldMaxHealth, (Object)newMaxHealth, (Object)oldAttackDamage, (Object)newAttackDamage);
        }
        return processed;
    }
}

