/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath.common.handler;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shinoow.beneath.Beneath;
import com.shinoow.beneath.common.handler.OreEntry;
import com.shinoow.beneath.common.util.JsonHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;

public class OreGenHandler {
    static List<OreEntry> oregen = new ArrayList<OreEntry>();

    public static void setupOregenFile() {
        File f = new File("config/beneath/oregen.json");
        if (!f.exists()) {
            OreGenHandler.generateDefault(f);
        } else {
            try {
                oregen = Streams.stream((Iterable)JsonHelper.ReadArrayFromFile(f)).filter(e -> e != null && e.isJsonObject()).map(e -> new OreEntry(e.getAsJsonObject())).collect(Collectors.toList());
            }
            catch (Exception e2) {
                Beneath.LOGGER.error("An error occurred while reading oregen.json, will use the default values instead", (Throwable)e2);
                OreGenHandler.generateDefault(f);
            }
        }
    }

    public static void saveOregenFile() {
        JsonArray l = new JsonArray();
        oregen.stream().map(OreEntry::toJson).forEach(j -> l.add((JsonElement)j));
        JsonHelper.WriteToFile(new File("config/beneath/oregen.json"), (JsonElement)l);
    }

    private static void generateDefault(File f) {
        OreEntry coal = new OreEntry(Blocks.field_150365_q.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 32, 16, 10, 246);
        OreEntry iron = new OreEntry(Blocks.field_150366_p.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 24, 16, 10, 246);
        OreEntry lapis = new OreEntry(Blocks.field_150369_x.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 12, 8, 10, 246);
        OreEntry redstone = new OreEntry(Blocks.field_150450_ax.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 12, 12, 10, 246);
        OreEntry gold = new OreEntry(Blocks.field_150352_o.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 8, 8, 10, 246);
        OreEntry diamond = new OreEntry(Blocks.field_150482_ag.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 4, 8, 10, 246);
        OreEntry emerald = new OreEntry(Blocks.field_150412_bA.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 2, 4, 10, 246);
        OreEntry silverfish = new OreEntry(Blocks.field_150418_aU.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 48, 24, 10, 246);
        JsonArray list = new JsonArray();
        JsonObject jBlk = new JsonObject();
        coal.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        iron.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        lapis.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        redstone.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        gold.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        diamond.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        emerald.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        silverfish.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        oregen = Streams.stream((Iterable)list).filter(e -> e != null && e.isJsonObject()).map(e -> new OreEntry(e.getAsJsonObject())).collect(Collectors.toList());
        JsonHelper.WriteToFile(f, (JsonElement)list);
    }

    public static List<OreEntry> getOregen() {
        return oregen;
    }
}

