/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.mixin.jei.craft.shared;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerPatternEncoder;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.packets.PacketJEIRecipe;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemStackHashStrategy;
import co.neeve.nae2.common.helpers.VirtualPatternDetails;
import co.neeve.nae2.common.interfaces.IExtendedCraftingGridCache;
import com.llamalad7.mixinextras.sugar.Local;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketJEIRecipe.class}, remap=false)
public class MixinPacketJEIRecipe {
    @Unique
    private boolean nae2$craft;
    @Unique
    private boolean nae2$autoStart;
    @Shadow
    private List<ItemStack[]> recipe;
    @Shadow
    private List<ItemStack> output;

    @Unique
    private static <T extends ItemStack> Object2IntMap<T> findOptimalIngredients(List<Set<T>> recipe, Hash.Strategy<T> strategy) {
        Object2IntOpenCustomHashMap bestIngredients = new Object2IntOpenCustomHashMap(strategy);
        int[] bestIngredientCount = new int[]{Integer.MAX_VALUE};
        MixinPacketJEIRecipe.backtrack(new Object2IntOpenCustomHashMap(strategy), recipe, 0, bestIngredients, bestIngredientCount);
        return bestIngredients;
    }

    @Unique
    private static <T> void backtrack(Object2IntMap<T> currentIngredients, List<Set<T>> recipe, int recipeIndex, Object2IntMap<T> bestIngredients, int[] bestIngredientCount) {
        if (recipeIndex == recipe.size()) {
            int currentIngredientCount = currentIngredients.size();
            if (currentIngredientCount < bestIngredientCount[0]) {
                bestIngredientCount[0] = currentIngredientCount;
                bestIngredients.clear();
                bestIngredients.putAll(currentIngredients);
            }
            return;
        }
        for (T ingredient : recipe.get(recipeIndex)) {
            currentIngredients.put(ingredient, (Integer)currentIngredients.getOrDefault(ingredient, (Object)0) + 1);
            MixinPacketJEIRecipe.backtrack(currentIngredients, recipe, recipeIndex + 1, bestIngredients, bestIngredientCount);
            int count = currentIngredients.getInt(ingredient) - 1;
            if (count == 0) {
                currentIngredients.removeInt(ingredient);
                continue;
            }
            currentIngredients.put(ingredient, count);
        }
    }

    @Inject(method={"<init>(Lio/netty/buffer/ByteBuf;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;getKeySet()Ljava/util/Set;", remap=true)})
    private void ctor(ByteBuf stream, CallbackInfo ci, @Local NBTTagCompound comp) {
        if (comp == null) {
            return;
        }
        NBTTagCompound nae2 = comp.func_74775_l("nae2");
        this.nae2$craft = nae2.func_74767_n("craft");
        this.nae2$autoStart = nae2.func_74767_n("autoStart");
    }

    @Inject(method={"serverPacketData"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/Container;onCraftMatrixChanged(Lnet/minecraft/inventory/IInventory;)V", remap=true)})
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player, CallbackInfo ci, @Local(name={"craftMatrix"}) IItemHandler craftMatrix, @Local ICraftingGrid crafting, @Local IGrid grid, @Local IContainerCraftingPacket cct) {
        if (!this.nae2$craft) {
            return;
        }
        if (player.field_71070_bA instanceof ContainerPatternEncoder) {
            return;
        }
        ContainerOpenContext context = ((AEBaseContainer)cct).getOpenContext();
        if (context == null) {
            return;
        }
        if (this.output.size() != 1) {
            return;
        }
        if (craftMatrix.getSlots() != 9) {
            return;
        }
        ItemStack outputIS = this.output.get(0);
        if (outputIS == null) {
            return;
        }
        if (outputIS.func_190926_b()) {
            return;
        }
        AEItemStack outputAIS = AEItemStack.fromItemStack((ItemStack)outputIS);
        if (outputAIS == null) {
            return;
        }
        InventoryCrafting testFrame = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        for (int i = 0; i < craftMatrix.getSlots(); ++i) {
            int slotID = i;
            Arrays.stream(this.recipe.get(i)).findFirst().ifPresent(itemStack -> testFrame.func_70299_a(slotID, itemStack));
        }
        IRecipe matchingRecipe = CraftingManager.func_192413_b((InventoryCrafting)testFrame, (World)player.field_70170_p);
        if (matchingRecipe == null) {
            return;
        }
        if (!ItemStack.func_77989_b((ItemStack)matchingRecipe.func_77571_b(), (ItemStack)outputIS)) {
            return;
        }
        ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAllButCount();
        ArrayList missingItems = new ArrayList();
        for (int i = 0; i < craftMatrix.getSlots(); ++i) {
            ItemStack[] stacksInRecipeSlot;
            ItemStack stackInSlot = craftMatrix.getStackInSlot(i);
            if (!stackInSlot.func_190926_b()) continue;
            ObjectOpenCustomHashSet recipe = new ObjectOpenCustomHashSet((Hash.Strategy)strategy);
            for (ItemStack stackInRecipeSlot : stacksInRecipeSlot = this.recipe.get(i)) {
                if (stackInRecipeSlot.func_190926_b() || crafting.getCraftingFor((IAEItemStack)AEItemStack.fromItemStack((ItemStack)stackInRecipeSlot), null, 0, null).size() <= 0) continue;
                recipe.add((Object)stackInRecipeSlot);
            }
            if (recipe.size() == 0) continue;
            missingItems.add((Set)recipe);
        }
        if (missingItems.isEmpty()) {
            return;
        }
        List<IAEItemStack> optimal = MixinPacketJEIRecipe.findOptimalIngredients(missingItems, strategy).entrySet().stream().map(entry -> (IAEItemStack)Objects.requireNonNull(AEItemStack.fromItemStack((ItemStack)((ItemStack)entry.getKey()))).setStackSize((long)((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
        VirtualPatternDetails pattern = new VirtualPatternDetails(optimal, this.output.stream().map(AEItemStack::fromItemStack).collect(Collectors.toList()));
        Future<ICraftingJob> futureJob = null;
        try {
            ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
            futureJob = ((IExtendedCraftingGridCache)cg).beginCraftingJobFromDetails(player.field_70170_p, grid, cct.getActionSource(), (IAEItemStack)outputAIS, pattern, null);
            TileEntity te = context.getTile();
            if (te != null) {
                Platform.openGUI((EntityPlayer)player, (TileEntity)te, (AEPartLocation)context.getSide(), (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM);
            } else {
                Container container = player.field_71070_bA;
                if (container instanceof IInventorySlotAware) {
                    IInventorySlotAware i = (IInventorySlotAware)container;
                    Platform.openGUI((EntityPlayer)player, (int)i.getInventorySlot(), (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM, (boolean)i.isBaubleSlot());
                }
            }
            Container container = player.field_71070_bA;
            if (container instanceof ContainerCraftConfirm) {
                ContainerCraftConfirm ccc = (ContainerCraftConfirm)container;
                ccc.setAutoStart(this.nae2$autoStart);
                ccc.setJob(futureJob);
            } else {
                futureJob.cancel(true);
            }
        }
        catch (Throwable e) {
            if (futureJob != null) {
                futureJob.cancel(true);
            }
            AELog.debug((Throwable)e);
        }
    }
}

