/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.registry.components;

import appeng.bootstrap.components.IPreInitComponent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class NAEBuiltInModelComponent
implements IPreInitComponent {
    private final Map<String, IModel> builtInModels = new HashMap<String, IModel>();
    private boolean hasInitialized = false;

    public void addModel(String path, IModel model) {
        Preconditions.checkState((!this.hasInitialized ? 1 : 0) != 0);
        this.builtInModels.put(path, model);
    }

    public void preInitialize(Side side) {
        this.hasInitialized = true;
        BuiltInModelLoader loader = new BuiltInModelLoader(this.builtInModels);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
    }

    public static class BuiltInModelLoader
    implements ICustomModelLoader {
        private final Map<String, IModel> builtInModels;

        public BuiltInModelLoader(Map<String, IModel> builtInModels) {
            this.builtInModels = ImmutableMap.copyOf(builtInModels);
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("nae2") && this.builtInModels.containsKey(modelLocation.func_110623_a());
        }

        @NotNull
        public IModel loadModel(ResourceLocation modelLocation) {
            return this.builtInModels.get(modelLocation.func_110623_a());
        }

        public void func_110549_a(@NotNull IResourceManager resourceManager) {
            for (IModel model : this.builtInModels.values()) {
                if (!(model instanceof IResourceManagerReloadListener)) continue;
                ((IResourceManagerReloadListener)model).func_110549_a(resourceManager);
            }
        }
    }
}

