/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.registry.builders;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IItemDefinition;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseItemBlock;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemRendering;
import appeng.bootstrap.components.IBlockRegistrationComponent;
import appeng.bootstrap.components.IItemRegistrationComponent;
import appeng.bootstrap.components.IPreInitComponent;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockDefinition;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.IStackSrc;
import appeng.core.features.TileDefinition;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import co.neeve.nae2.common.features.IFeature;
import co.neeve.nae2.common.integration.jei.NAEJEIPlugin;
import co.neeve.nae2.common.registration.definitions.CreativeTab;
import co.neeve.nae2.common.registration.registry.Registry;
import co.neeve.nae2.common.registration.registry.builders.INAEBlockBuilder;
import co.neeve.nae2.common.registration.registry.rendering.NAEBlockRendering;
import co.neeve.nae2.common.registration.registry.rendering.NAEItemRendering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NAEBlockDefinitionBuilder
implements INAEBlockBuilder {
    private final Registry registry;
    private final String registryName;
    private final Supplier<? extends Block> blockSupplier;
    private final List<BiFunction<Block, Item, IBootstrapComponent>> bootstrapComponents = new ArrayList<BiFunction<Block, Item, IBootstrapComponent>>();
    private final CreativeTabs creativeTab = CreativeTab.instance;
    @Nullable
    private IFeature[] features = null;
    private TileEntityDefinition tileEntityDefinition;
    private boolean disableItem = false;
    private Function<Block, ItemBlock> itemFactory;
    @SideOnly(value=Side.CLIENT)
    private NAEBlockRendering blockRendering;
    @SideOnly(value=Side.CLIENT)
    private NAEItemRendering itemRendering;
    @SideOnly(value=Side.CLIENT)
    private boolean jeiDescription;

    public NAEBlockDefinitionBuilder(Registry registry, String id, Supplier<? extends Block> blockSupplier) {
        this.registry = registry;
        this.registryName = id;
        this.blockSupplier = blockSupplier;
        if (Platform.isClient()) {
            this.blockRendering = new NAEBlockRendering();
            this.itemRendering = new NAEItemRendering();
        }
    }

    @Override
    public NAEBlockDefinitionBuilder bootstrap(BiFunction<Block, Item, IBootstrapComponent> callback) {
        this.bootstrapComponents.add(callback);
        return this;
    }

    @Override
    public INAEBlockBuilder features(IFeature ... features) {
        this.features = features;
        return this;
    }

    @Override
    public NAEBlockDefinitionBuilder rendering(BlockRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public INAEBlockBuilder tileEntity(TileEntityDefinition tileEntityDefinition) {
        this.tileEntityDefinition = tileEntityDefinition;
        return this;
    }

    @Override
    public INAEBlockBuilder useCustomItemModel() {
        this.rendering(new BlockRenderingCustomizer(){

            @SideOnly(value=Side.CLIENT)
            public void customize(IBlockRendering rendering, IItemRendering itemRendering) {
                ModelResourceLocation model = new ModelResourceLocation(new ResourceLocation("nae2", NAEBlockDefinitionBuilder.this.registryName), "inventory");
                itemRendering.model(model).variants(new ResourceLocation[]{model});
            }
        });
        return this;
    }

    @Override
    public INAEBlockBuilder item(Function<Block, ItemBlock> factory) {
        this.itemFactory = factory;
        return this;
    }

    @Override
    public INAEBlockBuilder disableItem() {
        this.disableItem = true;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(BlockRenderingCustomizer callback) {
        callback.customize((IBlockRendering)this.blockRendering, (IItemRendering)this.itemRendering);
    }

    @Override
    public INAEBlockBuilder withJEIDescription() {
        if (Platform.isClient()) {
            this.jeiDescription = true;
        }
        return this;
    }

    @Override
    public <T extends IBlockDefinition> T build() {
        BlockDefinition definition;
        if (this.features != null && Arrays.stream(this.features).noneMatch(IFeature::isEnabled)) {
            return (T)new TileDefinition(this.registryName, null, null);
        }
        Block block = this.blockSupplier.get();
        block.setRegistryName("nae2", this.registryName);
        block.func_149663_c("nae2." + this.registryName);
        ItemBlock item = this.constructItemFromBlock(block);
        if (item != null) {
            item.setRegistryName("nae2", this.registryName);
        }
        this.registry.addBootstrapComponent((IBootstrapComponent)((IBlockRegistrationComponent)(side, registry) -> registry.register((IForgeRegistryEntry)block)));
        if (item != null) {
            this.registry.addBootstrapComponent((IBootstrapComponent)((IItemRegistrationComponent)(side, registry) -> registry.register((IForgeRegistryEntry)item)));
        }
        block.func_149647_a(this.creativeTab);
        this.bootstrapComponents.forEach(component -> this.registry.addBootstrapComponent((IBootstrapComponent)component.apply(block, item)));
        if (this.tileEntityDefinition != null && block instanceof AEBaseTileBlock) {
            ((AEBaseTileBlock)block).setTileEntity(this.tileEntityDefinition.getTileEntityClass());
            if (this.tileEntityDefinition.getName() == null) {
                this.tileEntityDefinition.setName(this.registryName);
            }
        }
        if (Platform.isClient()) {
            if (block instanceof AEBaseTileBlock) {
                AEBaseTileBlock tileBlock = (AEBaseTileBlock)block;
                this.blockRendering.apply(this.registry, block, tileBlock.getTileEntityClass());
            } else {
                this.blockRendering.apply(this.registry, block, null);
            }
            if (item != null) {
                this.itemRendering.apply(this.registry, (Item)item);
            }
        }
        if (block instanceof AEBaseTileBlock) {
            this.registry.addBootstrapComponent((IBootstrapComponent)((IPreInitComponent)side -> AEBaseTile.registerTileItem((Class)(this.tileEntityDefinition == null ? ((AEBaseTileBlock)block).getTileEntityClass() : this.tileEntityDefinition.getTileEntityClass()), (IStackSrc)new BlockStackSrc(block, 0, ActivityState.Enabled))));
            if (this.tileEntityDefinition != null) {
                this.registry.tileEntityComponent.addTileEntity(this.tileEntityDefinition);
            }
            definition = new TileDefinition(this.registryName, (AEBaseTileBlock)block, item);
        } else {
            definition = new BlockDefinition(this.registryName, block, item);
        }
        if (Platform.isClient() && Platform.isModLoaded((String)"jei") && this.jeiDescription && item != null) {
            NAEJEIPlugin.registerDescription((IItemDefinition)definition, item.func_77658_a() + ".desc");
        }
        return (T)definition;
    }

    @Nullable
    private ItemBlock constructItemFromBlock(Block block) {
        if (this.disableItem) {
            return null;
        }
        if (this.itemFactory != null) {
            return this.itemFactory.apply(block);
        }
        if (block instanceof AEBaseBlock) {
            return new AEBaseItemBlock(block);
        }
        return new ItemBlock(block);
    }
}

