/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.definitions;

import appeng.api.definitions.IItemDefinition;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.components.IPostInitComponent;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.api.definitions.ApiBlocks;
import appeng.core.api.definitions.ApiParts;
import appeng.core.features.DamagedItemDefinition;
import appeng.core.features.IStackSrc;
import co.neeve.nae2.common.crafting.patterntransform.PatternTransform;
import co.neeve.nae2.common.crafting.patterntransform.transformers.GregTechCircuitPatternTransformer;
import co.neeve.nae2.common.features.IFeature;
import co.neeve.nae2.common.features.subfeatures.UpgradeFeatures;
import co.neeve.nae2.common.items.NAEBaseItemUpgrade;
import co.neeve.nae2.common.registration.registry.Registry;
import co.neeve.nae2.common.registration.registry.interfaces.DamagedDefinitions;
import co.neeve.nae2.common.registration.registry.rendering.DamagedItemRendering;
import co.neeve.nae2.common.registration.registry.rendering.IModelProvider;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Upgrades
implements DamagedDefinitions<DamagedItemDefinition, UpgradeType> {
    private final Object2ObjectOpenHashMap<String, DamagedItemDefinition> byId = new Object2ObjectOpenHashMap();
    private final IItemDefinition hyperAcceleration;
    private final IItemDefinition autoComplete;
    private final IItemDefinition gregtechCircuit;
    private final NAEBaseItemUpgrade upgrade = new NAEBaseItemUpgrade();

    public Upgrades(Registry registry) {
        registry.item("upgrade", () -> this.upgrade).rendering(new DamagedItemRendering<Upgrades>(this)).build();
        this.hyperAcceleration = this.createUpgrade(this.upgrade, UpgradeType.HYPER_ACCELERATION);
        if (this.hyperAcceleration.isEnabled()) {
            registry.addBootstrapComponent((IBootstrapComponent)((IPostInitComponent)r -> {
                ApiDefinitions definitions = Api.INSTANCE.definitions();
                ApiBlocks blocks = definitions.blocks();
                UpgradeType.HYPER_ACCELERATION.registerItem((IItemDefinition)blocks.iOPort(), 3);
            }));
        }
        this.autoComplete = this.createUpgrade(this.upgrade, UpgradeType.AUTO_COMPLETE);
        if (this.autoComplete.isEnabled()) {
            registry.addBootstrapComponent((IBootstrapComponent)((IPostInitComponent)r -> {
                ApiDefinitions definitions = Api.INSTANCE.definitions();
                ApiBlocks blocks = definitions.blocks();
                ApiParts parts = definitions.parts();
                UpgradeType.AUTO_COMPLETE.registerItem((IItemDefinition)blocks.iface(), 1);
                UpgradeType.AUTO_COMPLETE.registerItem(parts.iface(), 1);
            }));
        }
        this.gregtechCircuit = this.createUpgrade(this.upgrade, UpgradeType.GREGTECH_CIRCUIT);
        if (this.gregtechCircuit.isEnabled()) {
            PatternTransform.registerTransformer(new GregTechCircuitPatternTransformer());
            registry.addBootstrapComponent((IBootstrapComponent)((IPostInitComponent)r -> {
                ApiDefinitions definitions = Api.INSTANCE.definitions();
                ApiBlocks blocks = definitions.blocks();
                ApiParts parts = definitions.parts();
                UpgradeType.GREGTECH_CIRCUIT.registerItem((IItemDefinition)blocks.iface(), 1);
                UpgradeType.GREGTECH_CIRCUIT.registerItem(parts.iface(), 1);
            }));
        }
    }

    @NotNull
    private DamagedItemDefinition createUpgrade(NAEBaseItemUpgrade material, UpgradeType upgradeType) {
        DamagedItemDefinition def = new DamagedItemDefinition(upgradeType.getId(), material.createUpgrade(upgradeType));
        this.byId.put((Object)upgradeType.getId(), (Object)def);
        return def;
    }

    public Optional<UpgradeType> getById(int itemDamage) {
        return Optional.ofNullable((UpgradeType)UpgradeType.getCachedValues().getOrDefault((Object)itemDamage, null));
    }

    @Override
    public Optional<DamagedItemDefinition> getById(String id) {
        return Optional.ofNullable((DamagedItemDefinition)this.byId.getOrDefault((Object)id, null));
    }

    public IItemDefinition hyperAcceleration() {
        return this.hyperAcceleration;
    }

    public IItemDefinition autoComplete() {
        return this.autoComplete;
    }

    public IItemDefinition gregtechCircuit() {
        return this.gregtechCircuit;
    }

    @Override
    public Collection<UpgradeType> getEntries() {
        return UpgradeType.getCachedValues().values();
    }

    @Override
    @Nullable
    public UpgradeType getType(ItemStack is) {
        return this.upgrade.getType(is);
    }

    public static enum UpgradeType implements IModelProvider
    {
        HYPER_ACCELERATION("hyper_acceleration", UpgradeFeatures.HYPER_ACCELERATION),
        AUTO_COMPLETE("auto_complete", UpgradeFeatures.AUTO_COMPLETE){

            @Override
            public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
                lines.add(I18n.func_74838_a((String)"item.nae2.upgrade.auto_complete.desc"));
            }
        }
        ,
        GREGTECH_CIRCUIT("gregtech_circuit", UpgradeFeatures.GREGTECH_CIRCUIT){

            @Override
            public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
                lines.add(I18n.func_74838_a((String)"item.nae2.upgrade.gregtech_circuit.desc"));
            }
        };

        private static Int2ObjectLinkedOpenHashMap<UpgradeType> cachedValues;
        private final Map<ItemStack, Integer> supportedMax = new HashMap<ItemStack, Integer>();
        private final String id;
        private final IFeature features;
        private final String translationKey;
        private final ModelResourceLocation model;
        private final int damageValue = this.ordinal();
        private boolean isRegistered;
        private Item itemInstance;
        private IStackSrc stackSrc;

        private UpgradeType(String id, IFeature features) {
            this.id = id;
            this.features = features;
            this.translationKey = "item.nae2.upgrade." + id;
            this.model = new ModelResourceLocation(new ResourceLocation("nae2", "upgrade/" + id), "inventory");
        }

        public static Int2ObjectLinkedOpenHashMap<UpgradeType> getCachedValues() {
            if (cachedValues == null) {
                cachedValues = new Int2ObjectLinkedOpenHashMap();
                Arrays.stream(UpgradeType.values()).forEach(upgradeType -> cachedValues.put(upgradeType.ordinal(), upgradeType));
            }
            return cachedValues;
        }

        public String getId() {
            return this.id;
        }

        public IFeature getFeature() {
            return this.features;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public ItemStack stack(int size) {
            return new ItemStack(this.getItemInstance(), size, this.getDamageValue());
        }

        public boolean isRegistered() {
            return this.isRegistered;
        }

        @Override
        public boolean isEnabled() {
            return this.features.isEnabled();
        }

        public void markReady() {
            this.isRegistered = true;
        }

        public int getDamageValue() {
            return this.damageValue;
        }

        public Item getItemInstance() {
            return this.itemInstance;
        }

        public void setItemInstance(Item itemInstance) {
            this.itemInstance = itemInstance;
        }

        public UpgradeStackSrc getStackSrc() {
            return (UpgradeStackSrc)this.stackSrc;
        }

        public void setStackSrc(UpgradeStackSrc stackSrc) {
            this.stackSrc = stackSrc;
        }

        @Override
        public ModelResourceLocation getModel() {
            return this.model;
        }

        public Map<ItemStack, Integer> getSupported() {
            return this.supportedMax;
        }

        public void registerItem(IItemDefinition item, int maxSupported) {
            item.maybeStack(1).ifPresent(is -> this.registerItem((ItemStack)is, maxSupported));
        }

        public void registerItem(ItemStack stack, int maxSupported) {
            if (stack != null) {
                this.supportedMax.put(stack, maxSupported);
            }
        }

        public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        }
    }

    public static class UpgradeStackSrc
    implements IStackSrc {
        private final UpgradeType src;
        private final boolean enabled;

        public UpgradeStackSrc(UpgradeType src, boolean enabled) {
            Preconditions.checkNotNull((Object)src);
            this.src = src;
            this.enabled = enabled;
        }

        public ItemStack stack(int stackSize) {
            return this.src.stack(stackSize);
        }

        public Item getItem() {
            return this.src.getItemInstance();
        }

        public int getDamage() {
            return this.src.getDamageValue();
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

