/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.capabilities.Capabilities;
import appeng.core.settings.TickRates;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.ItemStackHelper;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.MachineSource;
import appeng.parts.misc.PartInterface;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileCableBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.item.AEItemStack;
import co.neeve.nae2.common.helpers.WrapperChainedFluidHandler;
import co.neeve.nae2.common.parts.p2p.P2PModels;
import co.neeve.nae2.mixin.ifacep2p.shared.DualityAccessor;
import com.glodblock.github.inventory.FluidConvertingInventoryAdaptor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartP2PInterface
extends PartP2PTunnel<PartP2PInterface>
implements IItemHandler,
IGridTickable,
IFluidHandler {
    public static final ObjectOpenHashSet<Capability<?>> SUPPORTED_CAPABILITIES = new ObjectOpenHashSet((Object[])new Capability[]{CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY});
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_interface");
    private final MachineSource mySource;
    private final List<ItemStack> waitingToSend = new ArrayList<ItemStack>();
    private final CapabilityCache capabilityCache;
    private int depth = 0;
    private boolean requested;
    private ObjectOpenHashSet<PartP2PInterface> cachedOutputs;
    private IItemHandler cachedInv;
    private IFluidHandler cachedTank;
    private ObjectOpenHashSet<PartP2PInterface> cachedInputs;

    public PartP2PInterface(ItemStack is) {
        super(is);
        this.mySource = new MachineSource((IActionHost)this);
        this.capabilityCache = new CapabilityCache();
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    private static <T> ObjectOpenHashSet<T> gatherCapabilities(Collection<PartP2PInterface> tunnels, Capability<T> capabilityType) {
        ObjectOpenHashSet caps = new ObjectOpenHashSet();
        for (PartP2PInterface tunnel : tunnels) {
            Object capability;
            Optional<TileEntity> optionalTileEntity = tunnel.getFacingTileEntity();
            if (!optionalTileEntity.isPresent()) continue;
            EnumFacing facing = tunnel.getSide().getOpposite().getFacing();
            TileEntity te = optionalTileEntity.get();
            if (!PartP2PInterface.isInterface(te, facing) || (capability = te.getCapability(capabilityType, facing)) == null) continue;
            caps.add(capability);
        }
        return caps;
    }

    private static <T> T[] toArray(Set<T> set, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, set.size());
        int i = 0;
        for (T item : set) {
            array[i++] = item;
        }
        return array;
    }

    public static boolean isInterface(Object te, EnumFacing facing) {
        if (te instanceof IInterfaceHost) {
            return true;
        }
        if (te instanceof IFluidInterfaceHost) {
            return true;
        }
        if (te instanceof IPartHost) {
            IPartHost iPartHost = (IPartHost)te;
            IPart part = iPartHost.getPart(facing);
            return PartP2PInterface.isInterface(part, facing);
        }
        return false;
    }

    @NotNull
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public boolean hasItemsToSend() {
        return !this.waitingToSend.isEmpty();
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagList waitingToSend = new NBTTagList();
        for (ItemStack is : this.waitingToSend) {
            NBTTagCompound itemNBT = ItemStackHelper.stackToNBT((ItemStack)is);
            waitingToSend.func_74742_a((NBTBase)itemNBT);
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        for (int x = 0; x < waitingList.func_74745_c(); ++x) {
            NBTTagCompound up = waitingList.func_150305_b(x);
            ItemStack is = ItemStackHelper.stackFromNBT((NBTTagCompound)up);
            this.addToSendList(is);
        }
    }

    public void addToSendList(ItemStack is) {
        if (!is.func_190926_b()) {
            this.waitingToSend.add(is);
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        int min = Math.min(TickRates.ItemTunnel.getMin(), TickRates.Interface.getMin());
        int max = Math.max(TickRates.ItemTunnel.getMax(), TickRates.Interface.getMax());
        return new TickingRequest(min, max, false, false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        boolean wasReq = this.requested;
        this.requested = false;
        TickRateModulation reqResult = wasReq ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        boolean pushWorked = false;
        if (this.hasItemsToSend()) {
            pushWorked = this.pushItemsOut();
        }
        if (this.hasWorkToDo()) {
            return pushWorked ? TickRateModulation.URGENT : reqResult;
        }
        return reqResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean pushItemsOut() {
        boolean worked = false;
        if (this.waitingToSend.isEmpty()) return worked;
        EnumFacing s = this.getSide().getFacing();
        TileEntity tile = this.getTile();
        World w = tile.func_145831_w();
        TileEntity target = w.func_175625_s(tile.func_174877_v().func_177972_a(s));
        if (target == null) return worked;
        if (target instanceof IInterfaceHost || target instanceof TileCableBus && ((TileCableBus)target).getPart(s.func_176734_d()) instanceof PartInterface) {
            try {
                IMEMonitor inv;
                IStorageMonitorable sm;
                IStorageMonitorableAccessor mon;
                IInterfaceHost targetTE = target instanceof IInterfaceHost ? (IInterfaceHost)target : (IInterfaceHost)((TileCableBus)target).getPart(s.func_176734_d());
                DualityAccessor dualityAccessor = (DualityAccessor)targetTE.getInterfaceDuality();
                if (dualityAccessor.invokeSameGrid(this.getGridNode().getGrid()) || (mon = (IStorageMonitorableAccessor)target.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, s.func_176734_d())) == null || (sm = mon.getInventory((IActionSource)this.mySource)) == null || !Platform.canAccess((AENetworkProxy)dualityAccessor.getGridProxy(), (IActionSource)this.mySource) || (inv = sm.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class))) == null) return worked;
                Iterator<ItemStack> i = this.waitingToSend.iterator();
                while (i.hasNext()) {
                    ItemStack whatToSend = i.next();
                    IAEItemStack result = (IAEItemStack)inv.injectItems((IAEStack)AEItemStack.fromItemStack((ItemStack)whatToSend), Actionable.MODULATE, (IActionSource)this.mySource);
                    if (result != null) {
                        if ((long)whatToSend.func_190916_E() != result.getStackSize()) {
                            worked = true;
                        }
                        whatToSend.func_190920_e((int)result.getStackSize());
                        whatToSend.func_77982_d(result.getDefinition().func_77978_p());
                        continue;
                    }
                    worked = true;
                    i.remove();
                }
                return worked;
            }
            catch (GridAccessException var12) {
                throw new RuntimeException(var12);
            }
        } else {
            InventoryAdaptor ad = Platform.isModLoaded((String)"ae2fc") ? FluidConvertingInventoryAdaptor.wrap((ICapabilityProvider)target, (EnumFacing)s.func_176734_d()) : InventoryAdaptor.getAdaptor((TileEntity)target, (EnumFacing)s.func_176734_d());
            Iterator<ItemStack> i = this.waitingToSend.iterator();
            while (i.hasNext()) {
                ItemStack whatToSend = i.next();
                if (ad == null) continue;
                ItemStack result = ad.addItems(whatToSend);
                if (!result.func_190926_b()) {
                    if (whatToSend.func_190916_E() != result.func_190916_E()) {
                        worked = true;
                    }
                    whatToSend.func_190920_e(result.func_190916_E());
                    whatToSend.func_77982_d(result.func_77978_p());
                    continue;
                }
                worked = true;
                i.remove();
            }
        }
        return worked;
    }

    private boolean hasWorkToDo() {
        return this.hasItemsToSend();
    }

    @Nullable
    public TunnelCollection<PartP2PInterface> getOutputs() {
        try {
            return super.getOutputs();
        }
        catch (GridAccessException ignored) {
            return null;
        }
    }

    @Nullable
    public TunnelCollection<PartP2PInterface> getInputs() {
        try {
            return super.getInputs();
        }
        catch (GridAccessException ignored) {
            return null;
        }
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        drops.addAll(this.waitingToSend);
    }

    public Optional<TileEntity> getFacingTileEntity() {
        TileEntity tile = this.getTile();
        return Optional.ofNullable(tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(this.getSide().getFacing())));
    }

    public boolean hasCapability(Capability<?> capabilityClass) {
        return SUPPORTED_CAPABILITIES.contains(capabilityClass) || super.hasCapability(capabilityClass);
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        return (T)(SUPPORTED_CAPABILITIES.contains(capabilityClass) ? this : super.getCapability(capabilityClass));
    }

    private IItemHandler getItemHandler() {
        if (this.cachedInv == null) {
            this.cachedInv = EmptyHandler.INSTANCE;
            for (PartP2PInterface input : this.getCachedInputs()) {
                Optional<Pair<ObjectOpenHashSet<Pair>, Object>> pair = input.capabilityCache.get(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                pair.ifPresent(objectOpenHashSetObjectPair -> {
                    this.cachedInv = (IItemHandler)objectOpenHashSetObjectPair.getRight();
                });
            }
        }
        return this.cachedInv;
    }

    private IFluidHandler getFluidHandler() {
        if (this.cachedTank == null) {
            this.cachedTank = EmptyFluidHandler.INSTANCE;
            for (PartP2PInterface input : this.getCachedInputs()) {
                Optional<Pair<ObjectOpenHashSet<Pair>, Object>> pair = input.capabilityCache.get(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                pair.ifPresent(objectOpenHashSetObjectPair -> {
                    this.cachedTank = (IFluidHandler)objectOpenHashSetObjectPair.getRight();
                });
            }
        }
        return this.cachedTank;
    }

    public boolean isValidDestination(PartP2PInterface tunnel) {
        return this.getCachedOutputs().contains((Object)tunnel);
    }

    private ObjectOpenHashSet<PartP2PInterface> getCachedOutputs() {
        if (this.cachedOutputs == null) {
            this.cachedOutputs = new ObjectOpenHashSet();
            TunnelCollection<PartP2PInterface> outputs = this.getOutputs();
            if (outputs != null) {
                outputs.forEach(arg_0 -> this.cachedOutputs.add(arg_0));
            }
        }
        return this.cachedOutputs;
    }

    private ObjectOpenHashSet<PartP2PInterface> getCachedInputs() {
        if (this.cachedInputs == null) {
            this.cachedInputs = new ObjectOpenHashSet();
            TunnelCollection<PartP2PInterface> inputs = this.getInputs();
            if (inputs != null) {
                inputs.forEach(arg_0 -> this.cachedInputs.add(arg_0));
            }
        }
        return this.cachedInputs;
    }

    public void onTunnelNetworkChange() {
        this.cachedInputs = null;
        this.cachedOutputs = null;
        if (this.isOutput()) {
            this.cachedInv = null;
            this.cachedTank = null;
            this.getHost().notifyNeighbors();
        }
    }

    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        if (!this.isOutput()) {
            boolean changed = false;
            for (Capability capability : SUPPORTED_CAPABILITIES) {
                changed |= this.processCapabiltiies((Collection<PartP2PInterface>)this.getCachedInputs(), (Capability)capability);
            }
            if (changed) {
                for (PartP2PInterface tunnel : this.getCachedOutputs()) {
                    tunnel.onTunnelNetworkChange();
                }
            }
        }
    }

    private <T> boolean processCapabiltiies(Collection<PartP2PInterface> inputs, Capability<T> capability) {
        ObjectOpenHashSet<T> caps = PartP2PInterface.gatherCapabilities(inputs, capability);
        if (!this.capabilityCache.isSameAsCached(capability, caps)) {
            T handler = this.createHandler(capability, caps);
            this.capabilityCache.store(capability, caps, handler);
            for (PartP2PInterface input : inputs) {
                input.capabilityCache.store(capability, caps, handler);
            }
            return true;
        }
        return false;
    }

    private <T> Class<T> getCapabilityHandlerClass(Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return IItemHandler.class;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return IFluidHandler.class;
        }
        throw new RuntimeException("Unexpected capability: " + capability);
    }

    private <T> T createHandler(Capability<T> capability, ObjectOpenHashSet<T> caps) {
        Class<T> clazz = this.getCapabilityHandlerClass(capability);
        T[] array = PartP2PInterface.toArray(caps, clazz);
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new WrapperChainedItemHandler((IItemHandler[])array);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new WrapperChainedFluidHandler((IFluidHandler[])array);
        }
        return null;
    }

    public int getSlots() {
        return this.getItemHandler().getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return this.getItemHandler().getStackInSlot(i);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isOutput()) {
            return stack;
        }
        if (this.depth == 1) {
            return stack;
        }
        ++this.depth;
        ItemStack ret = this.getItemHandler().insertItem(slot, stack, simulate);
        --this.depth;
        return ret;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.isOutput()) {
            return ItemStack.field_190927_a;
        }
        return this.getItemHandler().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getItemHandler().getSlotLimit(slot);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.getFluidHandler().getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.getFluidHandler().fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack fluid, boolean doDrain) {
        return this.getFluidHandler().drain(fluid, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.getFluidHandler().drain(maxDrain, doDrain);
    }

    private static class CapabilityCache {
        private final Object2ObjectOpenHashMap<Capability<?>, ObjectOpenHashSet<?>> cachedCapabilities = new Object2ObjectOpenHashMap();
        private final Object2ObjectOpenHashMap<Capability<?>, Object> cachedHandlers = new Object2ObjectOpenHashMap();

        private CapabilityCache() {
        }

        public <T> void store(Capability<T> capability, ObjectOpenHashSet<T> capabilities, T handler) {
            this.cachedCapabilities.put(capability, capabilities);
            this.cachedHandlers.put(capability, handler);
        }

        public <T> Optional<Pair<ObjectOpenHashSet<T>, Object>> get(Capability<T> capability) {
            ObjectOpenHashSet set = (ObjectOpenHashSet)this.cachedCapabilities.getOrDefault(capability, null);
            if (set != null) {
                return Optional.of(Pair.of((Object)set, (Object)this.cachedHandlers.get(capability)));
            }
            return Optional.empty();
        }

        public <T> boolean isSameAsCached(Capability<T> capability, @Nullable ObjectOpenHashSet<T> capabilities) {
            Optional<Pair<ObjectOpenHashSet<T>, Object>> cached = this.get(capability);
            boolean present = cached.isPresent();
            if (capabilities == null && present) {
                return false;
            }
            if (capabilities != null && !present) {
                return false;
            }
            return capabilities != null && capabilities.equals(cached.get().getLeft());
        }
    }
}

