/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.helpers;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import co.neeve.nae2.NAE2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class VirtualPatternDetails
implements ICraftingPatternDetails {
    private final IAEItemStack[] outputs;
    private final IAEItemStack[] inputs;
    private int priority = 0;

    public VirtualPatternDetails(Iterable<IAEItemStack> inputs, Iterable<IAEItemStack> outputs) {
        this.inputs = (IAEItemStack[])Iterables.toArray(inputs, IAEItemStack.class);
        this.outputs = (IAEItemStack[])Iterables.toArray(outputs, IAEItemStack.class);
    }

    public static VirtualPatternDetails fromItemStack(ItemStack is) {
        ArrayList<IAEItemStack> inputItems = new ArrayList<IAEItemStack>();
        ArrayList<IAEItemStack> outputItems = new ArrayList<IAEItemStack>();
        try {
            NBTTagCompound compound = is.func_77978_p();
            for (NBTBase input : Objects.requireNonNull(compound).func_150295_c("inputs", 10)) {
                inputItems.add(AEItemStack.fromNBT((NBTTagCompound)((NBTTagCompound)input)));
            }
            for (NBTBase output : Objects.requireNonNull(compound).func_150295_c("outputs", 10)) {
                outputItems.add(AEItemStack.fromNBT((NBTTagCompound)((NBTTagCompound)output)));
            }
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("No pattern here!");
        }
        if (outputItems.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        return new VirtualPatternDetails(inputItems, outputItems);
    }

    public ItemStack getPattern() {
        ItemStack is = Objects.requireNonNull(NAE2.definitions().items().virtualPattern().maybeStack(1).orElse(null));
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tagInputs = new NBTTagList();
        for (IAEItemStack input : this.inputs) {
            NBTTagCompound itemcmpd = new NBTTagCompound();
            input.writeToNBT(itemcmpd);
            tagInputs.func_74742_a((NBTBase)itemcmpd);
        }
        compound.func_74782_a("inputs", (NBTBase)tagInputs);
        NBTTagList tagOutputs = new NBTTagList();
        for (IAEItemStack output : this.outputs) {
            NBTTagCompound itemcmpd = new NBTTagCompound();
            output.writeToNBT(itemcmpd);
            tagOutputs.func_74742_a((NBTBase)itemcmpd);
        }
        compound.func_74782_a("outputs", (NBTBase)tagOutputs);
        is.func_77982_d(compound);
        return is;
    }

    public boolean isValidItemForSlot(int i, ItemStack itemStack, World world) {
        return false;
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public boolean canSubstitute() {
        return false;
    }

    public ItemStack getOutput(InventoryCrafting inventoryCrafting, World world) {
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int i) {
        this.priority = i;
    }
}

