/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.crafting.patterntransform;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PatternTransformWrapper
implements ICraftingPatternDetails {
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final ICraftingPatternDetails delegate;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;

    public PatternTransformWrapper(ICraftingPatternDetails delegate, IAEItemStack[] inputs, IAEItemStack[] outputs) {
        IAEItemStack io;
        this.delegate = delegate;
        this.inputs = inputs;
        this.outputs = outputs;
        this.condensedInputs = new IAEItemStack[inputs.length];
        int offset = 0;
        Iterator iterator = Arrays.stream(inputs).iterator();
        while (iterator.hasNext()) {
            this.condensedInputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
        offset = 0;
        this.condensedOutputs = new IAEItemStack[outputs.length];
        iterator = Arrays.stream(outputs).iterator();
        while (iterator.hasNext()) {
            this.condensedOutputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
    }

    public ItemStack getPattern() {
        return this.delegate.getPattern();
    }

    public boolean isValidItemForSlot(int i, ItemStack itemStack, World world) {
        return this.delegate.isValidItemForSlot(i, itemStack, world);
    }

    public boolean isCraftable() {
        return this.delegate.isCraftable();
    }

    public boolean canSubstitute() {
        return this.delegate.canSubstitute();
    }

    public List<IAEItemStack> getSubstituteInputs(int slot) {
        return this.delegate.getSubstituteInputs(slot);
    }

    public ItemStack getOutput(InventoryCrafting inventoryCrafting, World world) {
        return this.delegate.getOutput(inventoryCrafting, world);
    }

    public int getPriority() {
        return this.delegate.getPriority();
    }

    public void setPriority(int i) {
        this.delegate.setPriority(i);
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternTransformWrapper)) {
            return false;
        }
        PatternTransformWrapper that = (PatternTransformWrapper)o;
        return Arrays.equals(this.condensedInputs, that.condensedInputs) && Arrays.equals(this.condensedOutputs, that.condensedOutputs) && Objects.equals(this.delegate, that.delegate) && Arrays.equals(this.inputs, that.inputs) && Arrays.equals(this.outputs, that.outputs);
    }

    public int hashCode() {
        int result = Objects.hash(this.delegate);
        result = 31 * result + Arrays.hashCode(this.condensedInputs);
        result = 31 * result + Arrays.hashCode(this.condensedOutputs);
        result = 31 * result + Arrays.hashCode(this.inputs);
        result = 31 * result + Arrays.hashCode(this.outputs);
        return result;
    }

    public ICraftingPatternDetails getDelegate() {
        return this.delegate;
    }
}

