/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2;

import co.neeve.nae2.NAE2API;
import co.neeve.nae2.common.features.Features;
import co.neeve.nae2.common.features.subfeatures.ISubFeature;
import co.neeve.nae2.common.net.NetHandler;
import co.neeve.nae2.common.registration.Registration;
import co.neeve.nae2.common.sync.GuiHandler;
import co.neeve.nae2.server.WorldListener;
import java.io.File;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="nae2", version="1.6.4", name="Neeve's AE2: Extended Life Additions", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:appliedenergistics2;required-after:mixinbooter@[8.3,)")
public class NAE2 {
    public static NAE2 instance;
    private static ConfigManager configManager;
    private final Logger logger = LogManager.getLogger((String)"nae2".toUpperCase());
    private final NetHandler network = new NetHandler();
    private final NAE2API api = new NAE2API();
    private Registration registration;
    private GuiHandler guiHandler;
    @SideOnly(value=Side.CLIENT)
    private ItemStack icon;

    public static void setupConfig() {
        if (configManager == null) {
            configManager = new ConfigManager();
        }
    }

    public static SimpleNetworkWrapper net() {
        return NAE2.instance.network.getChannel();
    }

    public static GuiHandler gui() {
        return NAE2.instance.guiHandler;
    }

    public static Registration definitions() {
        return NAE2.instance.registration;
    }

    public static NAE2API api() {
        return NAE2.instance.api;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack icon() {
        return NAE2.instance.icon;
    }

    public static Logger logger() {
        return NAE2.instance.logger;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.registration = new Registration();
        NAE2.setupConfig();
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)new WorldListener());
        this.guiHandler = new GuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        this.registration.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registration.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            this.icon = NAE2.definitions().items().patternMultiTool().maybeStack(1).orElse(ItemStack.field_190927_a);
        }
        this.registration.postInit(event);
    }

    public static class ConfigManager {
        public ConfigManager() {
            File file = new File("config/nae2.cfg");
            Configuration config = new Configuration(file);
            for (Features feature : Features.values()) {
                String lowerCase = feature.name().toLowerCase();
                ConfigCategory featureCategory = config.getCategory(lowerCase);
                Property entry = (Property)featureCategory.computeIfAbsent((Object)"enabled", x -> new Property("enabled", "true", Property.Type.BOOLEAN));
                feature.setEnabled(entry.getBoolean(true));
                EnumSet<? extends ISubFeature> subFeatures = feature.getSubFeatures();
                if (subFeatures == null) continue;
                for (Enum enum_ : subFeatures) {
                    String subFeatureLowerCase = enum_.name().toLowerCase();
                    Property subFeatureEntry = (Property)featureCategory.computeIfAbsent((Object)subFeatureLowerCase, x -> new Property(subFeatureLowerCase, "true", Property.Type.BOOLEAN));
                    ((ISubFeature)((Object)enum_)).setEnabled(feature.isEnabled() && subFeatureEntry.getBoolean(true));
                    subFeatureEntry.setComment(((ISubFeature)((Object)enum_)).getDescription());
                }
            }
            config.save();
        }
    }
}

