GTCEuStartupEvents.registry('gtceu:recipe_type', event => {

    event.create('absolute_reduction')
        .category('extremely_advanced')
        .setEUIO('in')
        .setMaxTooltips(4)
        .setMaxIOSize(9, 9, 9, 9)
        .setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE , FillDirection.LEFT_TO_RIGHT)
        .setSound(GTSoundEntries.CHEMICAL);
    
    event.create('enlightened_chemistry')
        .category('extremely_advanced')
        .setEUIO('in')
        .setMaxTooltips(4)
        .setMaxIOSize(6, 6, 6, 6)
        .setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE , FillDirection.LEFT_TO_RIGHT)
        .setSound(GTSoundEntries.CHEMICAL);

});

GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('atomic_synthesis_plant', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .recipeTypes(['chemical_skip', 'advanced_chemistry', 'absolute_reduction', 'enlightened_chemistry'])
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.OC_PERFECT_SUBTICK, $StarTRecipeModifiers.THOUGHPUT_BOOSTING, $StarTRecipeModifiers.BULK_PROCESSING])
        .appearanceBlock(() => Block.getBlock('kubejs:cattomolymer_casing'))
        .pattern(definition => FactoryBlockPattern.start()
            .aisle('ABBCBBA    ', 'DAAAAAD    ', 'D     D    ', 'D     D    ', 'D     D    ', 'DAAAAAD    ', 'ABBCBBA    ', '           ', '           ', '           ', '           ') 
            .aisle('BAABAAB E  ', 'AEEEEEA F  ', ' AAAAAFFF  ', ' GGGGG     ', ' AAAAA     ', 'AGGGGGA    ', 'BDHHHDB    ', ' D   D     ', ' D   D     ', ' D   D     ', ' AAAAA     ') 
            .aisle('BAABAAB    ', 'AEIIIEA    ', ' ADDDA     ', ' G   G     ', ' ADDDA     ', 'AG   GA    ', 'BHAAAHB    ', '  AAA      ', '  GGG      ', '  AAA      ', ' ACCCA     ') 
            .aisle('CAAAAAC JJ ', 'AEIIIEA JJ ', ' ADFDADDJJ ', ' G F G  JJ ', ' ADFDA  JJ ', 'AG F GA JJ ', 'CHAFAHC JJ ', '  AFA   JJ ', '  GFG      ', '  AAA      ', ' ACCCA     ') 
            .aisle('BAABAAB JJ ', 'AEIIIEA JJ ', ' ADFDA  JJ ', ' G   G  JJ ', ' ADDDADDJJ ', 'AG   GA JJ ', 'BHAAAHB JJ ', '  AAA   JJ ', '  GEG      ', '  AAA      ', ' ACCCA     ') 
            .aisle('BAABAAB    ', 'AEEEEEA    ', ' ADFDA     ', ' GDDDG     ', ' ADDDA     ', 'AGGGGGA    ', 'BDHHHDB    ', ' D D D     ', ' D E D     ', ' D D D     ', ' AAAAA     ') 
            .aisle('ABAAAAA BBB', 'DAAEAEADABA', 'D AFAAAHAAA', 'D AAAGADABA', 'D AAAAA BBB', 'DAAAAAD    ', 'ABBCBEA    ', '           ', '   H       ', '           ', '           ') 
            .aisle('  ABABA BBB', '  ADGGAHAFA', '  AFGGF IFK', '  ADGGAHAFA', '  AAAAA BBB', '           ', '   D E     ', '           ', '   H       ', '           ', '           ') 
            .aisle('  ABABA BBB', '  AEDEADABA', '  LFDFAHAAA', '  AEDEADABA', '  AEAEA BBB', '   E E     ', '   HDE     ', '   H       ', '   H       ', '           ', '           ') 
            .aisle('  AAAA     ', '  AAHA     ', '  A@HA     ', '  AAHA     ', '  AAAA     ', '           ', '           ', '           ', '           ', '           ', '           ') 
            .where('A', Predicates.blocks('kubejs:cattomolymer_casing')
                .or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setMaxGlobalLimited(8).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setMaxGlobalLimited(8).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMaxGlobalLimited(8).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setMaxGlobalLimited(8).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1))
                .or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2))
                .or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1)))
            .where('B', Predicates.blocks('gtceu:heat_vent'))
            .where('C', Predicates.blocks('kubejs:nyanium_machine_engine_intake_casing'))
            .where(' ', Predicates.any())
            .where('D', Predicates.blocks('gtceu:draco_abyssal_frame'))
            .where('E', Predicates.blocks('gtceu:ptfe_pipe_casing'))
            .where('F', Predicates.blocks('kubejs:nyanium_pipe_casing'))
            .where('G', Predicates.blocks('kubejs:rhenotax_coil'))
            .where('H', Predicates.blocks('kubejs:draco_resilient_fusion_glass'))
            .where('I', Predicates.blocks('kubejs:abyssal_inductor_hull'))
            .where('J', Predicates.blocks('kubejs:noble_mixing_casing'))
            .where('K', Predicates.abilities(PartAbility.MUFFLER))
            .where('L', Predicates.blocks('gtceu:uev_rotor_holder'))
            .where('@', Predicates.controller(Predicates.blocks(definition.get())))
            .build())
        .workableCasingRenderer('kubejs:block/casings/ultimate_multis/cattomolymer_casing',
        'gtceu:block/multiblock/large_chemical_reactor', false);
        
});