GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('superior_particulate_isolation_nexus', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .machine((holder) => new $StarTThreadingCapableMachine(holder))
        .recipeTypes(['sifter', 'centrifuge', 'thermal_centrifuge'])
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, $StarTRecipeModifiers.BULK_PROCESSING, GTRecipeModifiers.OC_NON_PERFECT_SUBTICK, $StarTRecipeModifiers.THREADING_MACHINE])
        .appearanceBlock(() => Block.getBlock('kubejs:tectonic_defiance_casing'))
        .pattern(definition => FactoryBlockPattern.start()
            .aisle(' BBB BBB BBB ', '             ', '             ', '             ', '             ', '             ', '             ', '     BBB     ', '  CBBBDBBBC  ', '  CBEEEEEBC  ', '  CBFFFFFBC  ', '  CBFFFFFBC  ', '  CBEEEEEBC  ', '  CBBBBBBBC  ', '             ', '             ', '             ') 
            .aisle('BBBBCBBBCBBBB', '  C   C   C  ', '      C      ', '             ', '             ', '             ', '             ', '   CGBBBGC   ', ' BBBGBBBGBBB ', ' BBBGGGGGBBB ', '   B     B   ', '   B     B   ', ' BBBGGGGGBBB ', ' BBBGBBBGBBB ', '   CGBBBGC   ', '             ', '             ') 
            .aisle('BBBB BBB BBBB', ' C         C ', '  C       C  ', '  C  C C  C  ', '   CC   CC   ', '  C       C  ', '  CCCBBBCCC  ', '  BBBBBBBBB  ', 'CBBBBGHGBBBBC', 'CBHHHHHHHHHBC', 'C IB     BI C', 'C IB     BI C', 'CBHHHHHHHHHBC', 'CBBBBGHGBBBBC', '  BBBBBBBBB  ', '  CCCBBBCCC  ', '             ') 
            .aisle('BBB       BBB', '             ', '             ', '             ', '  C  C C  C  ', '     CCC     ', '  CBBBBBBBC  ', ' CBBBBHBBBBC ', 'BBBJJGHGJJBBB', 'BBHJ     JHBB', 'BBBJ     JBBB', 'BBBJ     JBBB', 'BBHJ     JHBB', 'BBBJJGHGJJBBB', ' CBBBBHBBBBC ', '  CBBBBBBBC  ', '     CCC     ') 
            .aisle(' C         C ', '             ', '             ', '             ', '  C       C  ', '    C   C    ', '  CBEEEEEBC  ', ' GBBKKHKKBBG ', 'BGBJ     JBGB', 'EGH       HGE', 'F           F', 'F           F', 'EGH       HGE', 'BGBJ     JBGB', ' GBBKKHKKBBG ', '  CBEEEEEBC  ', '    C   C    ') 
            .aisle('BBB       BBB', '             ', '             ', '  C       C  ', '   C     C   ', '   C     C   ', '  BBEGGGEBB  ', ' BBBKKHKKBBB ', 'BBGG     GGBB', 'EGH       HGE', 'F           F', 'F           F', 'EGH       HGE', 'BBGG     GGBB', ' BBBKKHKKBBB ', '  BBEGGGEBB  ', '   C     C   ') 
            .aisle('BBB       BBB', ' C         C ', ' C         C ', '             ', '             ', '   C     C   ', '  BBEGGGEBB  ', ' BBHHHHHHHBB ', 'BBHH  H  HHBB', 'EGH   H   HGE', 'F     H     F', 'F     H     F', 'EGH   H   HGE', 'BBHH  H  HHBB', ' BBHHHHHHHBB ', '  BBEGGGEBB  ', '   C     C   ') 
            .aisle('BBB       BBB', '             ', '             ', '  C       C  ', '   C     C   ', '   C     C   ', '  BBEGGGEBB  ', ' BBBKKHKKBBB ', 'BBGG     GGBB', 'EGH       HGE', 'F           F', 'F           F', 'EGH       HGE', 'BBGG     GGBB', ' BBBKKHKKBBB ', '  BBEGGGEBB  ', '   C     C   ') 
            .aisle(' C         C ', '             ', '             ', '             ', '  C       C  ', '    C   C    ', '  CBEEEEEBC  ', ' GBBKKHKKBBG ', 'BGBJ     JBGB', 'EGH       HGE', 'F           F', 'F           F', 'EGH       HGE', 'BGBJ     JBGB', ' GBBKKHKKBBG ', '  CBEEEEEBC  ', '    C   C    ') 
            .aisle('BBB       BBB', '             ', '             ', '             ', '  C  C C  C  ', '     CCC     ', '  CBBBBBBBC  ', ' CBBBBHBBBBC ', 'BBBJJGHGJJBBB', 'BBHJ     JHBB', 'BBBJ     JBBB', 'BBBJ     JBBB', 'BBHJ     JHBB', 'BBBJJGHGJJBBB', ' CBBBBHBBBBC ', '  CBBBBBBBC  ', '     CCC     ') 
            .aisle('BBBB BBB BBBB', ' C         C ', '  C       C  ', '  C  C C  C  ', '   CC   CC   ', '  C       C  ', '  CCCBBBCCC  ', '  BBBBBBBBB  ', 'CBBBBGHGBBBBC', 'CBHHHHHHHHHBC', 'C IB  H  BI C', 'C IB  H  BI C', 'CBHHHHHHHHHBC', 'CBBBBGHGBBBBC', '  BBBBBBBBB  ', '  CCCBBBCCC  ', '             ') 
            .aisle('BBBBCBBBCBBBB', '  C   C   C  ', '      C      ', '             ', '             ', '             ', '             ', '   CGBBBGC   ', ' BBBGBBBGBBB ', ' BBBGGGGGBBB ', '   B     B   ', '   B     B   ', ' BBBGGGGGBBB ', ' BBBGBBBGBBB ', '   CGBBBGC   ', '             ', '             ') 
            .aisle(' BBB BBB BBB ', '             ', '             ', '             ', '             ', '             ', '             ', '     BBB     ', '  CBBB@BBBC  ', '  CBEEEEEBC  ', '  CBFFFFFBC  ', '  CBFFFFFBC  ', '  CBEEEEEBC  ', '  CBBBBBBBC  ', '             ', '             ', '             ') 
            .where('B', Predicates.blocks('kubejs:tectonic_defiance_casing')
                .or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setPreviewCount(0).setMaxGlobalLimited(20))                  
                .or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1))
                .or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2))
                .or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1)))
            .where(' ', Predicates.any())
            .where('C', Predicates.blocks('gtceu:melastrium_mox_frame'))
            .where('D', Predicates.blocks('start_core:threading_controller'))
            .where('E', Predicates.blocks('kubejs:draco_assembly_grating'))
            .where('F', Predicates.blocks('kubejs:draco_resilient_fusion_glass'))
            .where('G', Predicates.blocks('kubejs:nyanium_machine_engine_intake_casing'))
            .where('H', Predicates.blocks('kubejs:nyanium_pipe_casing'))
            .where('I', $StarTThreadingStatBlocks.threadingStatBlocks())
            .where('J', Predicates.blocks('start_core:auxiliary_boosted_fusion_casing_mk2'))
            .where('K', Predicates.blocks('start_core:advanced_fusion_coil'))
            .where('@', Predicates.controller(Predicates.blocks(definition.get())))
            .build())
        .workableCasingRenderer('kubejs:block/casings/ultimate_multis/tectonic_defiance_casing',
            'gtceu:block/multiblock/implosion_compressor', false);

});