GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('subatomic_particle_lattice_isolation_terminal', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .machine((holder) => new $StarTThreadingCapableMachine(holder))
        .recipeTypes(['cutter', 'lathe', 'wiremill', 'extruder'])
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, $StarTRecipeModifiers.BULK_PROCESSING, GTRecipeModifiers.OC_NON_PERFECT_SUBTICK, $StarTRecipeModifiers.THREADING_MACHINE])
        .appearanceBlock(() => Block.getBlock('kubejs:inoculated_nuclei_seperation_casing'))
        .pattern(definition => FactoryBlockPattern.start()
            .aisle('      BBBBBBBBB      ', '      BBBBBBBBB      ', '      BBB   BBB      ', '      BBB   BBB      ', '      BBB   BBB      ', '      BBBBBBBBB      ', '                     ') 
            .aisle(' BBBBBBBBBBBBBBBBBBB ', ' BBBBBBBBBBBBBBBBBBB ', ' B   BBBBCDCBBBB   B ', ' B   BBBBDEDBBBB   B ', ' B   BBBBCDCBBBB   B ', ' BBBBBBBBBBBBBBBBBBB ', '       BBBBBBB       ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBBBBBBBBBFBBBBBBBBBB', 'BBGGGBBBBBFBBBBBGGGBB', 'BBGGGBBBFFFFFBBBGGGBB', 'BBGGGBBBBBFBBBBBGGGBB', 'BBBBBBBBBBFBBBBBBBBBB', '  BBBBBBBBBBBBBBBBB  ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBDDDBBBBBBBBBBBDDDBB', 'BB   BBBBBBBBBBB   BB', 'BB   BFFFBFBFFFB   BB', 'BB   BBBBBBBBBBB   BB', 'BBBBBBBBBBBBBBBBBBBBB', ' BBBBBBBBBBBBBBBBBBB ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBFFFBBBBBBBBBBBFFFBB', ' CHHHBBBBBBBBBBBHHHC ', ' D   DFBBBFBBBFD   D ', ' CHHHBBBBBBBBBBBHHHC ', 'BBBBBBBBBBBBBBBBBBBBB', ' BBBBBBBBBBBBBBBBBBB ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBFFFFFBBBBBBBFFFFFBB', ' DHHHBFBBBBBBBFBHHHD ', ' D   DFFFFFFFFFD   D ', ' DHHHBFBBBBBBBFBHHHD ', 'BBBBBFFBBBBBBBFFBBBBB', ' BBBBBBBBBBBBBBBBBBB ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBFFFBBBBBBBBBBBFFFBB', ' CHHHBBBBBBBBBBBHHHC ', ' D   DFBBBFBBBFD   D ', ' CHHHBBBBBBBBBBBHHHC ', 'BBBBBBBBBBBBBBBBBBBBB', ' BBBBBBBBBBBBBBBBBBB ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBDDDBBBBBBBBBBBDDDBB', 'BB   BBBBBBBBBBB   BB', 'BB   BFFFBFBFFFB   BB', 'BB   BBBBBBBBBBB   BB', 'BBDDDBBBBBBBBBBBDDDBB', ' BBBBBBBBBBBBBBBBBBB ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBB', 'BBBBBBBBBBFBBBBBBBBBB', 'BBGGGBBBBBFBBBBBGGGBB', 'BBGGGBBBFFFFFBBBGGGBB', 'BBGGGBBBBBFBBBBBGGGBB', 'BBBBBBBBBBFBBBBBBBBBB', '  BBBBBBBBBBBBBBBBB  ') 
            .aisle(' BBBBBBBBBBBBBBBBBBB ', ' BBBBBBBBBBBBBBBBBBB ', ' B   BBBBBBBBBBB   B ', ' B   BBBBB@BBBBB   B ', ' B   BBBBBBBBBBB   B ', ' BBBBBBBBBBBBBBBBBBB ', '       BBBBBBB       ') 
            .aisle('      BBBBBBBBB      ', '      BBBBBBBBB      ', '      BBB   BBB      ', '      BBB   BBB      ', '      BBB   BBB      ', '      BBBBBBBBB      ', '                     ') 
            .where('A', Predicates.blocks('minecraft:stone'))
            .where(' ', Predicates.any())
            .where('B', Predicates.blocks('kubejs:inoculated_nuclei_seperation_casing')
                .or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setPreviewCount(0).setMaxGlobalLimited(20))                
                .or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1))
                .or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2))
                .or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1)))
            .where('C', $StarTThreadingStatBlocks.threadingStatBlocks())
            .where('D', Predicates.blocks('kubejs:draco_assembly_grating'))
            .where('E', Predicates.blocks('start_core:threading_controller'))
            .where('F', Predicates.blocks('kubejs:nyanium_pipe_casing'))
            .where('G', Predicates.blocks('kubejs:draco_resilient_fusion_glass'))
            .where('H', Predicates.blocks('kubejs:nuclei_seperators'))
            .where('@', Predicates.controller(Predicates.blocks(definition.get())))
            .build())
        .workableCasingRenderer('kubejs:block/casings/ultimate_multis/inoculated_nuclei_seperation_casing',
            'gtceu:block/multiblock/implosion_compressor', false);

});