GTCEuStartupEvents.registry('gtceu:recipe_type', event => {

    event.create('component_synthesis_forge')
        .category('extremely_advanced')
        .setEUIO('in')
        .setMaxIOSize(15, 1, 5, 0) //Compacting Material Flags (fine wire, foil) delayed till theta
        .setHasResearchSlot(true)
        .setSound(GTSoundEntries.ASSEMBLER)
        .setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, FillDirection.LEFT_TO_RIGHT)
        .setMaxTooltips(6);

    event.create('component_part_synthesis_forge')
        .category('extremely_advanced')
        .setEUIO('in')
        .setMaxIOSize(8, 1, 2, 0) //Compacting Material Flags (fine wire, foil) delayed till theta
        .setHasResearchSlot(true)
        .setSound(GTSoundEntries.ASSEMBLER)
        .setProgressBar(GuiTextures.PROGRESS_BAR_ARROW_MULTIPLE, FillDirection.LEFT_TO_RIGHT)
        .setMaxTooltips(6);

});

GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('multithreaded_component_synthesis_forge', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .machine((holder) => new $StarTThreadingCapableMachine(holder))
        .recipeTypes(['component_synthesis_forge', 'component_part_synthesis_forge'])
        .recipeModifiers([GTRecipeModifiers.OC_NON_PERFECT_SUBTICK, $StarTRecipeModifiers.THREADING_MACHINE])
        .appearanceBlock(() => Block.getBlock('kubejs:nyanium_machine_casing'))
        .pattern(definition => FactoryBlockPattern.start()
            .aisle('           BCBBBCB           ', '            C   C            ', '            C   C            ', '           BCBBBCB           ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ') 
            .aisle('         BBBBBBBBBBB         ', '           DEEEEED           ', '           DEEEEED           ', '         BBBFFFFFBBB         ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ') 
            .aisle('       BBBBBBBBBBBBBBB       ', '         DDGGGGGGGDD         ', '         DDGG222GGDD         ', '       BBBBBF   FBBBBB       ', '                             ', '                             ', '                             ', '             AAA             ', '            A   A            ', '            A   A            ', '            A   A            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '             AAA             ', '            A   A            ', '            A   A            ', '            A   A            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '           BBBBBBB           ') 
            .aisle('     BBBBBBBBBBBBBBBBBBB     ', '       DDGGGGGGGGGGGDD       ', '       DDGGGG222GGGGDD       ', '     BBBCCCBF   FBCCCBBB     ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '             DJD             ', '             DDD             ', '            A   A            ', '                             ', '                             ', '                             ', '                             ', '                             ', '             KKK             ', '           IIKLKII           ', '             KKK             ', '                             ', '                             ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '             DJD             ', '             DDD             ', '            A   A            ', '                             ', '                             ', '                             ', '                             ', '        BBB       BBB        ', '                             ', '                             ', '                             ', '                             ', '                             ', '         BBBCCCCCBBB         ') 
            .aisle('    CBBBBBBBBBBBBBBBBBBBC    ', '    CDDGGGGGEEEEEGGGGGDDC    ', '    CDDGGGGGEEEEEGGGGGDDC    ', '    CBBBCLCBFFFFFBCLCBBBC    ', '          I       I          ', '           I     I           ', '            I   I            ', '            AI IA            ', '             DLD             ', '           KKKMKKK           ', '             DLD             ', '            AI IA            ', '            I   I            ', '           I     I           ', '          I       I          ', '                             ', '                             ', '                             ', '         II       II         ', '                             ', '                             ', '                             ', '          I       I          ', '           I     I           ', '            I   I            ', '            AI IA            ', '             DLD             ', '           KKKMKKK           ', '             DLD             ', '            AI IA            ', '            I   I            ', '           I     I           ', '                             ', '                             ', '      BBBBBB     BBBBBB      ', '                             ', '                             ', '                             ', '           I     I           ', '            I   I            ', '        BBBBCLCLCBBBB        ') 
            .aisle('   BBBBBBBBBCBBBCBBBBBBBBB   ', '    DGGGGGDDC   CDDGGGGGD    ', '    DGGGGGDDC   CDDGGGGGD    ', '   BBBBBCCCBCBBBCBCCCBBBBB   ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '        KKK  DMD  KKK        ', '             DDD             ', '            A   A            ', '                             ', '                             ', '                             ', '         I         I         ', '                    I        ', '                             ', '        I           I        ', '                             ', '        I           I        ', '         I         I         ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '        KKK  DMD  KKK        ', '             DDD             ', '            A   A            ', '                             ', '          I       I          ', '         I         I         ', '        I           I        ', '     BCCCBBB     BBBCCCB     ', '        I           I        ', '         I         I         ', '          I       I          ', '                             ', '                             ', '        BBBBCCCCCBBBB        ') 
            .aisle('   BBBBBBBBBBBBBBBBBBBBBBB   ', '    DGGGGD         DGGGGD    ', '    DGGGGD         DGGGGD    ', '   BBBBBBBBB     BBBBBBBBB   ', '                             ', '                             ', '                             ', '             AAA             ', '            ABFBA            ', '      KK    AFFFA    KK      ', '            ABFBA            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '        I                    ', '      KK             KK      ', '      LK             KL      ', '      KK             KK      ', '                             ', '                             ', '                             ', '                             ', '                             ', '             AAA             ', '            ABFBA            ', '      KK    AFFFA    KK      ', '            ABFBA            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '    BCCLCBBB     BBBCLCCB    ', '                             ', '                             ', '                             ', '                             ', '                             ', '        BBBBBBBBBBBBB        ') 
            .aisle('  BBBBBBBBIIIIBIIIIBBBBBBBB  ', '   DGGGGD           DGGGGD   ', '   DGGGGD           DGGGGD   ', '  BBBBBBBB         BBBBBBBB  ', '                             ', '                             ', '                             ', '                             ', '              L              ', '      K      LPL      K      ', '              L              ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '      KK             KK      ', '      KL             LK      ', '      KK             KK      ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '              L              ', '      K      LPL      K      ', '              L              ', '                             ', '                             ', '                             ', '                             ', '                             ', '    BCLCCBB       BBCCLCB    ', '                             ', '                             ', '                             ', '                             ', '                             ', '         BBB     BBB         ') 
            .aisle('  BBBBBBCI   IBI   ICBBBBBB  ', '   DGGGDC           CDGGGD   ', '   DGGGDC           CDGGGD   ', '  BCCCBBC           CBBCCCB  ', '                             ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '                             ', '                             ', '                             ', '     I                I      ', '                             ', '     I                 I     ', '                             ', '     I                 I     ', '                             ', '                             ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '                             ', '                             ', '     I                 I     ', '   BBCCCBB         BBCCCBB   ', '     I                 I     ', '                             ', '                             ', '                             ', '                             ', '    BBB               BBB    ') 
            .aisle(' BBBBBBBI    IBI    IBBBBBBB ', '  DGGGD               DGGGD  ', '  DGGGD               DGGGD  ', ' BBCLCBB             BBCLCBB ', '                             ', '                             ', '                             ', '                             ', '                             ', '     K        H        K     ', '                             ', '                             ', '                             ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '                             ', '                             ', '                             ', '     K        H        K     ', '                             ', '                             ', '                             ', '                             ', '     I                 I     ', '                             ', '   BBBBBB           BBBBBB   ', '                             ', '     I                 I     ', '                             ', '                             ', '                             ', '   BBBBB             BBBBB   ') 
            .aisle(' BBBBBBI    IIBII    IBBBBBB ', '  DGGD                 DGGD  ', '  DGGD                 DGGD  ', ' BBCCCB               BCCCBB ', '    I                   I    ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '   BBBBB             BBBBB   ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '   BBBBB             BBBBB   ') 
            .aisle('BBBBBBBI   IBBBBBI   IBBBBBBB', ' DGGGD                 DGGGD ', ' DGGGD                 DGGGD ', 'BBBBBBB               BBBBBBB', '                             ', '    I                   I    ', '                             ', '                             ', '              L              ', '    K        LPL        K    ', '              L              ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '                             ', '   I                     I   ', '                             ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '              L              ', '    K        LPL        K    ', '              L              ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '    BBB               BBB    ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '  BBBBBB             BBBBBB  ') 
            .aisle('CBBBBCBI  IBCBBBCBI  IBCBBBBC', 'CEGGEC      CAAAC      CEGGEC', 'CEGGEC                 CEGGEC', 'CFFFFC                 CFFFFC', '                             ', '                             ', '    I                   I    ', '   AAA       AAA      AAAA   ', '  A   A     ABFBA     A   A  ', '  A K A     AFFFA     A K A  ', '  A   A     ABFBA     A   A  ', '   AAA       AAA       AAA   ', '    I                   I    ', '                             ', '                             ', '                             ', '                             ', '              D              ', '   I          Q          I   ', '              D              ', '                             ', '                             ', '                             ', '                             ', '    I                   I    ', '   AAA       AAA      AAAA   ', '  A   A     ABFBA     A   A  ', '  A K A     AFFFA     A K A  ', '  A   A     ABFBA     A   A  ', '   AAA       AAA       AAA   ', '    I                   I    ', '                             ', '                             ', '                             ', '                             ', '             AAA             ', '            A   A            ', '            A   A            ', '            A   A            ', '    I        AAA        I    ', '  BCCCB               BCCCB  ') 
            .aisle('BBBBBBBIIIIBBBBBBBIIIIBBBBBBB', ' EGGE       ABFBA       EGGE ', ' E22E         L         E22E ', 'BF  FB        L        BF  FB', '                             ', '              L              ', '              L              ', '  A I A     ABFBA     A I A  ', '   DDDB     BPHPB     BDDD   ', '   DKDFLL LLFHHHFLL LLFDKD   ', '   DDDB     BPHPB     BDDD   ', '  A I A     ABFBA     A I A  ', '              L              ', '              L              ', '                             ', '              L              ', '              L              ', '   K         DPD         K   ', '   K         DPD         K   ', '   K         DPD         K   ', '              L              ', '              L              ', '                             ', '              L              ', '              L              ', '  A I A     ABFBA     A I A  ', '   DDDB     BPHPB     BDDD   ', '   DKDFLL LLFHHHFLL LLFDKD   ', '   DDDB     BPHPB     BDDD   ', '  A I A     ABFBA     A I A  ', '              L              ', '              L              ', '                             ', '              L              ', '              L              ', '            ABFBA            ', '             000             ', '             000             ', '             000             ', '            A   A            ', '  BCLCB               BCLCB  ') 
            .aisle('BBBBBBBBBBBBBBBBBBBBBBBBBBBBB', ' EGGE       AFFFA       EGGE ', ' E22E        LPL        E22E ', 'BF  FB       LPL       BF  FB', '              H              ', '             LPL             ', '             LPL             ', '  A   A     AFFFA     A   A  ', '   DLDFLL LLFHHHFLL LLFDLD   ', '   JMMFPPHPPFHHHFPPHPPFMMJ   ', '   DLDFLL LLFHHHFLL LLFDLD   ', '  A   A     AFFFA     A   A  ', '             LPL             ', '             LPL             ', '              H              ', '             LPL             ', '             LPL             ', '   K        DPHPD        K   ', '   L        DPHPD        L   ', '   K        DPHPD        K   ', '             LPL             ', '             LPL             ', '              H              ', '             LPL             ', '             LPL             ', '  A   A     AFFFA     A   A  ', '   DLDFLL LLFHHHFLL LLFDLD   ', '   JMMFPPHPPFHHHFPPHPPFMMJ   ', '   DLDFLL LLFHHHFLL LLFDLD   ', '  A   A     AFFFA     A   A  ', '             LPL             ', '             LPL             ', '              H              ', '             LPL             ', '             LPL             ', '            AFFFA            ', '             0M0             ', '             0M0             ', '             000             ', '            A   A            ', '  BCCCB               BCCCB  ') 
            .aisle('BBBBBBBIIIIBBBBBBBIIIIBBBBBBB', ' EGGE       ABFBA       EGGE ', ' E22E         L         E22E ', 'BF  FB        L        BF  FB', '                             ', '              L              ', '              L              ', '  A I A     ABFBA     A I A  ', '   DDDB     BPHPB     BDDD   ', '   DKDFLL LLFHHHFLL LLFDKD   ', '   DDDB     BPHPB     BDDD   ', '  A I A     ABFBA     A I A  ', '              L              ', '              L              ', '                             ', '              L              ', '              L              ', '   K         DPD         K   ', '   K         DPD         K   ', '   K         DPD         K   ', '              L              ', '              L              ', '                             ', '              L              ', '              L              ', '  A I A     ABFBA     A I A  ', '   DDDB     BPHPB     BDDD   ', '   DKDFLL LLFHHHFLL LLFDKD   ', '   DDDB     BPHPB     BDDD   ', '  A I A     ABFBA     A I A  ', '              L              ', '              L              ', '                             ', '              L              ', '              L              ', '            ABFBA            ', '             000             ', '             000             ', '             000             ', '            A   A            ', '  BCLCB               BCLCB  ') 
            .aisle('CBBBBCBI  IBCBBBCBI  IBCBBBBC', 'CEGGEC      CAAAC      CEGGEC', 'CEGGEC                 CEGGEC', 'CFFFFC                 CFFFFC', '                             ', '                             ', '    I                   I    ', '   AAA       AAA       AAA   ', '  A   A     ABFBA     A   A  ', '  A K A     AFFFA     A K A  ', '  A   A     ABFBA     A   A  ', '   AAA       AAA       AAA   ', '    I                   I    ', '                             ', '                             ', '                             ', '                             ', '              D              ', '   I          @          I   ', '              D              ', '                             ', '                             ', '                             ', '                             ', '    I                   I    ', '   AAA       AAA       AAA   ', '  A   A     ABFBA     A   A  ', '  A K A     AFFFA     A K A  ', '  A   A     ABFBA     A   A  ', '   AAA       AAA       AAA   ', '    I                   I    ', '                             ', '                             ', '                             ', '                             ', '             AAA             ', '            A   A            ', '            A   A            ', '            A   A            ', '    I        AAA        I    ', '  BCCCB               BCCCB  ') 
            .aisle('BBBBBBBI   IBBBBBI   IBBBBBBB', ' DGGGD                 DGGGD ', ' DGGGD                 DGGGD ', 'BBBBBBB               BBBBBBB', '                             ', '    I                   I    ', '                             ', '                             ', '              L              ', '    K        LPL        K    ', '              L              ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '                             ', '   I                     I   ', '                             ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '              L              ', '    K        LPL        K    ', '              L              ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '    BBB               BBB    ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '  BBBBBB             BBBBBB  ') 
            .aisle(' BBBBBBI    IIBII    IBBBBBB ', '  DGGD                 DGGD  ', '  DGGD                 DGGD  ', ' BBCCCB               BCCCBB ', '    I                   I    ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '   BBBBB             BBBBB   ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '   BBBBB             BBBBB   ') 
            .aisle(' BBBBBBBI    IBI    IBBBBBBB ', '  DGGGD               DGGGD  ', '  DGGGD               DGGGD  ', ' BBCLCBB             BBCLCBB ', '                             ', '                             ', '                             ', '                             ', '                             ', '     K        H        K     ', '                             ', '                             ', '                             ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '    I                   I    ', '                             ', '                             ', '     I                 I     ', '                             ', '                             ', '                             ', '                             ', '                             ', '     K        H        K     ', '                             ', '                             ', '                             ', '                             ', '     I                 I     ', '                             ', '   BBBBBB           BBBBBB   ', '                             ', '     I                 I     ', '                             ', '                             ', '                             ', '   BBBBB             BBBBB   ') 
            .aisle('  BBBBBBCI   IBI   ICBBBBBB  ', '   DGGGDC           CDGGGD   ', '   DGGGDC           CDGGGD   ', '  BCCCBBC           CBBCCCB  ', '                             ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '                             ', '                             ', '                             ', '      I                I     ', '                             ', '     I                 I     ', '                             ', '     I                 I     ', '                             ', '                             ', '                             ', '                             ', '                             ', '              L              ', '     K       LPL       K     ', '              L              ', '                             ', '                             ', '                             ', '                             ', '     I                 I     ', '   BBCCCBB         BBCCCBB   ', '     I                 I     ', '                             ', '                             ', '                             ', '                             ', '    BBB               BBB    ') 
            .aisle('  BBBBBBBBIIIIBIIIIBBBBBBBB  ', '   DGGGGD           DGGGGD   ', '   DGGGGD           DGGGGD   ', '  BBBBBBBB         BBBBBBBB  ', '                             ', '                             ', '                             ', '                             ', '              L              ', '      K      LPL      K      ', '              L              ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '      KK             KK      ', '      KL             LK      ', '      KK             KK      ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '              L              ', '      K      LPL      K      ', '              L              ', '                             ', '                             ', '                             ', '                             ', '                             ', '    BCLCCBB       BBCCLCB    ', '                             ', '                             ', '                             ', '                             ', '                             ', '         BBB     BBB         ') 
            .aisle('   BBBBBBBBBBBBBBBBBBBBBBB   ', '    DGGGGD         DGGGGD    ', '    DGGGGD         DGGGGD    ', '   BBBBBBBBB     BBBBBBBBB   ', '                             ', '                             ', '                             ', '             AAA             ', '            ABFBA            ', '      KK    AFFFA    KK      ', '            ABFBA            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '                    I        ', '      KK             KK      ', '      LK             KL      ', '      KK             KK      ', '                             ', '                             ', '                             ', '                             ', '                             ', '             AAA             ', '            ABFBA            ', '      KK    AFFFA    KK      ', '            ABFBA            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '    BCCLCBBB     BBBCLCCB    ', '                             ', '                             ', '                             ', '                             ', '                             ', '        BBBBBBBBBBBBB        ') 
            .aisle('   BBBBBBBBBCBBBCBBBBBBBBB   ', '    DGGGGGDDC   CDDGGGGGD    ', '    DGGGGGDDC   CDDGGGGGD    ', '   BBBBBCCCBCBBBCBCCCBBBBB   ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '        KKK  DMD  KKK        ', '             DDD             ', '            A   A            ', '                             ', '                             ', '                             ', '         I         I         ', '        I                    ', '                             ', '        I           I        ', '                             ', '        I           I        ', '         I         I         ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '        KKK  DMD  KKK        ', '             DDD             ', '            A   A            ', '                             ', '          I       I          ', '         I         I         ', '        I           I        ', '     BCCCBBB     BBBCCCB     ', '        I           I        ', '         I         I         ', '          I       I          ', '                             ', '                             ', '        BBBBCCCCCBBBB        ') 
            .aisle('    CBBBBBBBBBBBBBBBBBBBC    ', '    CDDGGGGGEEEEEGGGGGDDC    ', '    CDDGGGGGEEEEEGGGGGDDC    ', '    CBBBCLCBFFFFFBCLCBBBC    ', '          I       I          ', '           I     I           ', '            I   I            ', '            AI IA            ', '             DLD             ', '           KKKMKKK           ', '             DLD             ', '            AI IA            ', '            I   I            ', '           I     I           ', '          I       I          ', '                             ', '                             ', '                             ', '         II       II         ', '                             ', '                             ', '                             ', '          I       I          ', '           I     I           ', '            I   I            ', '            AI IA            ', '             DLD             ', '           KKKMKKK           ', '             DLD             ', '            AI IA            ', '            I   I            ', '           I     I           ', '                             ', '                             ', '      BBBBBB     BBBBBB      ', '                             ', '                             ', '                             ', '           I     I           ', '            I   I            ', '        BBBBCLCLCBBBB        ') 
            .aisle('     BBBBBBBBBBBBBBBBBBB     ', '       DDGGGGGGGGGGGDD       ', '       DDGGGG222GGGGDD       ', '     BBBCCCBF   FBCCCBBB     ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '             DJD             ', '             DDD             ', '            A   A            ', '                             ', '                             ', '                             ', '                             ', '                             ', '             KKK             ', '           IIKLKII           ', '             KKK             ', '                             ', '                             ', '                             ', '                             ', '                             ', '            A   A            ', '             DDD             ', '             DJD             ', '             DDD             ', '            A   A            ', '                             ', '                             ', '                             ', '                             ', '        BBB       BBB        ', '                             ', '                             ', '                             ', '                             ', '                             ', '         BBBCCCCCBBB         ') 
            .aisle('       BBBBBBBBBBBBBBB       ', '         DDGGGGGGGDD         ', '         DDGG222GGDD         ', '       BBBBBF   FBBBBB       ', '                             ', '                             ', '                             ', '             AAA             ', '            A   A            ', '            A   A            ', '            A   A            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '             AAA             ', '            A   A            ', '            A   A            ', '            A   A            ', '             AAA             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '           BBBBBBB           ') 
            .aisle('         BBBBBBBBBBB         ', '           DEEEEED           ', '           DEEEEED           ', '         BBBFFFFFBBB         ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ') 
            .aisle('           BCBBBCB           ', '            C   C            ', '            C   C            ', '           BCBBBCB           ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ', '                             ') 
            .where('A', Predicates.blocks('gtceu:sturdy_machine_casing'))
            .where(' ', Predicates.any())
            .where('B', Predicates.blocks('kubejs:advanced_assembly_casing'))
            .where('C', Predicates.blocks('kubejs:draco_assembly_grating'))
            .where('D', Predicates.blocks('kubejs:nyanium_machine_casing'))
            .where('E', Predicates.blocks('kubejs:nyanium_machine_firebox_casing'))
            .where('F', Predicates.blocks('start_core:fusion_casing_mk4'))
            .where('G', Predicates.blocks('kubejs:superdense_assembly_machine_casing'))
            .where('H', Predicates.blocks('start_core:advanced_fusion_coil'))
            .where('I', Predicates.blocks('kubejs:draco_resilient_fusion_glass'))
            .where('J', Predicates.blocks('gtceu:uiv_rotor_holder'))
            .where('K', Predicates.blocks('gtceu:palladium_substation'))
            .where('L', Predicates.blocks('kubejs:draco_ware_casing'))
            .where('M', Predicates.blocks('kubejs:nyanium_pipe_casing'))
            .where('P', Predicates.blocks('kubejs:superdense_assembly_control_casing'))
            .where('Q', Predicates.blocks('start_core:threading_controller'))
            .where('2', $StarTThreadingStatBlocks.threadingStatBlocks())
            .where('0', Predicates.blocks('kubejs:nyanium_machine_casing')
                .or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.OPTICAL_DATA_RECEPTION).setMaxGlobalLimited(1).setPreviewCount(0))
                .or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2).setPreviewCount(0))
                .or(Predicates.blocks('gtceu:uhv_stabilization_module').setExactLimit(1)))
            .where('@', Predicates.controller(Predicates.blocks(definition.get())))
            .build())
        .workableCasingRenderer('kubejs:block/casings/nyanium/casing',
            'gtceu:block/machines/assembler', false);
});