GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('ascendant_engraving_matrix', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .machine((holder) => new $StarTThreadingCapableMachine(holder))
        .recipeTypes(['laser_engraver', 'runic_circuitry_assembling_station', 'runic_inscribe_manipulate'])
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, $StarTRecipeModifiers.BULK_PROCESSING, GTRecipeModifiers.OC_NON_PERFECT_SUBTICK, $StarTRecipeModifiers.THREADING_MACHINE])
        .appearanceBlock(() => Block.getBlock('kubejs:ionic_engraving_casing'))
        .pattern(definition => FactoryBlockPattern.start()
            .aisle('   BCCCB   ', '   BC CB   ', '   BCDCB   ', '   BCDCB   ', '   BC CB   ', '   BCCCB   ', '   BBBBB   ', '   B   B   ', '   B   B   ', '   B   B   ', '   BBBBB   ', '    CCC    ', '    C C    ', '    CCC    ', '   BBBBB   ', '     B     ', '     B     ', '           ', '           ') 
            .aisle('  CCCCCCC  ', '  CCCECCC  ', '  CCCFCCC  ', '  CCCFCCC  ', '    CECG   ', '    CFCG   ', '  BBCCCBB  ', '    CCC    ', '           ', '    CCC    ', '  BBCCCBB  ', '   BCCCB   ', '   BCECB   ', '   BCCCB   ', '  BBGGGBB  ', '    GGG    ', '     B     ', '     B     ', '           ') 
            .aisle(' CCDDDDDCC ', ' CC  F  CC ', ' CCFFFFFCC ', ' CC  F  CC ', '  GG F  G  ', '  GG F  G  ', ' BBG D GBB ', '   G D G   ', '    DDD    ', '   G   G   ', ' BBG   GBB ', '  GG   GG  ', '  GG H GG  ', '  GG   GG  ', ' BBG   GBB ', '   G   G   ', '    GGG    ', '     B     ', '     B     ') 
            .aisle('BCDDDDDDDCB', 'BC       CB', 'BCF     FCB', 'BC       CB', 'B G      GB', 'B G      GB', 'BBG     GBB', 'B G     G B', 'B  D   D  B', 'B G     G B', 'BBG     GBB', ' BG     GB ', ' BG  H  GB ', ' BG     GB ', 'BBG     GBB', '  G     G  ', '   G   G   ', '    GGG    ', '     B     ') 
            .aisle('CCDDDDDDDCC', 'CC       CC', 'CCF     FCC', 'CC       CC', 'CC       CC', 'CC       CC', 'BC       CB', ' C       C ', '  D     D  ', ' C       C ', 'BC       CB', 'CC       CC', 'CC       CC', 'CC       CC', 'BG       GB', ' G       G ', '  G     G  ', '   GGGGG   ', '     B     ') 
            .aisle('CCDDDDDDDCC', ' EF     FE ', 'DFF     FFD', 'DFF     FFD', ' EF     FE ', 'CFF  I  FFC', 'BCD     DCB', ' CD     DC ', '  D  J  D  ', ' C       C ', 'BC       CB', 'CC   I   CC', ' EHH   HHE ', 'CC       CC', 'BG       GB', 'BG       GB', 'BBG     GBB', ' BBGGGGGBB ', '  BBBBBBB  ') 
            .aisle('CCDDDDDDDCC', 'CC       CC', 'CCF     FCC', 'CC       CC', 'CC       CC', 'CC       CC', 'BC       CB', ' C       C ', '  D     D  ', ' C       C ', 'BC       CB', 'CC       CC', 'CC       CC', 'CC       CC', 'BG       GB', ' G       G ', '  G     G  ', '   GGGGG   ', '     B     ') 
            .aisle('BCDDDDDDDCB', 'BC       CB', 'BCF     FCB', 'BC       CB', 'B G     G B', 'B G     G B', 'BBG     GBB', 'B G     G B', 'B  D   D  B', 'B G     G B', 'BBG     GBB', ' BG     GB ', ' BG  H  GB ', ' BG     GB ', 'BBG     GBB', '  G     G  ', '   G   G   ', '    GGG    ', '     B     ') 
            .aisle(' CCDDDDDCC ', ' CC  F  CC ', ' CCFFFFFCC ', ' CC  F  CC ', '  GG F GG  ', '  GG F GG  ', ' BBG D GBB ', '   G D G   ', '    DDD    ', '   G   G   ', ' BBG   GBB ', '  GG   GG  ', '  GG H GG  ', '  GG   GG  ', ' BBG   GBB ', '   G   G   ', '    GGG    ', '     B     ', '     B     ') 
            .aisle('  CCCCCCC  ', '  CCCFCCC  ', '  CCCFCCC  ', '  CCCFCCC  ', '    CFC    ', '    CFC    ', '  BBCCCBB  ', '    CCC    ', '           ', '    CCC    ', '  BBCCCBB  ', '   BCCCB   ', '   BCKCB   ', '   BCCCB   ', '  BBGGGBB  ', '    GGG    ', '     B     ', '     B     ', '           ') 
            .aisle('   BCCCB   ', '   BCCCB   ', '   BCCCB   ', '   BC@CB   ', '   BCCCB   ', '   BCCCB   ', '   BBBBB   ', '   B   B   ', '   B   B   ', '   B   B   ', '   BBBBB   ', '    CCC    ', '    C C    ', '    CCC    ', '   BBBBB   ', '     B     ', '     B     ', '           ', '           ') 
            .where(' ', Predicates.any())
            .where('B', Predicates.blocks('gtceu:expetidalloy_d_17_frame'))
            .where('C', Predicates.blocks('kubejs:ionic_engraving_casing')
                .or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setPreviewCount(0).setMaxGlobalLimited(20))                
                .or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1))
                .or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2))
                .or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1)))
            .where('D', Predicates.blocks('kubejs:draco_assembly_grating'))
            .where('E', $StarTThreadingStatBlocks.threadingStatBlocks())
            .where('F', Predicates.blocks('kubejs:superdense_assembly_control_casing'))
            .where('G', Predicates.blocks('kubejs:draco_resilient_fusion_glass'))
            .where('H', Predicates.blocks('start_core:advanced_fusion_coil'))
            .where('I', Predicates.blocks('kubejs:laser_casing'))
            .where('J', Predicates.blocks('kubejs:inscribe_casing'))
            .where('K', Predicates.blocks('start_core:threading_controller'))
            .where('@', Predicates.controller(Predicates.blocks(definition.get())))
            .build())
        .workableCasingRenderer('kubejs:block/casings/ultimate_multis/ionic_engraving_casing',
            'gtceu:block/multiblock/implosion_compressor', false);

});