GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('aqueous_transformation_processing_center', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .machine((holder) => new $StarTThreadingCapableMachine(holder))
        .recipeTypes(['extractor', 'canner', 'fluid_solidifier'])
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, $StarTRecipeModifiers.BULK_PROCESSING, GTRecipeModifiers.OC_NON_PERFECT_SUBTICK, $StarTRecipeModifiers.THREADING_MACHINE])
        .appearanceBlock(() => Block.getBlock('kubejs:subatomically_secure_casing'))
        .pattern(definition => FactoryBlockPattern.start()
            .aisle('     B B     ', '    BBBBB    ', '             ', '             ', '             ', '             ', '             ', '             ', '             ', '             ') 
            .aisle('   BCCCCCB   ', '   BCCCCCB   ', '  BBCCCCCBB  ', '   BCCDCCB   ', '   BCCCCCB   ', '   BCCCCCB   ', '   BCCCCCB   ', '    BBBBB    ', '             ', '             ') 
            .aisle(' B CCCCCCC B ', ' B CE E EC B ', ' BBCB B BCBB ', '   CE E EC   ', '   CB B BC   ', '   CE E EC   ', '   CB B BC   ', '   BCCCCCB   ', '      B      ', '             ') 
            .aisle('  CCCCCCCCC  ', '  C E E E C  ', ' BC       CB ', '  C E E E C  ', '  F       F  ', '  C E E E C  ', '  C       C  ', '  BCC E CCB  ', '     CCC     ', '      B      ') 
            .aisle(' BCCCCCCCCCB ', ' BC E E E CB ', 'BBC       CBB', '  C E E E C  ', '  F       F  ', '  C E E E C  ', '  C       C  ', '  BCE E ECB  ', '    CCCCC    ', '      B      ') 
            .aisle(' CCCCCCCCCCC ', ' CE E E E EC ', 'BCB       BCB', ' CE E E E EC ', ' CB       BC ', ' CE E E E EC ', ' CB       BC ', ' BCCE E ECCB ', '   BCCCCCB   ', '     B B     ') 
            .aisle('BCCCCCCCCCCCB', 'BCE E E E ECB', 'BC         CB', 'BCE E E E ECB', 'BC         CB', 'BCE E E E ECB', 'BC         CB', ' BC E E E CB ', '   CCCCCCC   ', '    B   B    ') 
            .aisle(' CCCCCCCCCCC ', ' CE E E E EC ', 'BC         CB', ' CE E E E EC ', ' C         C ', ' CE E E E EC ', ' C         C ', ' BC E E E CB ', '   CCCCCCC   ', '    B   B    ') 
            .aisle('BCCCCCCCCCCCB', 'BCEBEBEBEBECB', 'BCB B B B BCB', ' CE E E E EC ', ' CB B B B BC ', ' CE E E E EC ', ' CB B B B BC ', ' BCBEBEBEBCB ', '   CCCCCCC   ', '    B   B    ') 
            .aisle(' CCCCCCCCCCC ', ' CE E E E EC ', 'BC         CB', ' CE E E E EC ', ' C         C ', ' CE E E E EC ', ' C         C ', ' BC E E E CB ', '   CCCCCCC   ', '    B   B    ') 
            .aisle('BCCCCCCCCCCCB', 'BCE E E E ECB', 'BC         CB', 'BCE E E E ECB', 'BC         CB', 'BCE E E E ECB', 'BC         CB', ' BC E E E CB ', '   CCCCCCC   ', '    B   B    ') 
            .aisle(' CCCCCCCCCCC ', ' CE E E E EC ', 'BCB       BCB', ' CE E E E EC ', ' CB       BC ', ' CE E E E EC ', ' CB       BC ', ' BCCE E ECCB ', '   BCCCCCB   ', '     B B     ') 
            .aisle(' BCCCCCCCCCB ', ' BC E E E CB ', 'BBC       CBB', '  C E E E C  ', '  F       F  ', '  C E E E C  ', '  C       C  ', '  BCE E ECB  ', '    CCCCC    ', '      B      ') 
            .aisle('  CCCCCCCCC  ', '  C E E E C  ', ' BC       CB ', '  C E E E C  ', '  F       F  ', '  C E E E C  ', '  C       C  ', '  BCC E CCB  ', '     CCC     ', '      B      ') 
            .aisle(' B CCCCCCC B ', ' B CE E EC B ', ' BBCB B BCBB ', '   CE E EC   ', '   CB B BC   ', '   CE E EC   ', '   CB B BC   ', '   BCCCCCB   ', '      B      ', '             ') 
            .aisle('   BCCCCCB   ', '   BCCCCCB   ', '  BBCCCCCBB  ', '   BCC@CCB   ', '   BCCCCCB   ', '   BCCCCCB   ', '   BCCCCCB   ', '    BBBBB    ', '             ', '             ') 
            .aisle('     B B     ', '    BBBBB    ', '             ', '             ', '             ', '             ', '             ', '             ', '             ', '             ') 
            .where(' ', Predicates.any())
            .where('B', Predicates.blocks('gtceu:mythrotight_carbide_steel_frame'))
            .where('C', Predicates.blocks('kubejs:subatomically_secure_casing')
                .or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setPreviewCount(0).setMaxGlobalLimited(20))                
                .or(Predicates.abilities(PartAbility.EXPORT_FLUIDS).setPreviewCount(0).setMaxGlobalLimited(20))
                .or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1))
                .or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2))
                .or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1)))
            .where('D', Predicates.blocks('start_core:threading_controller'))
            .where('E', Predicates.blocks('kubejs:nyanium_pipe_casing'))
            .where('F', $StarTThreadingStatBlocks.threadingStatBlocks())
            .where('@', Predicates.controller(Predicates.blocks(definition.get())))
            .build())
        .workableCasingRenderer('kubejs:block/casings/ultimate_multis/subatomically_secure_casing',
            'gtceu:block/multiblock/implosion_compressor', false);

});