GTCEuStartupEvents.registry('gtceu:machine', event => {

    event.create('mega_abs', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .machine((holder) => new $CoiledMulti(holder))
        .recipeType('alloy_blast_smelter')
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, $StarTRecipeModifiers.EBF_OVERCLOCK]) // Will have same issues with coils that the RHF has but that will be fixed later on.
        .appearanceBlock(() => Block.getBlock('kubejs:extreme_temperature_smelting_casing'))
        .pattern(definition => FactoryBlockPattern.start()
			.aisle('     B   B     ', '     B   B     ', '     B   B     ', '     BBBBB     ', '       C       ', '       C       ', '     CCCCC     ', '       C       ', '       C       ', '       C       ', '       C       ', '       C       ', '     CCCCC     ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ') 
			.aisle(' CB  BDDDB  BC ', ' CB  BDEDB  BC ', ' CB  BDDDB  BC ', ' CBBBBBBBBBBBC ', ' C  C     C  C ', ' C  C     C  C ', ' CCCCBBBBBCCCC ', '    C     C    ', '    C     C    ', '    C     C    ', '    C     C    ', '    C     C    ', '   CCBBBBBCC   ', '       C       ', '       C       ', '       C       ', '       C       ', '       C       ', '     CCCCC     ', '               ', '               ', '               ', '               ', '               ', '               ') 
			.aisle(' BBDDBBBBBDDBB ', ' BBDDBBBBBDDBB ', ' BBDDBBBBBDDBB ', ' BBBBBBBBBBBBB ', '       F       ', '       F       ', ' CCBBBBFBBBBCC ', '       F       ', '       F       ', '       F       ', '       F       ', '       F       ', '  CBBBBFBBBBC  ', '   C       C   ', '   C       C   ', '   C       C   ', '   C       C   ', '   C       C   ', '   CCBBBBBCC   ', '               ', '               ', '               ', '               ', '               ', '     BBBBB     ') 
			.aisle('  DBBBBBBBBBD  ', '  DBBBBBBBBBD  ', '  DBBBBBBBBBD  ', ' BBBBBGHGBBBBB ', '   F  IFI  F   ', '   F  GHG  F   ', ' CBFBBBFBBBFBC ', '   F  GHG  F   ', '   F  EEE  F   ', '   F  EEE  F   ', '   F  EEE  F   ', '   F  GHG  F   ', ' CBFBBBBBBBFBC ', '  C    F    C  ', '  C    F    C  ', '  C    F    C  ', '  C    F    C  ', '  C    F    C  ', '  CCBBBFBBBCC  ', '       C       ', '       C       ', '       C       ', '       C       ', '       C       ', '   BBBBBBBBB   ') 
			.aisle('  DBBBBBBBBBD  ', '  DBBBBBBBBBD  ', '  DBBBEEEBBBD  ', ' BBBBH   HBBBB ', ' C  II   II  C ', ' C  GH   HG  C ', ' CBBBB F BBBBC ', ' C  II   II  C ', ' C  EE   EE  C ', ' C  FE   EF  C ', ' C  EE   EE  C ', ' C  II   II  C ', ' CBBBBBFBBBBBC ', '    FIGHGIF    ', '    FEEEEEF    ', '    GFEEEFG    ', '    FEEEEEF    ', '    FIGHGIF    ', '  CBFBBBBBFBC  ', '    C  F  C    ', '    C  F  C    ', '    CCCFCCC    ', '    C  F  C    ', '    C  F  C    ', '   BBBBFBBBB   ') 
			.aisle('BBBBBBBBBBBBBBB', 'BBBBBBBBBBBBBBB', 'BBBBBEEEEEBBBBB', 'BBBBH     HBBBB', '    I     I    ', '    H     H    ', 'CBBBB FFF BBBBC', '    I     I    ', '    E     E    ', '    E     E    ', '    E     E    ', '    I     I    ', 'CBBBB  F  BBBBC', '    I     I    ', '    E     E    ', '    F     F    ', '    E     E    ', '    I     I    ', ' CBBBBBFBBBBBC ', '     FIHIF     ', '     FEEEF     ', '    CFDDDFC    ', '     FEEEF     ', '     FIHIF     ', '  BBBFFFFFBBB  ') 
			.aisle(' DBBBBBBBBBBBD ', ' DBBBBBBBBBBBD ', ' DBBEEDDDEEBBD ', 'BBBG       GBBB', '   I       I   ', '   G       G   ', 'CBBB F F F BBBC', '   G       G   ', '   E       E   ', '   E       E   ', '   E       E   ', '   G       G   ', 'CBBBB FFF BBBBC', '    G     G    ', '    E     E    ', '    E     E    ', '    E     E    ', '    G     G    ', ' CBBBB F BBBBC ', '     I   I     ', '     E   E     ', '    CD   DC    ', '     E   E     ', '     I   I     ', '  BBBFBBBFBBB  ') 
			.aisle(' DBBBBBBBBBBBD ', ' EBBBBBBBBBBBE ', ' DBBEEDEDEEBBD ', 'BBBH       HBBB', 'C FF       FF C', 'C FH       HF C', 'CBFFFFFFFFFFFBC', 'C FH       HF C', 'C FE       EF C', 'C FE       EF C', 'C FE       EF C', 'C FH       HF C', 'CBFBFFF FFFBFBC', ' C FH     HF C ', ' C FE     EF C ', ' C GE     EG C ', ' C FE     EF C ', ' C FH     HF C ', ' CBFBFFFFFBFBC ', '   CFH   HFC   ', '   CFE   EFC   ', '   CFD   DFC   ', '   CFE   EFC   ', '   CFH   HFC   ', '  BBFFBMBFFBB  ') 
			.aisle(' DBBBBBBBBBBBD ', ' DBBBBBBBBBBBD ', ' DBBEEDDDEEBBD ', 'BBBG       GBBB', '   I       I   ', '   G       G   ', 'CBBB F F F BBBC', '   G       G   ', '   E       E   ', '   E       E   ', '   E       E   ', '   G       G   ', 'CBBBB FFF BBBBC', '    G     G    ', '    E     E    ', '    E     E    ', '    E     E    ', '    G     G    ', ' CBBBB F BBBBC ', '     I   I     ', '     E   E     ', '    CD   DC    ', '     E   E     ', '     I   I     ', '  BBBFBBBFBBB  ') 
			.aisle('BBBBBBBBBBBBBBB', 'BBBBBBBBBBBBBBB', 'BBBBBEEEEEBBBBB', 'BBBBH     HBBBB', '    I     I    ', '    H     H    ', 'CBBBB FFF BBBBC', '    I     I    ', '    E     E    ', '    E     E    ', '    E     E    ', '    I     I    ', 'CBBBB  F  BBBBC', '    I     I    ', '    E     E    ', '    F     F    ', '    E     E    ', '    I     I    ', ' CBBBBBFBBBBBC ', '     FIHIF     ', '     FEEEF     ', '    CFDDDFC    ', '     FEEEF     ', '     FIHIF     ', '  BBBFFFFFBBB  ') 
			.aisle('  DBBBBBBBBBD  ', '  DBBBBBBBBBD  ', '  DBBBEEEBBBD  ', ' BBBBH   HBBBB ', ' C  II   II  C ', ' C  GH   HG  C ', ' CBBBB F BBBBC ', ' C  II   II  C ', ' C  EE   EE  C ', ' C  FE   EF  C ', ' C  EE   EE  C ', ' C  II   II  C ', ' CBBBBBFBBBBBC ', '    FIGHGIF    ', '    FEEEEEF    ', '    GFEEEFG    ', '    FEEEEEF    ', '    FIGHGIF    ', '  CBFBBBBBFBC  ', '    C  F  C    ', '    C  F  C    ', '    CCCFCCC    ', '    C  F  C    ', '    C  F  C    ', '   BBBBFBBBB   ') 
			.aisle('  DBBBBBBBBBD  ', '  DBBBBBBBBBD  ', '  DBBBBBBBBBD  ', ' BBBBBGHGBBBBB ', '   F  IFI  F   ', '   F  GHG  F   ', ' CBFBBBFBBBFBC ', '   F  GHG  F   ', '   F  EEE  F   ', '   F  EEE  F   ', '   F  EEE  F   ', '   F  GHG  F   ', ' CBFBBBBBBBFBC ', '  C    F    C  ', '  C    F    C  ', '  C    G    C  ', '  C    F    C  ', '  C    F    C  ', '  CCBBBFBBBCC  ', '       C       ', '       C       ', '       C       ', '       C       ', '       C       ', '   BBBBBBBBB   ') 
			.aisle(' BBDDBBBBBDDBB ', ' BBDDBBBBBDDBB ', ' BBDDBBBBBDDBB ', ' BBBBBBBBBBBBB ', '       F       ', '       F       ', ' CCBBBBFBBBBCC ', '       F       ', '       F       ', '       F       ', '       F       ', '       F       ', '  CBBBBFBBBBC  ', '   C       C   ', '   C       C   ', '   C       C   ', '   C       C   ', '   C       C   ', '   CCBBBBBCC   ', '               ', '               ', '               ', '               ', '               ', '     BBBBB     ') 
			.aisle(' CB  BGIGB  BC ', ' CB  BF@FB  BC ', ' CB  BGIGB  BC ', ' CBBBBBBBBBBBC ', ' C  C     C  C ', ' C  C     C  C ', ' CCCCBBBBBCCCC ', '    C     C    ', '    C     C    ', '    C     C    ', '    C     C    ', '    C     C    ', '   CCBBBBBCC   ', '       C       ', '       C       ', '       C       ', '       C       ', '       C       ', '     CCCCC     ', '               ', '               ', '               ', '               ', '               ', '               ') 
			.aisle('     B   B     ', '     B   B     ', '     B   B     ', '     BBBBB     ', '       C       ', '       C       ', '     CCCCC     ', '       C       ', '       C       ', '       C       ', '       C       ', '       C       ', '     CCCCC     ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ', '               ') 
			.where('M', Predicates.abilities(PartAbility.MUFFLER))
			.where(' ', Predicates.any())
			.where('B', Predicates.blocks('kubejs:extreme_temperature_smelting_casing').setMinGlobalLimited(804)
                .or(Predicates.autoAbilities(definition.getRecipeTypes()))
                .or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1))
                .or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1)))
			.where('C', Predicates.blocks('gtceu:enriched_estalt_frame'))
			.where('D', Predicates.blocks('gtceu:heat_vent'))
			.where('E', Predicates.heatingCoils())
			.where('F', Predicates.blocks('kubejs:enriched_naquadah_pipe_casing'))
			.where('G', Predicates.blocks('start_core:enriched_naquadah_engine_intake_casing'))
			.where('H', Predicates.blocks('kubejs:enriched_naquadah_machine_casing'))
			.where('I', Predicates.blocks('start_core:enriched_naquadah_firebox_casing'))
			.where('@', Predicates.controller(Predicates.blocks(definition.get())))
			.build())
		.workableCasingRenderer('kubejs:block/casings/ultimate_multis/extreme_temperature_smelting_casing',
            'gtceu:block/multiblock/gcym/blast_alloy_smelter', false);

});