GTCEuStartupEvents.registry('gtceu:machine', event => {
    event.create('large_me_assembler', 'multiblock')
        .rotationState(RotationState.NON_Y_AXIS)
        .recipeType('me_assembler')
        .recipeModifiers([GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.OC_NON_PERFECT_SUBTICK])
		.appearanceBlock(() => Block.getBlock('kubejs:fluix_steel_casing'))
		.pattern(definition => FactoryBlockPattern.start()
			.aisle("AAFFFFFAA", "ACCCCCCCA", "AAFFFFFAA") 
			.aisle("AEEEEEEEA", "FDDDDDDDF", "AAAABAAAA") 
			.aisle("AFFAEAFFA", "ACCCDCCCA", "AFFABAFFA") 
			.aisle("   A@A   ", "   CCC   ", "   AAA   ")
			.where("@", Predicates.controller(Predicates.blocks(definition.get())))
			.where("A", Predicates.blocks("kubejs:fluix_steel_casing")
				.or(Predicates.abilities(PartAbility.IMPORT_ITEMS).setMaxGlobalLimited(2))
				.or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMaxGlobalLimited(2))
				.or(Predicates.abilities(PartAbility.EXPORT_ITEMS).setMaxGlobalLimited(2))
				.or(Predicates.abilities(PartAbility.PARALLEL_HATCH).setMaxGlobalLimited(1))
				.or(Predicates.abilities(PartAbility.MAINTENANCE).setExactLimit(1))
				.or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMaxGlobalLimited(2)))
			.where("B", Predicates.blocks("gtceu:assembly_line_grating"))
			.where("C", Predicates.blocks("ae2:quartz_glass"))
			.where("D", Predicates.blocks("gtceu:high_power_casing"))
			.where("E", Predicates.blocks("gtceu:tungstensteel_pipe_casing"))
			.where("F", Predicates.blocks("gtceu:computer_heat_vent"))
			.where(" ", Predicates.any())
			.build())
			.workableCasingRenderer('kubejs:block/casings/fluix_casing',
			'gtceu:block/machines/circuit_assembler', false);
});