/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import tfar.classicbar.compat.ModCompat;
import tfar.classicbar.network.Message;
import tfar.classicbar.network.MessageExhaustionSync;
import tfar.classicbar.network.MessageHydrationSync;
import tfar.classicbar.network.MessageSaturationSync;
import tfar.classicbar.network.MessageThirstExhaustionSync;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;

public final class SyncHandler {
    private static SyncHandler INSTANCE;
    private final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();
    private final Map<UUID, Float> lastHydrationLevels = new HashMap<UUID, Float>();
    private final Map<UUID, Float> lastThirstExhaustionLevels = new HashMap<UUID, Float>();

    public static SyncHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new SyncHandler();
        }
        return INSTANCE;
    }

    private SyncHandler() {
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.END || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        this.syncVanillaData(player2);
        if (ModCompat.toughasnails.loaded) {
            this.syncToughAsNailsData(player2);
        }
    }

    private void syncVanillaData(ServerPlayer player) {
        UUID uuid = player.m_20148_();
        Float lastSaturationLevel = this.lastSaturationLevels.get(uuid);
        Float lastExhaustionLevel = this.lastExhaustionLevels.get(uuid);
        float saturationLevel = player.m_36324_().m_38722_();
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != saturationLevel) {
            MessageSaturationSync msg = new MessageSaturationSync(saturationLevel);
            Message.channel().sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            this.lastSaturationLevels.put(uuid, Float.valueOf(saturationLevel));
        }
        float exhaustionLevel = player.m_36324_().m_150380_();
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            MessageExhaustionSync msg = new MessageExhaustionSync(exhaustionLevel);
            Message.channel().sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            this.lastExhaustionLevels.put(uuid, Float.valueOf(exhaustionLevel));
        }
    }

    private void syncToughAsNailsData(ServerPlayer player) {
        if (!ThirstHelper.isThirstEnabled()) {
            return;
        }
        UUID uuid = player.m_20148_();
        Float lastHydrationLevel = this.lastHydrationLevels.get(uuid);
        Float lastExhaustionLevel = this.lastThirstExhaustionLevels.get(uuid);
        IThirst thirstData = ThirstHelper.getThirst((Player)player);
        float hydrationLevel = thirstData.getHydration();
        if (lastHydrationLevel == null || lastHydrationLevel.floatValue() != hydrationLevel) {
            MessageHydrationSync msg = new MessageHydrationSync(hydrationLevel);
            Message.channel().sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            this.lastHydrationLevels.put(uuid, Float.valueOf(hydrationLevel));
        }
        float exhaustionLevel = thirstData.getExhaustion();
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            MessageThirstExhaustionSync msg = new MessageThirstExhaustionSync(exhaustionLevel);
            Message.channel().sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            this.lastThirstExhaustionLevels.put(uuid, Float.valueOf(exhaustionLevel));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        Connection conn = event.getConnection();
        Message.presentOnServer = Message.channel().isRemotePresent(conn);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        UUID uuid = event.getEntity().m_20148_();
        this.lastSaturationLevels.remove(uuid);
        this.lastExhaustionLevels.remove(uuid);
        if (ModCompat.toughasnails.loaded) {
            this.lastHydrationLevels.remove(uuid);
            this.lastThirstExhaustionLevels.remove(uuid);
        }
    }
}

