/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import tfar.classicbar.compat.ModCompat;
import tfar.classicbar.network.NetworkHelper;
import toughasnails.api.thirst.ThirstHelper;

public class MessageHydrationSync {
    private final float hydrationLevel;

    public MessageHydrationSync(float hydrationLevel) {
        this.hydrationLevel = hydrationLevel;
    }

    public MessageHydrationSync(FriendlyByteBuf buf) {
        this.hydrationLevel = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.hydrationLevel);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ModCompat.toughasnails.loaded) {
            ctx.get().enqueueWork(() -> {
                Player player = NetworkHelper.getSidedPlayer((NetworkEvent.Context)ctx.get());
                ThirstHelper.getThirst((Player)player).setHydration(this.hydrationLevel);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

