/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.ColorUtils;
import tfar.classicbar.util.HealthEffect;
import tfar.classicbar.util.ModUtils;

public class MountHealth
extends BarOverlayImpl {
    private long healthUpdateCounter = 0L;
    private double mountHealth = 0.0;

    public MountHealth() {
        super("health_mount");
    }

    @Override
    public boolean shouldRender(Player player) {
        return player.m_20202_() instanceof LivingEntity;
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        boolean highlight;
        int updateCounter = gui.m_93079_();
        LivingEntity mount = (LivingEntity)player.m_20202_();
        if (!mount.m_6084_()) {
            return;
        }
        double mountHealth = mount.m_21223_();
        double barWidth = this.getBarWidth(player);
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (mountHealth < this.mountHealth && player.f_19802_ > 0) {
            this.healthUpdateCounter = updateCounter + 20;
        } else if (mountHealth > this.mountHealth && player.f_19802_ > 0) {
            this.healthUpdateCounter = updateCounter + 10;
        }
        this.mountHealth = mountHealth;
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        double maxHealth = mount.m_21233_();
        int i4 = highlight ? 18 : 0;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 0, i4, 81.0, 9);
        ColorUtils.calculateScaledColor(mountHealth, maxHealth, HealthEffect.NONE).color2Gl();
        double f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        this.renderPartialBar(graphics, f + 2.0, yStart + 2, barWidth);
    }

    @Override
    public double getBarWidth(Player player) {
        LivingEntity mount = (LivingEntity)player.m_20202_();
        double mounthHealth = mount.m_21223_();
        double maxHealth = mount.m_21233_();
        return (int)Math.ceil(77.0 * Math.min(maxHealth, mounthHealth) / mounthHealth);
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        LivingEntity mount = (LivingEntity)player.m_20202_();
        double maxHealth = mount.m_21233_();
        this.textHelper(graphics, xStart, yStart, this.mountHealth, ColorUtils.calculateScaledColor(this.mountHealth, maxHealth, HealthEffect.NONE).colorToText());
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 16, 0, 9.0, 9);
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 88, 9, 9.0, 9);
    }
}

