/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ModUtils;

public class ArmorToughness
extends BarOverlayImpl {
    public ArmorToughness() {
        super("armor_toughness");
    }

    @Override
    public boolean shouldRender(Player player) {
        return (Boolean)ClassicBarsConfig.displayToughnessBar.get() != false && player.m_21051_(Attributes.f_22285_).m_22135_() >= 1.0;
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        double armorToughness = player.m_21051_(Attributes.f_22285_).m_22135_();
        double barWidth = this.getBarWidth(player);
        int xStart = screenWidth / 2 + this.getHOffset();
        if (this.rightHandSide()) {
            xStart = (int)((double)xStart + (77.0 - barWidth));
        }
        int yStart = screenHeight - vOffset;
        int index = (int)Math.min(Math.ceil(armorToughness / 20.0), (double)ConfigCache.armor_toughness.size()) - 1;
        Color primary = this.getPrimaryBarColor(index, player);
        Color.reset();
        this.renderBarBackground(graphics, player, screenWidth, screenHeight, vOffset);
        if (index == 0) {
            primary.color2Gl();
            this.renderPartialBar(graphics, xStart + 2, yStart + 2, barWidth);
        } else {
            int size = ConfigCache.armor_toughness.size();
            if (index < size && armorToughness % 20.0 != 0.0) {
                Color secondary = this.getSecondaryBarColor(index - 1, player);
                secondary.color2Gl();
                this.renderFullBar(graphics, xStart + 2, yStart + 2);
                double w = ModUtils.getWidth(armorToughness % 20.0, 20.0);
                primary.color2Gl();
                double f = (double)xStart + (this.rightHandSide() ? 77.0 - w : 0.0);
                this.renderPartialBar(graphics, f + 2.0, yStart + 2, w);
            } else {
                primary.color2Gl();
                this.renderFullBar(graphics, xStart + 2, yStart + 2);
            }
        }
    }

    @Override
    public double getBarWidth(Player player) {
        double armorToughness = player.m_21051_(Attributes.f_22285_).m_22135_();
        return Math.ceil(77.0 * Math.min(20.0, armorToughness) / 20.0);
    }

    @Override
    public boolean isFitted() {
        return (Boolean)ClassicBarsConfig.fullToughnessBar.get() == false;
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        return ConfigCache.armor_toughness.get(index);
    }

    @Override
    public Color getSecondaryBarColor(int index, Player player) {
        return ConfigCache.armor_toughness.get(index);
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        double armorToughness = player.m_21051_(Attributes.f_22285_).m_22135_();
        int index = (int)Math.min(Math.ceil(armorToughness / 20.0) - 1.0, (double)(ConfigCache.armor_toughness.size() - 1));
        int c = this.getPrimaryBarColor(index, player).colorToText();
        this.textHelper(graphics, xStart, yStart, armorToughness, c);
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 83, 0, 9.0, 9);
    }
}

