/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ModUtils;

public class Armor
extends BarOverlayImpl {
    private static final EquipmentSlot[] armorList = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public Armor() {
        super("armor");
    }

    @Override
    public boolean shouldRender(Player player) {
        return Armor.calculateArmorValue(player) >= 1;
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        double armor = Armor.calculateArmorValue(player);
        double barWidth = this.getBarWidth(player);
        boolean warn = this.shouldFlash(player);
        float armorAlpha = warn ? (float)(System.currentTimeMillis() / 500L % 2L) : 1.0f;
        int xStart = screenWidth / 2 + this.getHOffset();
        if (this.rightHandSide()) {
            xStart = (int)((double)xStart + (77.0 - barWidth));
        }
        int yStart = screenHeight - vOffset;
        this.renderBarBackground(graphics, player, screenWidth, screenHeight, vOffset);
        int index = (int)Math.min(Math.ceil(armor / 20.0), (double)ConfigCache.armor.size()) - 1;
        Color primary = this.getPrimaryBarColor(index, player);
        if (index == 0) {
            primary.color2Gla(armorAlpha);
            this.renderPartialBar(graphics, xStart + 2, yStart + 2, barWidth);
        } else {
            if (armor % 20.0 != 0.0) {
                Color secondary = this.getSecondaryBarColor(index - 1, player);
                secondary.color2Gla(armorAlpha);
                this.renderFullBar(graphics, xStart + 2, yStart + 2);
                primary.color2Gl();
                double w = ModUtils.getWidth(armor % 20.0, 20.0);
                double f = (double)xStart + (this.rightHandSide() ? 77.0 - w : 0.0);
                this.renderPartialBar(graphics, f + 2.0, yStart + 2, w);
            } else {
                primary.color2Gla(armorAlpha);
                this.renderFullBar(graphics, xStart + 2, yStart + 2);
            }
            if (warn) {
                primary.color2Gla(armorAlpha);
                this.renderPartialBar(graphics, xStart + 2, yStart + 2, ModUtils.getWidth(armor - (double)(index * 20), 20.0));
            }
        }
    }

    @Override
    protected boolean shouldFlash(Player player) {
        return (Boolean)ClassicBarsConfig.lowArmorWarning.get() != false && Armor.getDamagedAmount(player) > 0;
    }

    @Override
    public double getBarWidth(Player player) {
        int armor = Armor.calculateArmorValue(player);
        return Math.ceil((double)(77 * Math.min(20, armor)) / 20.0);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        return ConfigCache.armor.get(index);
    }

    @Override
    public Color getSecondaryBarColor(int index, Player player) {
        return ConfigCache.armor.get(index);
    }

    @Override
    public boolean isFitted() {
        return (Boolean)ClassicBarsConfig.fullArmorBar.get() == false;
    }

    public static int getDamagedAmount(Player player) {
        int warningAmount = 0;
        for (EquipmentSlot slot : armorList) {
            ItemStack stack = player.m_6844_(slot);
            if (!(stack.m_41720_() instanceof ArmorItem)) continue;
            int max = stack.m_41776_();
            int current = stack.m_41773_();
            int percentage = 100;
            if (max != 0) {
                percentage = 100 * (max - current) / max;
            }
            if (percentage >= 5) continue;
            warningAmount += ((ArmorItem)stack.m_41720_()).m_40404_();
        }
        return warningAmount;
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        double armor = Armor.calculateArmorValue(player);
        int index = (int)Math.min(Math.ceil(armor / 20.0), (double)ConfigCache.armor.size()) - 1;
        int c = this.getPrimaryBarColor(index, player).colorToText();
        this.textHelper(graphics, xStart, yStart, armor, c);
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 43, 9, 9.0, 9);
    }

    private static int calculateArmorValue(Player player) {
        return player.m_21230_();
    }
}

