/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ModUtils;

public class Air
extends BarOverlayImpl {
    public Air() {
        super("air");
    }

    @Override
    public boolean shouldRender(Player player) {
        return player.m_20146_() < player.m_6062_();
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        double barWidth = this.getBarWidth(player);
        Color.reset();
        this.renderFullBarBackground(graphics, xStart, yStart);
        double f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        Color color = this.getPrimaryBarColor(0, player);
        color.color2Gl();
        this.renderPartialBar(graphics, f + 2.0, yStart + 2, barWidth);
    }

    @Override
    public double getBarWidth(Player player) {
        int air = player.m_20146_();
        int maxAir = player.m_6062_();
        return Math.ceil(77.0 * (double)air / (double)maxAir);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        return ConfigCache.air;
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int air = player.m_20146_();
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        Color color = this.getPrimaryBarColor(0, player);
        this.textHelper(graphics, xStart, yStart, air / 20, color.colorToText());
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 16, 18, 9.0, 9);
    }
}

