/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.mod;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.network.Message;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ModUtils;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ThirstConfig;
import toughasnails.init.ModTags;

public class Thirst
extends BarOverlayImpl {
    public static final String NAME = "thirst_level";
    public static final ResourceLocation OVERLAY_ID = new ResourceLocation("toughasnails", "thirst_level");
    public static final double MAX_THIRST_LEVEL = 20.0;
    public static final double MAX_HYDRATION_LEVEL = 1.0;

    public static int getPotentialThirstLevel(ItemStack drink) {
        if (drink.m_204117_(ModTags.Items.ONE_THIRST_DRINKS)) {
            return 1;
        }
        if (drink.m_204117_(ModTags.Items.TWO_THIRST_DRINKS)) {
            return 2;
        }
        if (drink.m_204117_(ModTags.Items.THREE_THIRST_DRINKS)) {
            return 3;
        }
        if (drink.m_204117_(ModTags.Items.FOUR_THIRST_DRINKS)) {
            return 4;
        }
        if (drink.m_204117_(ModTags.Items.FIVE_THIRST_DRINKS)) {
            return 5;
        }
        if (drink.m_204117_(ModTags.Items.SIX_THIRST_DRINKS)) {
            return 6;
        }
        if (drink.m_204117_(ModTags.Items.SEVEN_THIRST_DRINKS)) {
            return 7;
        }
        if (drink.m_204117_(ModTags.Items.EIGHT_THIRST_DRINKS)) {
            return 8;
        }
        if (drink.m_204117_(ModTags.Items.NINE_THIRST_DRINKS)) {
            return 9;
        }
        if (drink.m_204117_(ModTags.Items.TEN_THIRST_DRINKS)) {
            return 10;
        }
        if (drink.m_204117_(ModTags.Items.ELEVEN_THIRST_DRINKS)) {
            return 11;
        }
        if (drink.m_204117_(ModTags.Items.TWELVE_THIRST_DRINKS)) {
            return 12;
        }
        if (drink.m_204117_(ModTags.Items.THIRTEEN_THIRST_DRINKS)) {
            return 13;
        }
        if (drink.m_204117_(ModTags.Items.FOURTEEN_THIRST_DRINKS)) {
            return 14;
        }
        if (drink.m_204117_(ModTags.Items.FIFTEEN_THIRST_DRINKS)) {
            return 15;
        }
        if (drink.m_204117_(ModTags.Items.SIXTEEN_THIRST_DRINKS)) {
            return 16;
        }
        if (drink.m_204117_(ModTags.Items.SEVENTEEN_THIRST_DRINKS)) {
            return 17;
        }
        if (drink.m_204117_(ModTags.Items.EIGHTEEN_THIRST_DRINKS)) {
            return 18;
        }
        if (drink.m_204117_(ModTags.Items.NINETEEN_THIRST_DRINKS)) {
            return 19;
        }
        if (drink.m_204117_(ModTags.Items.TWENTY_THIRST_DRINKS)) {
            return 20;
        }
        return 0;
    }

    public static float getPotentialHydrationLevel(ItemStack drink) {
        if (drink.m_204117_(ModTags.Items.TEN_HYDRATION_DRINKS)) {
            return 0.1f;
        }
        if (drink.m_204117_(ModTags.Items.TWENTY_HYDRATION_DRINKS)) {
            return 0.2f;
        }
        if (drink.m_204117_(ModTags.Items.THIRTY_HYDRATION_DRINKS)) {
            return 0.3f;
        }
        if (drink.m_204117_(ModTags.Items.FOURTY_HYDRATION_DRINKS)) {
            return 0.4f;
        }
        if (drink.m_204117_(ModTags.Items.FIFTY_HYDRATION_DRINKS)) {
            return 0.5f;
        }
        if (drink.m_204117_(ModTags.Items.SIXTY_HYDRATION_DRINKS)) {
            return 0.6f;
        }
        if (drink.m_204117_(ModTags.Items.SEVENTY_HYDRATION_DRINKS)) {
            return 0.7f;
        }
        if (drink.m_204117_(ModTags.Items.EIGHTY_HYDRATION_DRINKS)) {
            return 0.8f;
        }
        if (drink.m_204117_(ModTags.Items.NINETY_HYDRATION_DRINKS)) {
            return 0.9f;
        }
        if (drink.m_204117_(ModTags.Items.ONE_HUNDRED_HYDRATION_DRINKS)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float getPotentialPotionChance(ItemStack drink) {
        if (drink.m_204117_(ModTags.Items.TWENTY_FIVE_POISON_CHANCE_DRINKS)) {
            return 0.25f;
        }
        if (drink.m_204117_(ModTags.Items.FIFTY_POISON_CHANCE_DRINKS)) {
            return 0.5f;
        }
        if (drink.m_204117_(ModTags.Items.SEVENTY_FIVE_POISON_CHANCE_DRINKS)) {
            return 0.75f;
        }
        if (drink.m_204117_(ModTags.Items.ONE_HUNDRED_POISON_CHANCE_DRINKS)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public Thirst() {
        super(NAME);
    }

    @Override
    public boolean shouldRender(Player player) {
        return Thirst.isEnabled();
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        Double maxExhaustionLevel = (Double)ThirstConfig.thirstExhaustionThreshold.get();
        IThirst thirstData = ThirstHelper.getThirst((Player)player);
        int thirstLevel = thirstData.getThirst();
        double hydrationLevel = Math.min((double)thirstData.getHydration(), 1.0);
        double exhaustionLevel = Math.min((double)thirstData.getExhaustion(), maxExhaustionLevel);
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        Color.reset();
        this.renderFullBarBackground(graphics, xStart, yStart);
        this.drawThirst(graphics, player, xStart, yStart, thirstLevel, 20.0);
        if (hydrationLevel > 0.0 && ((Boolean)ClassicBarsConfig.showHydrationBar.get()).booleanValue()) {
            this.drawHydration(graphics, player, xStart, yStart, hydrationLevel, 1.0);
        }
        if (((Boolean)ClassicBarsConfig.showHeldDrinkOverlay.get()).booleanValue() && ThirstHelper.canDrink((Player)player, (boolean)true)) {
            this.drawHeldDrink(graphics, player, thirstData, xStart, yStart, 20.0, 1.0);
        }
        if (((Boolean)ClassicBarsConfig.showThirstExhaustionOverlay.get()).booleanValue() && Message.presentOnServer) {
            this.drawExhaustion(graphics, player, xStart, yStart, exhaustionLevel, maxExhaustionLevel);
        }
    }

    private void drawThirst(GuiGraphics stack, Player player, int x, int y, double thirstLevel, double maxLevel) {
        this.getSecondaryBarColor(0, player).color2Gl();
        double barWidth = ModUtils.getWidth(thirstLevel, maxLevel);
        double barXStart = (double)x + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        this.renderPartialBar(stack, barXStart + 2.0, y + 2, barWidth);
    }

    private void drawHydration(GuiGraphics stack, Player player, int x, int y, double hydrationLevel, double maxLevel) {
        this.getPrimaryBarColor(0, player).color2Gl();
        double barWidth = ModUtils.getWidth(hydrationLevel, maxLevel);
        double barXStart = (double)x + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        this.renderPartialBar(stack, barXStart + 2.0, y + 2, barWidth);
    }

    private void drawHeldDrink(GuiGraphics stack, Player player, IThirst thirstData, int x, int y, double maxThirstLevel, double maxHydrationLevel) {
        ItemStack drink = player.m_21205_();
        if (!drink.m_204117_(ModTags.Items.DRINKS)) {
            return;
        }
        double time = (double)System.currentTimeMillis() / 1000.0 * (Double)ClassicBarsConfig.transitionSpeed.get();
        double drinkAlpha = Math.sin(time) / 2.0 + 0.5;
        int thirstLevel = thirstData.getThirst();
        int potentialThirstLevel = Thirst.getPotentialThirstLevel(drink);
        double restoredThirstLevel = Math.min(maxThirstLevel - (double)thirstLevel, (double)potentialThirstLevel);
        if ((double)thirstLevel < maxThirstLevel) {
            double barWidth = ModUtils.getWidth((double)thirstLevel + restoredThirstLevel, maxThirstLevel);
            double barXStart = (double)x + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
            this.getSecondaryBarColor(0, player).color2Gla((float)drinkAlpha);
            this.renderPartialBar(stack, barXStart + 2.0, y + 2, barWidth);
        }
        if (((Boolean)ClassicBarsConfig.showHydrationBar.get()).booleanValue()) {
            float hydrationLevel = thirstData.getHydration();
            float potentialHydrationLevel = Thirst.getPotentialHydrationLevel(drink);
            double restoredHydrationLevel = Math.min(maxHydrationLevel - (double)hydrationLevel, (double)potentialHydrationLevel);
            restoredHydrationLevel = Math.min(restoredHydrationLevel, (double)(thirstLevel + potentialThirstLevel));
            restoredHydrationLevel = Math.min(restoredHydrationLevel, (double)thirstLevel + restoredThirstLevel);
            if ((double)(hydrationLevel + potentialHydrationLevel) > (double)thirstLevel + restoredThirstLevel) {
                double diff = (double)(hydrationLevel + potentialHydrationLevel) - ((double)thirstLevel + restoredThirstLevel);
                restoredHydrationLevel = (double)potentialHydrationLevel - diff;
            }
            double barWidth = ModUtils.getWidth((double)hydrationLevel + restoredHydrationLevel, maxHydrationLevel);
            double barXStart = (double)x + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
            this.getPrimaryBarColor(0, player).color2Gla((float)drinkAlpha);
            this.renderPartialBar(stack, barXStart + 2.0, y + 2, barWidth);
        }
    }

    private void drawExhaustion(GuiGraphics stack, Player player, int x, int y, double exhaustionLevel, double maxLevel) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        double barWidth = ModUtils.getWidth(exhaustionLevel, maxLevel);
        double barXStart = (double)x + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        ModUtils.drawTexturedModalRect(stack, barXStart + 2.0, y + 1, 1, 28, barWidth, 9);
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        IThirst thirstData = ThirstHelper.getThirst((Player)player);
        int thirst = thirstData.getThirst();
        int c = this.getSecondaryBarColor(0, player).colorToText();
        this.textHelper(graphics, xStart, yStart, thirst, c);
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        int texX = 36;
        int texBgX = 0;
        if (player.m_21023_((MobEffect)TANEffects.THIRST.get())) {
            texBgX = (texX += 36) + 45;
        }
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, texBgX, 32, 9.0, 9);
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, texX, 32, 9.0, 9);
    }

    @Override
    public double getBarWidth(Player player) {
        IThirst thirstData = ThirstHelper.getThirst((Player)player);
        int thirst = thirstData.getThirst();
        return Math.ceil((double)(77 * thirst) / 20.0);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        if (player.m_21023_((MobEffect)TANEffects.THIRST.get())) {
            return ConfigCache.hydrationDebuff;
        }
        return ConfigCache.hydration;
    }

    @Override
    public Color getSecondaryBarColor(int index, Player player) {
        if (player.m_21023_((MobEffect)TANEffects.THIRST.get())) {
            return ConfigCache.thirstDebuff;
        }
        return ConfigCache.thirst;
    }

    public static boolean isEnabled() {
        return ThirstHelper.isThirstEnabled();
    }
}

