/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.mod;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ModUtils;

public class Blood
extends BarOverlayImpl {
    public Blood() {
        super("blood");
    }

    @Override
    public boolean shouldRender(Player player) {
        return VampirismAPI.factionRegistry().getFaction((Entity)player) == VReference.VAMPIRE_FACTION;
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        return Color.RED;
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(IVampirePlayer::getBloodStats).ifPresent(stats -> {
            double barWidth = this.getBarWidth(player);
            int xStart = screenWidth / 2 + this.getHOffset();
            int yStart = screenHeight - vOffset;
            Color.reset();
            this.renderFullBarBackground(graphics, xStart, yStart);
            double f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
            this.getPrimaryBarColor(0, player).color2Gl();
            this.renderPartialBar(graphics, f + 2.0, yStart + 2, barWidth);
        });
    }

    @Override
    public double getBarWidth(Player player) {
        IBloodStats stats = VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(IVampirePlayer::getBloodStats).orElse(null);
        if (stats != null) {
            int blood = stats.getBloodLevel();
            int maxBlood = stats.getMaxBlood();
            return Math.ceil(77.0 * (double)blood / (double)maxBlood);
        }
        return 0.0;
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        VReference.VAMPIRE_FACTION.getPlayerCapability(player).map(IVampirePlayer::getBloodStats).ifPresent(stats -> {
            int blood = stats.getBloodLevel();
            int c = this.getPrimaryBarColor(0, player).colorToText();
            int xStart = width / 2 + this.getIconOffset();
            int yStart = height - vOffset;
            this.textHelper(graphics, xStart, yStart, blood, c);
        });
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 0, 0, 9.0, 9);
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 9, 0, 9.0, 9);
    }
}

