/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.EventHandler;
import tfar.classicbar.api.BarOverlay;
import tfar.classicbar.api.BarSettings;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.HealthEffect;
import tfar.classicbar.util.ModUtils;

public abstract class BarOverlayImpl
implements BarOverlay {
    public static final int WIDTH = 77;
    public static final int HEIGHT = 5;
    public static final int BAR_U = 2;
    public static final int BAR_V = 11;
    public static final ResourceLocation ICON_BAR = new ResourceLocation("classicbar", "textures/gui/health.png");
    public static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    protected String name;
    protected boolean side;
    protected BarSettings barSettings;

    public BarOverlayImpl(String name) {
        this.name = name;
    }

    public boolean shouldRender(Player player) {
        return true;
    }

    @Override
    public void setBarSettings(BarSettings barSettings) {
        this.barSettings = barSettings;
    }

    @Override
    public final boolean rightHandSide() {
        return this.side;
    }

    @Override
    public final BarOverlay setSide(boolean right) {
        this.side = right;
        return this;
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        if (this.shouldRender(player)) {
            gui.setupOverlayRenderState(true, false);
            this.bindBarTexture();
            this.renderBar(gui, graphics, player, screenWidth, screenHeight, vOffset);
            if (this.shouldRenderText()) {
                this.renderText(graphics, player, screenWidth, screenHeight, vOffset);
            }
            if (ConfigCache.icons) {
                this.bindIconTexture();
                this.renderIcon(graphics, player, screenWidth, screenHeight, vOffset);
            }
            EventHandler.increment(gui, this.rightHandSide(), 10);
        }
    }

    public abstract void renderBar(ForgeGui var1, GuiGraphics var2, Player var3, int var4, int var5, int var6);

    protected boolean shouldFlash(Player player) {
        return false;
    }

    public final boolean shouldRenderText() {
        return this.barSettings.show_text;
    }

    public abstract void renderText(GuiGraphics var1, Player var2, int var3, int var4, int var5);

    public abstract void renderIcon(GuiGraphics var1, Player var2, int var3, int var4, int var5);

    public int getHOffset() {
        return this.rightHandSide() ? 10 : -91;
    }

    public int getIconOffset() {
        return this.rightHandSide() ? 92 : -101;
    }

    protected HealthEffect getHealthEffect(Player player) {
        HealthEffect effects = HealthEffect.NONE;
        if (player.m_21023_(MobEffects.f_19614_)) {
            effects = HealthEffect.POISON;
        } else if (player.m_21023_(MobEffects.f_19615_)) {
            effects = HealthEffect.WITHER;
        } else if (player.m_146890_()) {
            effects = HealthEffect.FROZEN;
        }
        return effects;
    }

    public void renderBarBackground(GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        double barWidth = this.getBarWidth(player);
        int xStart = screenWidth / 2 + this.getHOffset();
        if (this.isFitted() && this.rightHandSide()) {
            xStart = (int)((double)xStart + (77.0 - barWidth));
        }
        int yStart = screenHeight - vOffset;
        if (this.isFitted()) {
            this.drawScaledBarBackground(graphics, barWidth, xStart, yStart + 1);
        } else {
            this.renderFullBarBackground(graphics, xStart, yStart);
        }
    }

    public void drawScaledBarBackground(GuiGraphics stack, double barWidth, int x, int y) {
        if (this.rightHandSide()) {
            ModUtils.drawTexturedModalRect(stack, x, y - 1, 0, 0, barWidth + 2.0, 9);
            ModUtils.drawTexturedModalRect(stack, (double)x + barWidth + 2.0, y - 1, 79, 0, 2.0, 9);
        } else {
            ModUtils.drawTexturedModalRect(stack, x, y - 1, 0, 0, (int)(barWidth + 2.0), 9);
            ModUtils.drawTexturedModalRect(stack, (int)((double)x + barWidth + 2.0), y - 1, 79, 0, 2.0, 9);
        }
    }

    public void textHelper(GuiGraphics graphics, int xStart, int yStart, double stat, int color) {
        int i2;
        int i1 = (int)Math.floor(stat);
        int n = i2 = ConfigCache.icons ? 1 : 0;
        if (this.rightHandSide()) {
            ModUtils.drawStringOnHUD(graphics, "" + i1, xStart + 9 * i2, yStart - 1, color);
        } else {
            int i3 = ModUtils.getStringLength("" + i1);
            ModUtils.drawStringOnHUD(graphics, "" + i1, xStart - 9 * i2 - i3 + 5, yStart - 1, color);
        }
    }

    public void renderFullBarBackground(GuiGraphics matrices, int xStart, int yStart) {
        ModUtils.drawTexturedModalRect(matrices, xStart, yStart, 0, 0, 81.0, 9);
    }

    public void renderFullBar(GuiGraphics matrices, int xStart, int yStart) {
        this.renderPartialBar(matrices, xStart, yStart, 77.0);
    }

    public void renderPartialBar(GuiGraphics matrices, double xStart, int yStart, double barWidth) {
        ModUtils.drawTexturedModalRect(matrices, xStart, yStart, 2, 11, barWidth, 5);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        return Color.BLACK;
    }

    @Override
    public Color getSecondaryBarColor(int index, Player player) {
        return Color.BLACK;
    }

    @Override
    public final ResourceLocation getIconRL() {
        return this.barSettings.icon;
    }

    @Override
    public boolean isFitted() {
        return false;
    }

    @Override
    public final String name() {
        return this.name;
    }
}

