/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.io.IOUtils;
import tfar.classicbar.ClassicBar;
import tfar.classicbar.EventHandler;
import tfar.classicbar.api.BarOverlay;
import tfar.classicbar.api.BarSettings;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.ModUtils;

@Mod.EventBusSubscriber(modid="classicbar", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClassicBarsConfig {
    static ForgeConfigSpec.BooleanValue displayIcons;
    public static ForgeConfigSpec.BooleanValue displayToughnessBar;
    public static ForgeConfigSpec.BooleanValue fullAbsorptionBar;
    public static ForgeConfigSpec.BooleanValue fullArmorBar;
    public static ForgeConfigSpec.BooleanValue fullToughnessBar;
    public static ForgeConfigSpec.BooleanValue lowArmorWarning;
    public static ForgeConfigSpec.BooleanValue showSaturationBar;
    public static ForgeConfigSpec.BooleanValue showHydrationBar;
    public static ForgeConfigSpec.BooleanValue showHeldFoodOverlay;
    public static ForgeConfigSpec.BooleanValue showHeldDrinkOverlay;
    public static ForgeConfigSpec.BooleanValue showExhaustionOverlay;
    public static ForgeConfigSpec.BooleanValue showThirstExhaustionOverlay;
    public static ForgeConfigSpec.DoubleValue transitionSpeed;
    static ForgeConfigSpec.ConfigValue<String> hungerBarColor;
    static ForgeConfigSpec.ConfigValue<String> hungerBarDebuffColor;
    static ForgeConfigSpec.ConfigValue<String> saturationBarColor;
    static ForgeConfigSpec.ConfigValue<String> saturationBarDebuffColor;
    static ForgeConfigSpec.ConfigValue<String> thirstBarColor;
    static ForgeConfigSpec.ConfigValue<String> thirstBarDebuffColor;
    static ForgeConfigSpec.ConfigValue<String> hydrationBarColor;
    static ForgeConfigSpec.ConfigValue<String> hydrationBarDebuffColor;
    static ForgeConfigSpec.ConfigValue<String> airBarColor;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> armorColors;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> armorToughnessColors;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> absorptionColors;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> absorptionPoisonColors;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> absorptionWitherColors;
    public static ForgeConfigSpec.ConfigValue<List<? extends Double>> normalFractions;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> normalColors;
    public static ForgeConfigSpec.ConfigValue<List<? extends Double>> poisonedFractions;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> poisonedColors;
    public static ForgeConfigSpec.ConfigValue<List<? extends Double>> witheredFractions;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> witheredColors;
    public static ForgeConfigSpec.ConfigValue<String> frozenHealthColor;
    public static ForgeConfigSpec.ConfigValue<String> lavaBarColor;
    public static ForgeConfigSpec.ConfigValue<String> flightBarColor;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> leftorder;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> rightorder;
    static File settingsPath;
    private static final BarSettings nullSettings;
    private static final Map<String, BarSettings> defaults;

    public ClassicBarsConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        displayIcons = builder.define("display_icons", true);
        displayToughnessBar = builder.comment("Whether to show icons next to the bars").define("display_icons", true);
        fullAbsorptionBar = builder.define("full_absorption_bar", false);
        fullArmorBar = builder.define("full_armor_bar", false);
        fullToughnessBar = builder.define("full_toughness_bar", false);
        lowArmorWarning = builder.define("display_low_armor_warning", true);
        showSaturationBar = builder.define("show_saturation_bar", true);
        showHydrationBar = builder.define("show_hydration_bar", true);
        showHeldFoodOverlay = builder.define("show_held_food_overlay", true);
        showHeldDrinkOverlay = builder.define("show_held_drink_overlay", true);
        showExhaustionOverlay = builder.define("show_exhaustion_overlay", true);
        showThirstExhaustionOverlay = builder.define("show_thirst_exhaustion_overlay", true);
        transitionSpeed = builder.defineInRange("transition_speed", 3.0, 0.0, Double.MAX_VALUE);
        hungerBarColor = builder.define("hunger_bar_color", (Object)"#B34D00", String.class::isInstance);
        hungerBarDebuffColor = builder.define("hunger_bar_debuff_color", (Object)"#249016", String.class::isInstance);
        thirstBarColor = builder.define("thirstr_bar_color", (Object)"#1C5EE4", String.class::isInstance);
        thirstBarDebuffColor = builder.define("thirst_bar_debuff_color", (Object)"#5A891C", String.class::isInstance);
        airBarColor = builder.define("air_bar_color", (Object)"#00E6E6", String.class::isInstance);
        saturationBarColor = builder.define("saturation_bar_color", (Object)"#FFCC00", String.class::isInstance);
        saturationBarDebuffColor = builder.define("saturation_bar_debuff_color", (Object)"#87BC00", String.class::isInstance);
        hydrationBarColor = builder.define("hydration_bar_color", (Object)"#00A3E2", String.class::isInstance);
        hydrationBarDebuffColor = builder.define("hydration_bar_debuff_color", (Object)"#85CF25", String.class::isInstance);
        lavaBarColor = builder.define("lava_bar_color", (Object)"#FF8000", String.class::isInstance);
        flightBarColor = builder.define("flight_bar_color", (Object)"#FFFFFF", String.class::isInstance);
        armorColors = builder.defineList("armor_color_values", (List)Lists.newArrayList((Object[])new String[]{"#AAAAAA", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"}), String.class::isInstance);
        armorToughnessColors = builder.defineList("armor_toughness_color_values", (List)Lists.newArrayList((Object[])new String[]{"#AAAAAA", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"}), String.class::isInstance);
        absorptionColors = builder.defineList("absorption_color_values", (List)Lists.newArrayList((Object[])new String[]{"#D4AF37", "#C2C73B", "#8DC337", "#36BA77", "#4A5BC4", "#D89AE2", "#DF9DC7", "#DFA99D", "#D4DF9D", "#3E84C6", "#B8C1E8", "#DFDFDF"}), String.class::isInstance);
        absorptionPoisonColors = builder.defineList("absorption_poison_color_values", (List)Lists.newArrayList((Object[])new String[]{"#D4AF37", "#C2C73B", "#8DC337", "#36BA77", "#4A5BC4", "#D89AE2", "#DF9DC7", "#DFA99D", "#D4DF9D", "#3E84C6", "#B8C1E8", "#DFDFDF"}), String.class::isInstance);
        absorptionWitherColors = builder.defineList("absorption_wither_color_values", (List)Lists.newArrayList((Object[])new String[]{"#D4AF37", "#C2C73B", "#8DC337", "#36BA77", "#4A5BC4", "#D89AE2", "#DF9DC7", "#DFA99D", "#D4DF9D", "#3E84C6", "#B8C1E8", "#DFDFDF"}), String.class::isInstance);
        normalColors = builder.defineList("normal_colors", (List)Lists.newArrayList((Object[])new String[]{"#FF0000", "#FFFF00", "#00FF00"}), String.class::isInstance);
        normalFractions = builder.defineList("normal_fractions", (List)Lists.newArrayList((Object[])new Double[]{0.25, 0.5, 0.75}), Double.class::isInstance);
        poisonedColors = builder.defineList("poisoned_colors", (List)Lists.newArrayList((Object[])new String[]{"#00FF00", "#55FF55", "#00FF00"}), String.class::isInstance);
        poisonedFractions = builder.defineList("poisoned_fractions", (List)Lists.newArrayList((Object[])new Double[]{0.25, 0.5, 0.75}), Double.class::isInstance);
        witheredColors = builder.defineList("withered_colors", (List)Lists.newArrayList((Object[])new String[]{"#555555", "#AAAAAA", "#555555"}), String.class::isInstance);
        witheredFractions = builder.defineList("withered_fractions", (List)Lists.newArrayList((Object[])new Double[]{0.25, 0.5, 0.75}), Double.class::isInstance);
        frozenHealthColor = builder.define("frozen_health_color", (Object)"#7fafff");
        leftorder = builder.defineList("left_order", (List)Lists.newArrayList((Object[])new String[]{"health", "armor", "absorption", "lavacharm", "lavacharm2"}), String.class::isInstance);
        rightorder = builder.defineList("right_order", (List)Lists.newArrayList((Object[])new String[]{"blood", "health_mount", "food", "thirst_level", "parcool:stamina", "feathers", "armor_toughness", "air", "flighttiara", "decay"}), String.class::isInstance);
    }

    @SubscribeEvent
    public static void onConfigChanged(ModConfigEvent event) {
        EventHandler.cacheConfigs();
        ClassicBarsConfig.readBarSettings();
        ClassicBar.logger.info("Syncing Classic Bar Configs");
    }

    public static void readBarSettings() {
        File[] files;
        if (!settingsPath.exists()) {
            settingsPath.mkdir();
            ClassicBarsConfig.writeDefault();
        }
        for (File file : files = settingsPath.listFiles()) {
            FileReader reader = null;
            try {
                reader = new FileReader(file);
                JsonReader jsonReader = new JsonReader((Reader)reader);
                Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
                BarSettings barSettings = (BarSettings)gson.fromJson(jsonReader, BarSettings.class);
                String fileName = file.getName();
                String name = fileName.substring(0, fileName.length() - ".json".length());
                BarOverlay barOverlay = EventHandler.registry.get(name);
                barOverlay.setBarSettings(barSettings);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static void writeDefault() {
        Gson gson = new Gson();
        ClassicBarsConfig.makeDefaultBarSettings();
        for (BarOverlay barOverlay : EventHandler.registry.values()) {
            File file = new File("config/classicbar/" + barOverlay.name() + ".json");
            JsonWriter writer = null;
            try {
                writer = gson.newJsonWriter((Writer)new FileWriter(file));
                writer.setIndent("    ");
                BarSettings barSettings = defaults.getOrDefault(barOverlay.name(), nullSettings);
                gson.toJson((JsonElement)barSettings.toJson(), writer);
            }
            catch (Exception e) {
                try {
                    ClassicBar.logger.error("Couldn't save config");
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)writer);
        }
    }

    static void makeDefaultBarSettings() {
        ClassicBarsConfig.nullSettings.show_text = true;
        ClassicBarsConfig.nullSettings.icon = BarOverlayImpl.GUI_ICONS_LOCATION;
        BarSettings absorbSettings = nullSettings.copy();
        defaults.put("absorption", absorbSettings);
        BarSettings airSettings = nullSettings.copy();
        defaults.put("air", airSettings);
        BarSettings armorSettings = nullSettings.copy();
        defaults.put("armor", armorSettings);
        BarSettings armorToughnessSettings = nullSettings.copy();
        armorToughnessSettings.icon = BarOverlayImpl.ICON_BAR;
        defaults.put("armor_toughness", armorToughnessSettings);
        BarSettings bloodSettings = nullSettings.copy();
        bloodSettings.icon = ModUtils.VAMPIRISM_ICONS;
        defaults.put("blood", bloodSettings);
        BarSettings foodSettings = nullSettings.copy();
        defaults.put("food", foodSettings);
        BarSettings healthSettings = nullSettings.copy();
        defaults.put("health", healthSettings);
        BarSettings healthMountSettings = nullSettings.copy();
        defaults.put("health_mount", healthMountSettings);
    }

    static {
        settingsPath = new File("config/classicbar/");
        nullSettings = new BarSettings();
        defaults = new HashMap<String, BarSettings>();
    }
}

