/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.tiles;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.focamacho.mysticaladaptations.container.InsaniumReprocessorContainer;
import com.focamacho.mysticaladaptations.init.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InsaniumReprocessorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    private final BaseItemStackHandler inventory;
    private final BaseEnergyStorage energy;
    private final LazyOptional<IItemHandlerModifiable>[] inventoryCapabilities;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private ReprocessorRecipe recipe;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private static final int fuelUsage = 11520;
    private static final int fuelCapacity = 2560000;

    public InsaniumReprocessorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INSANIUM_REPROCESSOR.get(), pos, state);
        this.inventory = InsaniumReprocessorTileEntity.createInventoryHandler(null);
        this.energy = new BaseEnergyStorage(2560000, () -> ((InsaniumReprocessorTileEntity)this).setChangedAndDispatch());
        this.inventoryCapabilities = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128365_("Energy", this.energy.serializeNBT());
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.reprocessor").build();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return InsaniumReprocessorContainer.create(id, playerInventory, arg_0 -> ((InsaniumReprocessorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, this.m_58899_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_()) {
            if (cap == ForgeCapabilities.ENERGY) {
                return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
            }
            if (side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
                if (side == Direction.UP) {
                    return this.inventoryCapabilities[0].cast();
                }
                if (side == Direction.DOWN) {
                    return this.inventoryCapabilities[1].cast();
                }
                return this.inventoryCapabilities[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InsaniumReprocessorTileEntity tile) {
        boolean mark = false;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            for (int i = 0; i < 4; ++i) {
                if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                    tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                    if (tile.fuelItemValue > 0) {
                        tile.fuelLeft = tile.fuelItemValue *= 20;
                        tile.inventory.setStackInSlot(1, StackHelper.shrink((ItemStack)tile.inventory.getStackInSlot(1), (int)1, (boolean)false));
                        mark = true;
                    }
                }
                if (tile.fuelLeft <= 0) continue;
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, 23040), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        if (tile.energy.getEnergyStored() >= 11520) {
            for (int i = 0; i < Math.min(tile.energy.getEnergyStored() / 11520, 4); ++i) {
                ItemStack input = tile.inventory.getStackInSlot(0);
                ItemStack output = tile.inventory.getStackInSlot(2);
                if (!input.m_41619_()) {
                    if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.inventory)) {
                        IReprocessorRecipe recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.REPROCESSOR.get(), tile.inventory.toIInventory(), level).orElse(null);
                        ReprocessorRecipe reprocessorRecipe = tile.recipe = recipe instanceof ReprocessorRecipe ? (ReprocessorRecipe)recipe : null;
                    }
                    if (tile.recipe == null) break;
                    ItemStack recipeOutput = tile.recipe.assemble((IItemHandler)tile.inventory, level.m_9598_());
                    if (recipeOutput.m_41619_() || !output.m_41619_() && !StackHelper.canCombineStacks((ItemStack)output, (ItemStack)recipeOutput)) continue;
                    tile.progress = 0;
                    tile.energy.extractEnergy(11520, false);
                    tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)tile.inventory.getStackInSlot(0), (int)1, (boolean)false));
                    ItemStack result = StackHelper.combineStacks((ItemStack)output, (ItemStack)recipeOutput);
                    tile.inventory.setStackInSlot(2, result);
                    mark = true;
                    continue;
                }
                if (tile.recipe == null) break;
                tile.recipe = null;
                mark = true;
                break;
            }
        }
        if (mark) {
            tile.setChangedAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = BaseItemStackHandler.create((int)3, (Runnable)onContentsChanged);
        inventory.setOutputSlots(new int[]{2});
        return inventory;
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return true;
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.m_58399_((ItemStack)stack);
        }
        return false;
    }
}

