/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl;

import java.util.Arrays;
import java.util.Objects;
import me.srrapero720.chloride.ChlorideConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FrameTimer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chloride", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Overlay {
    private static final FPSDisplayBuilder DISPLAY = new FPSDisplayBuilder();
    private static final Component MSG_FPS = Component.m_237115_((String)"chloride.interface.fps");
    private static final Component MSG_MIN = Component.m_237115_((String)"chloride.interface.fps.min");
    private static final Component MSG_AVG = Component.m_237115_((String)"chloride.interface.fps.avg");
    private static final Component MSG_GPU = Component.m_237115_((String)"chloride.interface.fps.gpu");
    private static final Component MSG_MEM = Component.m_237115_((String)"chloride.interface.fps.mem");
    private static int fps = -1;
    private static int minFPS = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;
    private static final int[] avgCount = new int[24];
    private static boolean avgFilled = false;
    private static int avgIndex = 0;

    public static void pushAvgFps(int value) {
        if (avgIndex == avgCount.length) {
            avgIndex = 0;
            avgFilled = true;
        }
        if (!avgFilled) {
            Arrays.fill(avgCount, avgIndex, avgCount.length, value);
        }
        Overlay.avgCount[Overlay.avgIndex++] = value;
    }

    public static int calculateAverage() {
        int times = 0;
        for (int i : avgCount) {
            times += i;
        }
        return times / avgCount.length;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderOverlayItem(RenderGuiOverlayEvent.Pre event) {
        if (!event.getOverlay().id().m_135815_().equals("debug_text")) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92065_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        fps = mc.m_260875_();
        minFPS = Overlay.minFPS(mc);
        memUsage = (int)(Overlay.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        gpuPercent = Math.min((int)mc.m_231464_(), 100);
        avgFPS = Overlay.calculateAverage();
        Overlay.renderFPSChar(mc, event.getGuiGraphics(), mc.f_91062_, event.getWindow().m_85449_());
    }

    private static void renderFPSChar(Minecraft mc, GuiGraphics graphics, Font font, double scale) {
        if (mc.f_91066_.f_92063_ || mc.f_91066_.f_92065_) {
            return;
        }
        FPS mode = ChlorideConfig.fpsDisplayMode;
        FPSDetails systemMode = ChlorideConfig.fpsDisplaySystemMode;
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode) {
            case SIMPLE: {
                DISPLAY.append(Overlay.colorByLow(fps)).add(Overlay.fix(fps)).add(" ").add(MSG_FPS.getString()).add(ChatFormatting.RESET);
                break;
            }
            case ADVANCED: {
                DISPLAY.append(Overlay.colorByLow(fps)).add(Overlay.fix(fps)).add(ChatFormatting.RESET);
                DISPLAY.append(Overlay.colorByLow(minFPS)).add(MSG_MIN).add(" ").add(Overlay.fix(minFPS)).add(ChatFormatting.RESET);
                DISPLAY.append(Overlay.colorByLow(avgFPS)).add(MSG_AVG).add(" ").add(Overlay.fix(avgFPS)).add(ChatFormatting.RESET);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode) {
            case GPU_ONLY: {
                DISPLAY.append(Overlay.colorByPercent(gpuPercent)).add(MSG_GPU).add(" ").add(Overlay.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case RAM_ONLY: {
                DISPLAY.append(Overlay.colorByPercent(memUsage)).add(MSG_MEM).add(" ").add(Overlay.fix(memUsage)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case ALL: {
                DISPLAY.append(Overlay.colorByPercent(gpuPercent)).add(MSG_GPU).add(" ").add(Overlay.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                DISPLAY.append(Overlay.colorByPercent(memUsage)).add(MSG_MEM).add(" ").add(Overlay.fix(memUsage)).add("%").add(ChatFormatting.RESET);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float marginX = scale > 0.0 ? (float)ChlorideConfig.fpsDisplayMargin / (float)scale : (float)ChlorideConfig.fpsDisplayMargin;
        float marginY = scale > 0.0 ? (float)ChlorideConfig.fpsDisplayVMargin / (float)scale : (float)ChlorideConfig.fpsDisplayVMargin;
        String displayString = DISPLAY.toString();
        float maxPosX = graphics.m_280182_() - font.m_92895_(displayString);
        int n = graphics.m_280206_();
        Objects.requireNonNull(font);
        float maxPosY = n - 9;
        float posX = switch (ChlorideConfig.fpsDisplayAlign) {
            default -> throw new IncompatibleClassChangeError();
            case FPSAlign.LEFT -> marginX;
            case FPSAlign.CENTER -> maxPosX / 2.0f;
            case FPSAlign.RIGHT -> maxPosX - marginX;
        };
        float posY = switch (ChlorideConfig.fpsDisplayVAlign) {
            default -> throw new IncompatibleClassChangeError();
            case FPSVAlign.TOP -> marginY;
            case FPSVAlign.CENTER -> maxPosY / 2.0f;
            case FPSVAlign.BOTTOM -> maxPosY - marginY;
        };
        graphics.m_280168_().m_85836_();
        if (ChlorideConfig.fpsDisplayShadow) {
            int n2 = (int)posX - 2;
            int n3 = (int)posY - 2;
            int n4 = (int)posX + font.m_92895_(displayString) + 2;
            Objects.requireNonNull(font);
            graphics.m_280509_(n2, n3, n4, (int)(posY + 9.0f) + 1, -1873784752);
            graphics.m_280262_();
        }
        graphics.drawString(font, displayString, posX, posY, -1, true);
        DISPLAY.release();
        graphics.m_280168_().m_85849_();
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    private static int minFPS(Minecraft mc) {
        FrameTimer timer = mc.m_91293_();
        int start = timer.m_13754_();
        int end = timer.m_13761_();
        if (end == start) {
            return minFPS;
        }
        int fps = mc.m_260875_();
        if (fps <= 0) {
            fps = 1;
        }
        long[] frames = timer.m_13764_();
        long maxNS = (long)(1.0 / (double)fps * 1.0E9);
        long totalNS = 0L;
        int index = Math.floorMod(end - 1, frames.length);
        while (index != start && (double)totalNS < 1.0E9) {
            long timeNs = frames[index];
            if (timeNs > maxNS) {
                maxNS = timeNs;
            }
            totalNS += timeNs;
            index = Math.floorMod(index - 1, frames.length);
        }
        return (int)(1.0 / ((double)maxNS / 1.0E9));
    }

    public static ChatFormatting colorByLow(int usage) {
        return usage < 9 ? ChatFormatting.DARK_RED : (usage < 16 ? ChatFormatting.RED : (usage < 30 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static ChatFormatting colorByPercent(int usage) {
        return usage >= 100 ? ChatFormatting.DARK_RED : (usage >= 90 ? ChatFormatting.RED : (usage >= 75 ? ChatFormatting.GOLD : ChatFormatting.RESET));
    }

    public static long ramUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long bytesToMB(long input) {
        return input / 1024L / 1024L;
    }

    public static enum FPS {
        OFF,
        SIMPLE,
        ADVANCED;


        public boolean off() {
            return this == OFF;
        }
    }

    public static enum FPSDetails {
        OFF,
        ALL,
        GPU_ONLY,
        RAM_ONLY;


        public boolean ram() {
            return this == RAM_ONLY || this == ALL;
        }

        public boolean gpu() {
            return this == GPU_ONLY || this == ALL;
        }

        public boolean off() {
            return this == OFF;
        }
    }

    private static class FPSDisplayBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean split = false;
        private boolean divisor = false;

        private FPSDisplayBuilder() {
        }

        public FPSDisplayBuilder append(String param) {
            if (this.split) {
                this.builder.append(" - ");
            }
            if (this.divisor) {
                this.builder.append(" | ");
            }
            this.builder.append(param);
            this.split = false;
            this.divisor = true;
            return this;
        }

        public FPSDisplayBuilder append(ChatFormatting formatting) {
            return this.append(formatting.toString());
        }

        public FPSDisplayBuilder add(int param) {
            this.builder.append(param);
            return this;
        }

        public FPSDisplayBuilder add(String param) {
            this.builder.append(param);
            return this;
        }

        public FPSDisplayBuilder add(Component component) {
            return this.add(component.getString());
        }

        public FPSDisplayBuilder add(ChatFormatting formatting) {
            return this.add(formatting.toString());
        }

        public void split() {
            this.split = true;
            this.divisor = false;
        }

        public boolean isEmpty() {
            return this.builder.isEmpty();
        }

        public void release() {
            this.builder = new StringBuilder();
            this.split = false;
            this.divisor = false;
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static enum FPSAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum FPSVAlign {
        TOP,
        CENTER,
        BOTTOM;

    }
}

